import { BinaryStream, OutputBinaryStream } from "node-opcua-binary-stream";
import { NodeId } from "node-opcua-nodeid";
import { Argument } from "node-opcua-service-call";
import { StatusCode } from "node-opcua-status-code";
import { Variant } from "node-opcua-variant";
import { DataType } from "node-opcua-variant";
import { IAddressSpace, UAMethod } from "node-opcua-address-space-base";
export interface ArgumentDef {
    dataType: DataType;
    valueRank?: undefined | number;
}
export declare function encode_ArgumentList(definition: ArgumentDef[], args: any[], stream: OutputBinaryStream): void;
export declare function decode_ArgumentList(definition: ArgumentDef[], stream: BinaryStream): any[];
export declare function binaryStoreSize_ArgumentList(description: ArgumentDef[], args: any[]): number;
export declare function getMethodDeclaration_ArgumentList(addressSpace: IAddressSpace, objectId: NodeId, methodId: NodeId): {
    statusCode: StatusCode;
    methodDeclaration?: UAMethod;
};
/**
 * @private
 */
export declare function isArgumentValid(addressSpace: IAddressSpace, argDefinition: Argument, arg: Variant): boolean;
/**
*/
export declare function verifyArguments_ArgumentList(addressSpace: IAddressSpace, methodInputArguments: Argument[], inputArguments: Variant[]): {
    inputArgumentResults?: StatusCode[];
    statusCode: StatusCode;
};
