"use strict";
// tslint:disable: no-console
// tslint:disable: object-literal-sort-keys
// tslint:disable: no-shadowed-variable
/**
 * @module opcua.server.simulation
 *
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.build_address_space_for_conformance_testing = build_address_space_for_conformance_testing;
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_factory_1 = require("node-opcua-factory");
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const ec = __importStar(require("node-opcua-basic-types"));
const node_opcua_data_model_2 = require("node-opcua-data-model");
const node_opcua_data_access_1 = require("node-opcua-data-access");
const testHelpers_1 = require("node-opcua-address-space/testHelpers");
const node_opcua_debug_1 = require("node-opcua-debug");
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
function defaultValidator( /*value*/) {
    return true;
}
function getValidatorFuncForType(dataType) {
    const f = ec["isValid" + dataType];
    return f || defaultValidator;
}
function getRandomFuncForType(dataType) {
    const dataTypeName = node_opcua_variant_1.DataType[dataType];
    const f = ec["random" + dataTypeName];
    if (f) {
        return f;
    }
    switch (dataTypeName) {
        case "Variant":
            return () => {
                return new node_opcua_variant_1.Variant();
            };
        case "QualifiedName":
            return () => {
                return new node_opcua_data_model_2.QualifiedName({ name: (0, node_opcua_basic_types_1.randomString)() });
            };
        case "LocalizedText":
            return () => {
                return new node_opcua_data_model_2.LocalizedText({ text: (0, node_opcua_basic_types_1.randomString)() });
            };
        case "XmlElement":
            return () => {
                const element = (0, node_opcua_basic_types_1.randomString)();
                const content = (0, node_opcua_basic_types_1.randomString)();
                return "<" + element + ">" + content + "</" + element + ">";
            };
        default:
            // istanbul ignore next
            throw new Error("Cannot find random" + dataTypeName + "() func anywhere");
    }
}
function _findDataType(dataTypeName) {
    const builtInDataTypeName = (0, node_opcua_factory_1.findBuiltInType)(dataTypeName);
    const dataType = node_opcua_variant_1.DataType[builtInDataTypeName.name];
    // istanbul ignore next
    if (!dataType) {
        throw new Error(" dataType " + dataTypeName + " must exists");
    }
    return dataType;
}
function validate_value_or_array(isArray, variantValue, validatorFunc) {
    (0, node_opcua_assert_1.assert)(typeof validatorFunc === "function");
    let i;
    let value;
    if (isArray) {
        const n = Math.min(10, variantValue.length);
        for (i = 0; i < n; i++) {
            value = variantValue[i];
            // istanbul ignore next
            if (!validatorFunc(value)) {
                throw new Error("default value must be valid for dataType " + variantValue + " at index " + i + " got " + value);
            }
        }
    }
    else {
        // scalar
        // istanbul ignore next
        if (!validatorFunc(variantValue)) {
            throw new Error("default value must be valid for dataType " + variantValue);
        }
    }
}
function makeVariant(dataTypeName, arrayType, dimensions, current_value) {
    const dataType = _findDataType(dataTypeName);
    const validatorFunc = getValidatorFuncForType(dataType);
    const isArray = arrayType === node_opcua_variant_1.VariantArrayType.Array || arrayType === node_opcua_variant_1.VariantArrayType.Matrix;
    validate_value_or_array(isArray, current_value, validatorFunc);
    const variant = new node_opcua_variant_1.Variant({
        dataType,
        arrayType,
        dimensions,
        value: current_value
    });
    return variant;
}
// eslint-disable-next-line max-params
function _add_variable(namespace, parent, varName, dataTypeName, current_value, valueRank, arrayDimensions, extra_name) {
    (0, node_opcua_assert_1.assert)(typeof extra_name === "string");
    const arrayType = valueRank <= 0 ? node_opcua_variant_1.VariantArrayType.Scalar : valueRank === 1 ? node_opcua_variant_1.VariantArrayType.Array : node_opcua_variant_1.VariantArrayType.Matrix;
    const variant = makeVariant(dataTypeName, arrayType, arrayDimensions, current_value);
    const name = varName + extra_name;
    const nodeId = parent.nodeId.toString() + "_" + varName + extra_name;
    const placeholder = {
        variant
    };
    const variable = namespace.addVariable({
        browseName: name,
        componentOf: parent,
        dataType: varName,
        description: { locale: "en", text: name },
        nodeId,
        valueRank,
        arrayDimensions,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead | CurrentWrite"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead | CurrentWrite"),
        value: variant
    });
    variable._backdoor_placeholder = placeholder;
    return variable;
}
function add_scalar_variable(namespace, parent, name, realType, default_value, extra_name) {
    (0, node_opcua_assert_1.assert)(typeof extra_name === "string");
    const initialValue = typeof default_value === "function" ? default_value() : default_value;
    const variable = _add_variable(namespace, parent, name, realType, initialValue, -1, null, extra_name);
    (0, node_opcua_assert_1.assert)(variable.valueRank === -1);
    // tslint:disable-next-line: no-bitwise
    (0, node_opcua_assert_1.assert)(variable.accessLevel === node_opcua_data_model_1.AccessLevelFlag.CurrentRead + node_opcua_data_model_1.AccessLevelFlag.CurrentWrite);
    // tslint:disable-next-line: no-bitwise
    (0, node_opcua_assert_1.assert)(variable.userAccessLevel === node_opcua_data_model_1.AccessLevelFlag.CurrentRead + node_opcua_data_model_1.AccessLevelFlag.CurrentWrite);
    (0, node_opcua_assert_1.assert)(variable.historizing === false);
    return variable;
}
function add_array_variable(namespace, parent, dataTypeName, default_value, realTypeName, arrayLength, extra_name) {
    (0, node_opcua_assert_1.assert)(typeof dataTypeName === "string");
    (0, node_opcua_assert_1.assert)(typeof realTypeName === "string");
    // istanbul ignore next
    if (!node_opcua_variant_1.DataType[realTypeName]) {
        warningLog("dataTypeName", dataTypeName);
        warningLog("realTypeName", realTypeName);
    }
    (0, node_opcua_assert_1.assert)(node_opcua_variant_1.DataType[realTypeName], " expecting a valid real type");
    arrayLength = arrayLength || 10;
    const local_defaultValue = typeof default_value === "function" ? default_value() : default_value;
    const current_value = (0, node_opcua_variant_1.buildVariantArray)(node_opcua_variant_1.DataType[realTypeName], arrayLength, local_defaultValue);
    const variable = _add_variable(namespace, parent, dataTypeName, realTypeName, current_value, 1, null, extra_name);
    (0, node_opcua_assert_1.assert)(variable.valueRank === 1);
    (0, node_opcua_assert_1.assert)(variable.accessLevel === node_opcua_data_model_1.AccessLevelFlag.CurrentRead + node_opcua_data_model_1.AccessLevelFlag.CurrentWrite);
    (0, node_opcua_assert_1.assert)(variable.userAccessLevel === node_opcua_data_model_1.AccessLevelFlag.CurrentRead + node_opcua_data_model_1.AccessLevelFlag.CurrentWrite);
    (0, node_opcua_assert_1.assert)(variable.historizing === false);
}
// eslint-disable-next-line max-params
function add_multi_dimensional_array_variable(namespace, parent, dataTypeName, default_value, realTypeName, nbRows, nbCols, extra_name) {
    (0, node_opcua_assert_1.assert)(typeof dataTypeName === "string");
    (0, node_opcua_assert_1.assert)(typeof realTypeName === "string");
    // istanbul ignore next
    if (!node_opcua_variant_1.DataType[realTypeName]) {
        debugLog("dataTypeName", dataTypeName);
        debugLog("realTypeName", realTypeName);
    }
    (0, node_opcua_assert_1.assert)(node_opcua_variant_1.DataType[realTypeName], " expecting a valid real type");
    nbRows = nbRows || 6;
    nbCols = nbCols || 2;
    const local_defaultValue = typeof default_value === "function" ? default_value() : default_value;
    const current_value = (0, node_opcua_variant_1.buildVariantArray)(node_opcua_variant_1.DataType[realTypeName], nbRows * nbCols, local_defaultValue);
    const variable = _add_variable(namespace, parent, dataTypeName, realTypeName, current_value, 2, [nbRows, nbCols], extra_name);
    (0, node_opcua_assert_1.assert)(variable.valueRank === 2);
    (0, node_opcua_assert_1.assert)(variable.accessLevel === node_opcua_data_model_1.AccessLevelFlag.CurrentRead + node_opcua_data_model_1.AccessLevelFlag.CurrentWrite);
    (0, node_opcua_assert_1.assert)(variable.userAccessLevel === node_opcua_data_model_1.AccessLevelFlag.CurrentRead + node_opcua_data_model_1.AccessLevelFlag.CurrentWrite);
    (0, node_opcua_assert_1.assert)(variable.historizing === false);
}
function add_mass_variables_of_type(namespace, parent, dataTypeName, default_value, realType) {
    // Mass Mass_Boolean -> Mass_Boolean_Boolean_00 ...
    const nodeName = "Scalar_Mass_" + dataTypeName;
    const scalarMass_Type = namespace.addObject({
        browseName: nodeName,
        description: "This folder will contain 100 items per supported data-type.",
        nodeId: "s=" + nodeName,
        organizedBy: parent
    });
    for (let i = 0; i <= 99; i++) {
        const extra_name = "_" + i.toString().padStart(2, "0");
        const local_defaultValue = typeof default_value === "function" ? default_value() : default_value;
        _add_variable(namespace, scalarMass_Type, dataTypeName, realType, local_defaultValue, -1, null, extra_name);
    }
}
function add_mass_variables(namespace, scalarFolder) {
    const scalarMass = namespace.addFolder(scalarFolder, {
        browseName: "Scalar_Mass",
        description: "This folder will contain 100 items per supported data-type.",
        nodeId: "s=Scalar_Mass"
    });
    typeAndDefaultValue.forEach((e) => {
        const dataType = e.type;
        const realType = e.realType || dataType;
        add_mass_variables_of_type(namespace, scalarMass, dataType, e.defaultValue, realType);
    });
}
const typeAndDefaultValue = [
    { type: "Boolean", defaultValue: false },
    { type: "ByteString", defaultValue: Buffer.from("OPCUA") },
    { type: "DateTime", defaultValue: ec.getMinOPCUADate() },
    { type: "Double", defaultValue: 0.0 },
    { type: "Float", defaultValue: 0.0 },
    { type: "Guid", defaultValue: node_opcua_basic_types_1.emptyGuid },
    { type: "SByte", defaultValue: 0 },
    { type: "Int16", defaultValue: 0 },
    { type: "Int32", defaultValue: 0 },
    {
        type: "NodeId",
        defaultValue() {
            return (0, node_opcua_nodeid_1.coerceNodeId)("ns=" + 3 + ";g=00000000-0000-0000-0000-000000000023");
        }
    },
    { type: "String", defaultValue: "OPCUA" },
    { type: "Byte", defaultValue: 0 },
    { type: "UInt16", defaultValue: 0 },
    { type: "UInt32", defaultValue: 0 },
    { type: "Duration", realType: "Double", defaultValue: 0.0 },
    { type: "Number", realType: "UInt16", defaultValue: 0 }, // Number is abstract
    { type: "Integer", realType: "Int64", defaultValue: 0 }, // because Integer is abstract , we choose Int32
    { type: "UInteger", realType: "UInt64", defaultValue: 0 },
    {
        type: "UtcTime",
        realType: "DateTime",
        defaultValue() {
            return new Date();
        }
    },
    // xx        {  type: "Int64",         defaultValue:  0},
    { type: "LocaleId", realType: "String", defaultValue: "" },
    {
        type: "LocalizedText",
        defaultValue() {
            return new node_opcua_data_model_2.LocalizedText({});
        }
    },
    {
        type: "QualifiedName",
        defaultValue() {
            return new node_opcua_data_model_2.QualifiedName();
        }
    },
    { type: "UInt64", defaultValue: [0, 0] },
    { type: "Int64", defaultValue: [0, 0] },
    // xx {type: "Variant",   realType:   "Variant", defaultValue:  {} },
    { type: "XmlElement", defaultValue: "<string1>OPCUA</string1>" },
    { type: "ImageBMP", realType: "ByteString", defaultValue: null },
    { type: "ImageGIF", realType: "ByteString", defaultValue: null },
    { type: "ImageJPG", realType: "ByteString", defaultValue: null },
    { type: "ImagePNG", realType: "ByteString", defaultValue: null }
    // {type: "Enumeration", realType: "UInt32" , defaultValue:0}
];
function add_simulation_variables(namespace, scalarFolder) {
    let values_to_change = [];
    function add_simulation_variable(parent, dataTypeName, defaultValue, realTypeName) {
        // the type of the default value
        realTypeName = realTypeName || dataTypeName;
        const dataType = _findDataType(realTypeName);
        const randomFunc = getRandomFuncForType(dataType);
        // istanbul ignore next
        if (typeof randomFunc !== "function") {
            throw new Error("a random function must exist for basicType " + dataTypeName);
        }
        const variable = _add_variable(namespace, parent, dataTypeName, realTypeName, defaultValue, -1, null, "");
        const value_to_change = {
            dataType,
            randomFunc,
            variable
        };
        values_to_change.push(value_to_change);
        return variable;
    }
    const simulation = namespace.addObject({
        browseName: "Scalar_Simulation",
        description: "This folder will contain one item per supported data-type.",
        nodeId: "s=Scalar_Simulation",
        organizedBy: scalarFolder
    });
    // add simulation variables
    typeAndDefaultValue.forEach((e) => {
        const dataType = e.type;
        const defaultValue = typeof e.defaultValue === "function" ? e.defaultValue() : e.defaultValue;
        const realType = e.realType || dataType;
        add_simulation_variable(simulation, dataType, defaultValue, realType);
    });
    // add management nodes
    let interval = 2000;
    let enabled = true;
    let timer;
    function change_randomly() {
        values_to_change.forEach((element) => {
            const variant = element.variable._backdoor_placeholder.variant;
            variant.value = element.randomFunc();
            element.variable.setValueFromSource(variant);
        });
    }
    function delete_Timer() {
        // delete previous timer if any
        if (timer) {
            clearInterval(timer);
            timer = undefined;
        }
    }
    function install_Timer() {
        delete_Timer();
        (0, node_opcua_assert_1.assert)(!timer);
        if (enabled) {
            timer = setInterval(() => {
                change_randomly();
            }, interval);
        }
    }
    function tearDown_Timer() {
        delete_Timer();
        values_to_change = [];
    }
    const intervalVariable = namespace.addVariable({
        browseName: "Interval",
        componentOf: simulation,
        dataType: "UInt16",
        description: { locale: "en", text: "The rate (in msec) of change for all Simulated items." },
        nodeId: "s=Scalar_Simulation_Interval",
        value: new node_opcua_variant_1.Variant({
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            dataType: node_opcua_variant_1.DataType.UInt16,
            value: interval
        })
    });
    intervalVariable.on("value_changed", (dataValue /*,indexRange*/) => {
        const variant = dataValue.value;
        (0, node_opcua_assert_1.assert)(variant instanceof node_opcua_variant_1.Variant);
        (0, node_opcua_assert_1.assert)((0, node_opcua_basic_types_1.isValidUInt16)(variant.value), " value must be valid for dataType");
        interval = variant.value;
        install_Timer();
    });
    const enabledVariable = namespace.addVariable({
        componentOf: simulation,
        browseName: "Enabled",
        description: { locale: "en", text: "Enabled" },
        nodeId: "s=Scalar_Simulation_Enabled",
        dataType: "Boolean",
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Boolean,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: enabled
        })
    });
    enabledVariable.on("value_changed", (dataValue /*,indexRange*/) => {
        const variant = dataValue.value;
        (0, node_opcua_assert_1.assert)(variant instanceof node_opcua_variant_1.Variant);
        (0, node_opcua_assert_1.assert)((0, node_opcua_basic_types_1.isValidBoolean)(variant.value), " value must be valid for dataType");
        enabled = variant.value;
        install_Timer();
    });
    install_Timer();
    const addressSpace = namespace.addressSpace;
    addressSpace.registerShutdownTask(tearDown_Timer);
}
async function add_static_variables(namespace, scalarFolder) {
    const staticScalarFolder = namespace.addObject({
        organizedBy: scalarFolder,
        browseName: "Scalars",
        description: "This folder will contain one item per supported data-type.",
        nodeId: "s=Static_Scalar"
    });
    // add statics scalar Variables
    typeAndDefaultValue.forEach((e) => {
        const dataType = e.type;
        const realType = e.realType || dataType;
        const defaultValue = typeof e.defaultValue === "function" ? e.defaultValue() : e.defaultValue;
        add_scalar_variable(namespace, staticScalarFolder, dataType, realType, defaultValue, "");
    });
    function setImage2(imageType, filename) {
        const fullPath = path_1.default.join(__dirname, "../data", filename);
        const imageNode = namespace.findNode("s=Static_Scalar_Image" + imageType);
        const options = {
            refreshFunc: (callback) => {
                fs_1.default.readFile(fullPath, (err, data) => {
                    if (err) {
                        return callback(null, new node_opcua_data_value_1.DataValue({
                            statusCode: node_opcua_status_code_1.StatusCodes.BadDataUnavailable,
                            value: { dataType: "ByteString", value: null }
                        }));
                    }
                    (0, node_opcua_assert_1.assert)(data instanceof Buffer);
                    callback(null, new node_opcua_data_value_1.DataValue({ value: { dataType: "ByteString", value: data } }));
                });
            }
        };
        imageNode.bindVariable(options, /*overwrite=*/ true);
    }
    setImage2;
    async function setImage(imageType, filename) {
        const fullPath = path_1.default.join(__dirname, "../data", filename);
        const imageNode = namespace.findNode("s=Static_Scalar_Image" + imageType);
        try {
            const data = await fs_1.default.promises.readFile(fullPath);
            imageNode.setValueFromSource(new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.ByteString, value: data }));
        }
        catch (err) {
            errorLog("cannot load file =", fullPath);
        }
    }
    await setImage("BMP", "image.bmp");
    await setImage("PNG", "tux.png");
    await setImage("GIF", "gif-anime.gif");
    await setImage("JPG", "tiger.jpg");
    // add static Array Variables
    const staticArraysFolders = namespace.addObject({
        organizedBy: scalarFolder,
        browseName: "Arrays",
        description: "Single dimension, suggested size of 10-elements per array. Unsupported types will be missing from the address-space.",
        nodeId: "s=Static_Array"
    });
    // add static Array
    typeAndDefaultValue.forEach((e) => {
        const dataType = e.type;
        const realType = e.realType || dataType;
        add_array_variable(namespace, staticArraysFolders, dataType, e.defaultValue, realType, 10, "");
    });
    // add static MultiDimension Array Variables
    const staticMultiDimensionalArrays = namespace.addObject({
        organizedBy: scalarFolder,
        browseName: "Multi-Dimensional Arrays",
        description: "Single dimension, suggested size of 10-elements per array. Unsupported types will be missing from the address-space.",
        nodeId: "s=Static_MultiDimensional_Array"
    });
    // add static Array
    typeAndDefaultValue.forEach((e) => {
        const dataType = e.type;
        const realType = e.realType || dataType;
        add_multi_dimensional_array_variable(namespace, staticMultiDimensionalArrays, dataType, e.defaultValue, realType, 2, 3, "");
    });
}
function add_access_right_variables(namespace, parentFolder) {
    const accessRight_Folder = namespace.addFolder(parentFolder, {
        browseName: "AccessRight",
        description: "Folder containing various nodes with different access right behavior",
        nodeId: "s=AccessRight"
    });
    const accessLevel_All_Folder = namespace.addFolder(accessRight_Folder, {
        browseName: "AccessLevel",
        description: "Various node with different access right behavior",
        nodeId: "s=AccessLevel"
    });
    let name = "AccessLevel_CurrentRead";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead"),
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Int32,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: 36
        })
    });
    name = "AccessLevel_CurrentWrite";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentWrite"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentWrite"),
        value: {}
    });
    name = "AccessLevel_CurrentRead_NotUser";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)(""),
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Int32,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: 36
        })
    });
    name = "AccessLevel_CurrentWrite_NotUser";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentWrite | CurrentRead"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead"),
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Int32,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: 36
        })
    });
    name = "AccessLevel_CurrentRead_NotCurrentWrite";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentRead"),
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Int32,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: 36
        })
    });
    name = "AccessLevel_CurrentWrite_NotCurrentRead";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentWrite"),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)("CurrentWrite"),
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Int32,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: 36
        })
    });
    name = "AccessLevel_DeniedAll";
    namespace.addVariable({
        componentOf: accessLevel_All_Folder,
        browseName: name,
        description: { locale: "en", text: name },
        nodeId: "s=" + name,
        dataType: "Int32",
        valueRank: -1,
        accessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)(""),
        userAccessLevel: (0, node_opcua_data_model_1.makeAccessLevelFlag)(""),
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.Int32,
            arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
            value: 36
        })
    });
}
function add_node_with_references(namespace, simulation_folder) {
    const parent = simulation_folder;
    const referenceFolder = namespace.addObject({
        browseName: "References",
        nodeId: "s=Demo.CTT.References",
        organizedBy: parent,
        typeDefinition: "FolderType"
    });
    (() => {
        const has3ForwardReferences1 = namespace.addObject({
            browseName: "Has3ForwardReferences1",
            nodeId: "s=Demo.CTT.References.Has3ForwardReferences1",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        const referenceNode1 = namespace.addVariable({
            browseName: "ReferenceNode1",
            componentOf: has3ForwardReferences1,
            dataType: "UInt32"
        });
        referenceNode1;
        const referenceNode2 = namespace.addVariable({
            browseName: "ReferenceNode2",
            componentOf: has3ForwardReferences1,
            dataType: "UInt32"
        });
        referenceNode2;
        const referenceNode3 = namespace.addVariable({
            browseName: "ReferenceNode3",
            componentOf: has3ForwardReferences1,
            dataType: "UInt32"
        });
        referenceNode3;
    })();
    (() => {
        const has3ForwardReferences2 = namespace.addObject({
            browseName: "Has3ForwardReferences2",
            nodeId: "s=Demo.CTT.References.Has3ForwardReferences2",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        has3ForwardReferences2;
        const baseDataVariable = namespace.addVariable({
            browseName: "BaseDataVariable",
            componentOf: has3ForwardReferences2,
            dataType: "UInt32"
        });
        baseDataVariable;
        namespace.addMethod(has3ForwardReferences2, {
            browseName: "Method1"
        });
        namespace.addMethod(has3ForwardReferences2, {
            browseName: "Method2"
        });
        namespace.addMethod(has3ForwardReferences2, {
            browseName: "Method3"
        });
        namespace.addVariable({
            browseName: "Property",
            propertyOf: has3ForwardReferences2,
            dataType: "UInt32"
        });
    })();
    (() => {
        const has3ForwardReferences3 = namespace.addObject({
            browseName: "Has3ForwardReferences3",
            nodeId: "s=Demo.CTT.References.Has3ForwardReferences3",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        const referencedNode1 = namespace.addFolder(has3ForwardReferences3, "ReferencedNode1");
        const referencedNode2 = namespace.addFolder(has3ForwardReferences3, "ReferencedNode2");
        const referencedNode3 = namespace.addFolder(has3ForwardReferences3, "ReferencedNode3");
        const has3InverseReferences = namespace.addObject({
            browseName: "Has3InverseReferences",
            nodeId: "s=Demo.CTT.References.Has3InverseReferences",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        referencedNode1.addReference({
            referenceType: "Organizes",
            nodeId: has3InverseReferences
        });
        referencedNode2.addReference({
            referenceType: "Organizes",
            nodeId: has3InverseReferences
        });
        referencedNode3.addReference({
            referenceType: "Organizes",
            nodeId: has3InverseReferences
        });
    })();
    (() => {
        const has3ForwardReferences4 = namespace.addObject({
            browseName: "Has3ForwardReferences4",
            nodeId: "s=Demo.CTT.References.Has3ForwardReferences4",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        namespace.addVariable({
            browseName: "ReferenceNode1",
            propertyOf: has3ForwardReferences4,
            dataType: "UInt32"
        });
        namespace.addVariable({
            browseName: "ReferenceNode2",
            propertyOf: has3ForwardReferences4,
            dataType: "UInt32"
        });
        namespace.addVariable({
            browseName: "ReferenceNode3",
            propertyOf: has3ForwardReferences4,
            dataType: "UInt32"
        });
    })();
    (() => {
        const has3ForwardReferences5 = namespace.addObject({
            browseName: "Has3ForwardReferences5",
            nodeId: "s=Demo.CTT.References.Has3ForwardReferences5",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        namespace.addFolder(has3ForwardReferences5, {
            browseName: "ReferenceNode1"
        });
        namespace.addVariable({
            browseName: "ReferenceNode2",
            propertyOf: has3ForwardReferences5,
            dataType: "UInt32"
        });
        namespace.addMethod(has3ForwardReferences5, {
            browseName: "ReferenceNode3"
        });
    })();
    (() => {
        const hasInverseAndForwardReferences = namespace.addObject({
            browseName: "HasInverseAndForwardReferences",
            nodeId: "s=Demo.CTT.References.HasInverseAndForwardReferences",
            componentOf: referenceFolder,
            typeDefinition: "FolderType"
        });
        const nodeId = namespace.addFolder(hasInverseAndForwardReferences, {
            browseName: "ReferenceNode1"
        });
        hasInverseAndForwardReferences.addReference({
            nodeId,
            referenceType: "AlarmGroupMember"
        });
    })();
    const hasReferencesWithDifferentParentTypes = namespace.addObject({
        browseName: "HasReferencesWithDifferentParentTypes",
        nodeId: "s=Demo.CTT.References.HasReferencesWithDifferentParentTypes",
        componentOf: referenceFolder,
        typeDefinition: "FolderType"
    });
    hasReferencesWithDifferentParentTypes;
    (() => {
        const hasReferencesOfAReferenceTypeAndSubType = namespace.addObject({
            browseName: "HasReferencesOfAReferenceTypeAndSubType",
            nodeId: "s=Demo.CTT.References.HasReferencesOfAReferenceTypeAndSubType",
            typeDefinition: "FolderType",
            componentOf: referenceFolder
        });
        namespace.addVariable({
            browseName: "ReferenceNode1",
            propertyOf: hasReferencesOfAReferenceTypeAndSubType,
            dataType: "UInt32"
        });
        namespace.addVariable({
            browseName: "ReferenceNode2",
            propertyOf: hasReferencesOfAReferenceTypeAndSubType,
            dataType: "UInt32"
        });
        namespace.addVariable({
            browseName: "ReferenceNode3",
            propertyOf: hasReferencesOfAReferenceTypeAndSubType,
            dataType: "UInt32"
        });
        namespace.addVariable({
            browseName: "ReferenceNode4",
            propertyOf: hasReferencesOfAReferenceTypeAndSubType,
            dataType: "UInt32"
        });
        for (let i = 0; i < 4; i++) {
            const a = namespace.addObject({
                browseName: "AlarmSuppressionGroup" + i,
                componentOf: referenceFolder
            });
            hasReferencesOfAReferenceTypeAndSubType.addReference({
                nodeId: a,
                referenceType: "HasAlarmSuppressionGroup"
            });
        }
    })();
}
function add_path_10deep(namespace, simulation_folder) {
    let parent = simulation_folder;
    for (let i = 1; i <= 10; i++) {
        const name = "Path_" + i.toString() + "Deep";
        const child = namespace.addObject({
            organizedBy: parent,
            browseName: name,
            description: "A folder at the top of " + i + " elements",
            typeDefinition: "FolderType",
            nodeId: "s=" + name
        });
        parent = child;
    }
}
function add_very_large_array_variables(namespace, objectsFolder) {
    // add statics Array Variables
    const scalarStaticLargeArray = namespace.addObject({
        organizedBy: objectsFolder,
        browseName: "Static_Scalar_Large_Array",
        description: "Single dimension, suggested size of 100k-elements per array.",
        nodeId: "s=Static_Scalar_Large_Array"
    });
    typeAndDefaultValue.forEach((e) => {
        const dataType = e.type;
        const realType = e.realType || dataType;
        add_array_variable(namespace, scalarStaticLargeArray, dataType, e.defaultValue, realType, 50 * 1024, "");
    });
}
//      BaseDataVariableType
//         |
//      DataItemType
//         ^
//         |
//      +----------------+---------------------+
//      |                |                     |
// ArrayItemType   AnalogItemType         DiscreteItemType
//                                             ^
//                                             |
//                +-----------------------------+---------------------------------+
//                |                             |                                 |
//           TwoStateDiscreteType     MultiStateDiscreteType                MultiStateValueDiscreteType
//
function add_analog_data_items(namespace, parentFolder) {
    function _addDataItem(localParentFolder, dataType, initialValue) {
        const name = node_opcua_variant_1.DataType[dataType] + "DataItem";
        const nodeId = "s=" + name;
        const v = namespace.addDataItem({
            componentOf: localParentFolder,
            nodeId,
            browseName: name,
            definition: "(tempA -25) + tempB",
            dataType,
            value: {
                arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
                dataType,
                value: initialValue
            }
        });
        (0, node_opcua_assert_1.assert)(v.nodeId.toString() === `ns=${namespace.index};${nodeId}`, `ns=${namespace.index};${nodeId}` + " " + v.nodeId.toString());
    }
    function makeRange(dataType) {
        let engineeringUnitsRange = { low: -200, high: 200 };
        let instrumentRange = { low: -200, high: 200 };
        if (node_opcua_variant_1.DataType[dataType][0] === "U" || dataType === node_opcua_variant_1.DataType.Byte) {
            engineeringUnitsRange = { low: 10, high: 250 };
            instrumentRange = { low: 10, high: 250 };
        }
        return { engineeringUnitsRange, instrumentRange };
    }
    function _addAnalogDataItem(localParentFolder, dataType, initialValue) {
        const { engineeringUnitsRange, instrumentRange } = makeRange(dataType);
        (0, node_opcua_assert_1.assert)(Array.isArray(initialValue) || (initialValue >= engineeringUnitsRange.low && initialValue <= engineeringUnitsRange.high));
        const name = node_opcua_variant_1.DataType[dataType] + "AnalogDataItem";
        const nodeId = "s=" + name;
        // UAAnalogItem
        // add a UAAnalogItem
        namespace.addAnalogDataItem({
            componentOf: localParentFolder,
            nodeId,
            browseName: name,
            definition: "...",
            valuePrecision: 0.5,
            engineeringUnitsRange,
            instrumentRange,
            engineeringUnits: node_opcua_data_access_1.standardUnits.degree_celsius,
            dataType,
            value: {
                arrayType: node_opcua_variant_1.VariantArrayType.Scalar,
                dataType,
                value: initialValue
            }
        });
    }
    function _addArrayAnalogDataItem(localParentFolder, dataType, initialValue) {
        const name = node_opcua_variant_1.DataType[dataType] + "ArrayAnalogDataItem";
        const nodeId = "s=" + name;
        // UAAnalogItem
        const { engineeringUnitsRange, instrumentRange } = makeRange(dataType);
        // add a UAAnalogItem
        namespace.addAnalogDataItem({
            componentOf: localParentFolder,
            nodeId,
            browseName: name,
            definition: "(tempA -25) + tempB",
            valuePrecision: 0.5,
            engineeringUnitsRange,
            instrumentRange,
            engineeringUnits: node_opcua_data_access_1.standardUnits.degree_celsius,
            dataType,
            value: {
                arrayType: node_opcua_variant_1.VariantArrayType.Array,
                dataType,
                value: [initialValue, initialValue, initialValue, initialValue, initialValue]
            }
        });
    }
    // add statics Array Variables
    const analogItemFolder = namespace.addObject({
        organizedBy: parentFolder,
        browseName: "Simulation_AnalogDataItem",
        typeDefinition: "FolderType",
        nodeId: "s=Simulation_AnalogDataItem"
    });
    const name = "DoubleAnalogDataItemWithEU";
    const nodeId = "s=" + name;
    const { engineeringUnitsRange, instrumentRange } = makeRange(node_opcua_variant_1.DataType.Double);
    namespace.addAnalogDataItem({
        componentOf: analogItemFolder,
        nodeId,
        browseName: name,
        definition: "(tempA -25) + tempB",
        valuePrecision: 0.5,
        engineeringUnitsRange,
        instrumentRange,
        engineeringUnits: node_opcua_data_access_1.standardUnits.degree_celsius,
        dataType: node_opcua_variant_1.DataType.Double,
        value: {
            dataType: node_opcua_variant_1.DataType.Double,
            value: 19.5
        }
    });
    const data = [
        { dataType: node_opcua_variant_1.DataType.Double, value: 3.14 },
        { dataType: node_opcua_variant_1.DataType.Float, value: 3.14 },
        { dataType: node_opcua_variant_1.DataType.Int16, value: -10 },
        { dataType: node_opcua_variant_1.DataType.UInt16, value: 10 },
        { dataType: node_opcua_variant_1.DataType.Int32, value: -100 },
        { dataType: node_opcua_variant_1.DataType.UInt32, value: 100 },
        { dataType: node_opcua_variant_1.DataType.Int64, value: [0, 0] },
        { dataType: node_opcua_variant_1.DataType.UInt64, value: [0, 0] },
        { dataType: node_opcua_variant_1.DataType.Byte, value: 65 },
        { dataType: node_opcua_variant_1.DataType.SByte, value: -23 }
    ];
    data.forEach((e) => {
        _addAnalogDataItem(analogItemFolder, e.dataType, e.value);
    });
    data.forEach((e) => {
        _addDataItem(analogItemFolder, e.dataType, e.value);
    });
    _addDataItem(analogItemFolder, node_opcua_variant_1.DataType.String, "some string");
    _addDataItem(analogItemFolder, node_opcua_variant_1.DataType.DateTime, new Date());
    data.forEach((e) => {
        _addArrayAnalogDataItem(analogItemFolder, e.dataType, e.value);
    });
}
function getDADiscreteTypeFolder(namespace, parentFolder) {
    const name = "Simulation_DA_DiscreteType";
    const nodeId = "s=Simulation_DA_DiscreteType";
    let node = parentFolder.getFolderElementByName(name);
    if (!node) {
        node = namespace.addObject({
            organizedBy: parentFolder,
            typeDefinition: "FolderType",
            browseName: name,
            nodeId
        });
    }
    return node;
}
function add_two_state_discrete_variables(namespace, parentFolder) {
    const DADiscreteTypeFolder = getDADiscreteTypeFolder(namespace, parentFolder);
    const twoStateDiscrete001 = namespace.addTwoStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=TwoStateDiscrete001",
        browseName: "TwoStateDiscrete001",
        trueState: "Enabled",
        falseState: "Disabled"
    });
    const twoStateDiscrete002 = namespace.addTwoStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=TwoStateDiscrete002",
        browseName: "TwoStateDiscrete002",
        trueState: "On",
        falseState: "Off",
        optionals: ["TransitionTime", "EffectiveDisplayName"]
    });
    const twoStateDiscrete003 = namespace.addTwoStateDiscrete({
        browseName: "twoStateDiscrete003",
        nodeId: "s=TwoStateDiscrete003",
        optionals: ["TransitionTime"],
        isTrueSubStateOf: twoStateDiscrete002
    });
    const twoStateDiscrete004 = namespace.addTwoStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=TwoStateDiscrete004",
        browseName: "TwoStateDiscrete004",
        trueState: "InProgress",
        falseState: "Stopped"
    });
    const twoStateDiscrete005 = namespace.addTwoStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=TwoStateDiscrete005",
        browseName: "TwoStateDiscrete005",
        trueState: "InProgress",
        falseState: "Stopped"
    });
    twoStateDiscrete001.setValueFromSource({ dataType: "Boolean", value: false });
    twoStateDiscrete002.setValueFromSource({ dataType: "Boolean", value: false });
    twoStateDiscrete003.setValueFromSource({ dataType: "Boolean", value: false });
    twoStateDiscrete004.setValueFromSource({ dataType: "Boolean", value: false });
    twoStateDiscrete005.setValueFromSource({ dataType: "Boolean", value: false });
}
function add_multi_state_discrete_variable(namespace, parentFolder) {
    const DADiscreteTypeFolder = getDADiscreteTypeFolder(namespace, parentFolder);
    // MultiStateDiscrete001
    const multiStateDiscrete001 = namespace.addMultiStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=MultiStateDiscrete001",
        browseName: "MultiStateDiscrete001",
        enumStrings: ["Red", "Orange", "Green"],
        value: 1 // Orange
    });
    multiStateDiscrete001;
    // MultiStateDiscrete002
    namespace.addMultiStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=MultiStateDiscrete002",
        browseName: "MultiStateDiscrete002",
        enumStrings: ["Red", "Orange", "Green"],
        value: 1 // Orange
    });
    // MultiStateDiscrete002
    namespace.addMultiStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=MultiStateDiscrete003",
        browseName: "MultiStateDiscrete003",
        enumStrings: ["Red", "Orange", "Green"],
        value: 1 // Orange
    });
    // MultiStateDiscrete002
    namespace.addMultiStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=MultiStateDiscrete004",
        browseName: "MultiStateDiscrete004",
        enumStrings: ["Red", "Orange", "Green"],
        value: 1 // Orange
    });
    // MultiStateDiscrete002
    namespace.addMultiStateDiscrete({
        organizedBy: DADiscreteTypeFolder,
        nodeId: "s=MultiStateDiscrete005",
        browseName: "MultiStateDiscrete005",
        enumStrings: ["Red", "Orange", "Green"],
        value: 1 // Orange
    });
}
function add_multi_state_value_discrete_variables(namespaceDemo, parentFolder) {
    const multistateValueDiscreteTypeFolder = namespaceDemo.addObject({
        organizedBy: parentFolder,
        typeDefinition: "FolderType",
        browseName: "Simulation_DA_MultiStateValueDiscreteType",
        nodeId: "s=Simulation_DA_MultiStateValueDiscreteType"
    });
    function _add_multi_state_variable(parentFolder, dataType, value, enumValues) {
        const name = dataType + "MultiStateValueDiscrete";
        const nodeId = "s=" + name;
        namespaceDemo.addMultiStateValueDiscrete({
            organizedBy: parentFolder,
            browseName: name,
            nodeId,
            dataType,
            enumValues,
            value: 0x0000 // Zero
        });
    }
    const enumValueUnsigned = { Zero: 0x00, One: 0x01, Two: 0x02, Three: 0x03, Four: 0x04, Five: 0x05, Six: 0x06, Seven: 0x07 };
    const enumValueSigned = { MinusOne: -1, MinusTwo: -2, MinusThree: -3, ...enumValueUnsigned };
    const data = [
        { dataType: "Int16", value: -1, enumValue: enumValueSigned },
        { dataType: "UInt16", value: 10, enumValue: enumValueUnsigned },
        { dataType: "Int32", value: -1, enumValue: enumValueSigned },
        { dataType: "UInt32", value: 100, enumValue: enumValueUnsigned },
        { dataType: "Int64", value: [0, 0], enumValue: enumValueUnsigned },
        { dataType: "UInt64", value: [0, 0], enumValue: enumValueSigned },
        { dataType: "Byte", value: 1, enumValue: enumValueUnsigned },
        { dataType: "SByte", value: -1, enumValue: enumValueSigned }
    ];
    data.forEach((e) => {
        _add_multi_state_variable(multistateValueDiscreteTypeFolder, e.dataType, e.value, e.enumValue);
    });
}
function add_ObjectWithMethod(namespace, parentFolder) {
    const myObject = namespace.addObject({
        nodeId: "s=ObjectWithMethods",
        organizedBy: parentFolder,
        browseName: "ObjectWithMethods"
    });
    const methodNoArgs = namespace.addMethod(myObject, {
        browseName: "MethodNoArgs",
        nodeId: "s=MethodNoArgs"
        // xx inputArguments: [],
        // xx outputArguments: []
    });
    (0, node_opcua_assert_1.assert)((0, node_opcua_nodeid_1.makeNodeId)("MethodNoArgs", namespace.index)
        .toString()
        .match(/s=MethodNoArgs/));
    (0, node_opcua_assert_1.assert)(methodNoArgs.nodeId.toString().match(/s=MethodNoArgs/));
    methodNoArgs.bindMethod((inputArguments, context, callback) => {
        const callMethodResult = {
            statusCode: node_opcua_status_code_1.StatusCodes.Good,
            outputArguments: []
        };
        callback(null, callMethodResult);
    });
    const methodIO = namespace.addMethod(myObject, {
        /// xx modellingRule: "Mandatory",
        browseName: "MethodIO",
        nodeId: (0, node_opcua_nodeid_1.makeNodeId)("MethodIO", namespace.index),
        inputArguments: [
            {
                name: "ShutterLag",
                description: { text: "specifies the number of seconds to wait before the picture is taken " },
                dataType: node_opcua_variant_1.DataType.UInt32
            }
        ],
        outputArguments: [
            {
                name: "Result",
                description: { text: "the result" },
                dataType: "Int32"
            }
        ]
    });
    methodIO.bindMethod((inputArguments, context, callback) => {
        const callMethodResult = {
            statusCode: node_opcua_status_code_1.StatusCodes.Good,
            outputArguments: [
                {
                    dataType: node_opcua_variant_1.DataType.Int32,
                    value: 42
                }
            ]
        };
        callback(null, callMethodResult);
    });
    const methodI = namespace.addMethod(myObject, {
        /// xx modellingRule: "Mandatory",
        browseName: "MethodI",
        nodeId: "s=MethodI",
        inputArguments: [
            {
                name: "ShutterLag",
                description: { text: "specifies the number of seconds to wait before the picture is taken " },
                dataType: node_opcua_variant_1.DataType.UInt32
            }
        ]
        // xx outputArguments: []
    });
    methodI.bindMethod((inputArguments, context, callback) => {
        const callMethodResult = {
            statusCode: node_opcua_status_code_1.StatusCodes.Good,
            outputArguments: []
        };
        callback(null, callMethodResult);
    });
    const methodO = namespace.addMethod(myObject, {
        /// xx modellingRule: "Mandatory",
        browseName: "MethodO",
        nodeId: "s=MethodO",
        // xx inputArguments: [],
        outputArguments: [
            {
                name: "Result",
                description: { text: "the result" },
                dataType: "Int32"
            }
        ]
    });
    methodO.bindMethod((inputArguments, context, callback) => {
        const callMethodResult = {
            statusCode: node_opcua_status_code_1.StatusCodes.Good,
            outputArguments: [
                {
                    dataType: node_opcua_variant_1.DataType.Int32,
                    value: 42
                }
            ]
        };
        callback(null, callMethodResult);
    });
}
function add_enumeration_variable(namespaceDemo, parentFolder) {
    const addressSpace = namespaceDemo.addressSpace;
    const myEnumType = namespaceDemo.addEnumerationType({
        browseName: "SimulationEnumerationType",
        enumeration: [
            { value: 1, displayName: "RUNNING" },
            { value: 2, displayName: "BLOCKED" },
            { value: 3, displayName: "IDLE" },
            { value: 4, displayName: "UNDER MAINTENANCE" }
        ]
    });
    // now instantiate a variable that have this type.
    const e = namespaceDemo.addVariable({
        organizedBy: parentFolder,
        propertyOf: addressSpace.rootFolder.objects.server.vendorServerInfos,
        dataType: myEnumType,
        browseName: "RunningState"
    });
    e.writeEnumValue("RUNNING");
}
function add_trigger_nodes(namespace, parentFolder) {
    const addressSpace = namespace.addressSpace;
    const myEvtType = namespace.findObjectType("MyEventType") ||
        namespace.addEventType({
            browseName: "MyEventType",
            subtypeOf: "BaseEventType" // should be implicit
        });
    // add 2 nodes that generate an event when ever they are written to.
    function _add_trigger_node(parent, browseName, nodeId) {
        const triggerNode = namespace.addVariable({
            browseName,
            nodeId,
            eventSourceOf: parent,
            dataType: "Double",
            typeDefinition: (0, node_opcua_nodeid_1.makeNodeId)(68)
        });
        let value = 100.0;
        const getFunc = () => {
            return new node_opcua_variant_1.Variant({
                dataType: node_opcua_variant_1.DataType.Double,
                value
            });
        };
        const setFunc = (variant) => {
            value = variant.value;
            const server = addressSpace.rootFolder.objects.server;
            server.raiseEvent(myEvtType, {
                message: {
                    dataType: node_opcua_variant_1.DataType.LocalizedText,
                    value: { text: "Hello World" }
                },
                severity: {
                    dataType: node_opcua_variant_1.DataType.UInt32,
                    value: 32
                }
            });
        };
        const options = {
            get: getFunc,
            set: setFunc
        };
        triggerNode.bindVariable(options);
    }
    const sampleTriggerNode = namespace.addObject({
        browseName: "SampleTriggerNode",
        eventNotifier: 0x1,
        organizedBy: parentFolder
    });
    const triggerNode01 = _add_trigger_node(sampleTriggerNode, "TriggerNode01", "s=TriggerNode01");
    triggerNode01;
    const triggerNode02 = _add_trigger_node(sampleTriggerNode, "TriggerNode02", "s=TriggerNode02");
    triggerNode02;
}
function add_sampleView(namespace) {
    const addressSpace = namespace.addressSpace;
    const view1 = namespace.addView({
        organizedBy: addressSpace.rootFolder.views,
        browseName: "SampleView",
        nodeId: "s=SampleView"
    });
    view1.addReference({
        nodeId: "i=2256", // Server_Status
        referenceType: "Organizes"
    });
    view1.addReference({
        nodeId: "i=11715", // Server_Namespaces
        referenceType: "Organizes"
    });
    const view2 = namespace.addView({
        organizedBy: addressSpace.rootFolder.views,
        browseName: "OtherSampleView",
        nodeId: "s=OtherSampleView"
    });
    view2;
}
async function build_address_space_for_conformance_testing(addressSpace, options) {
    const namespace = addressSpace.registerNamespace("urn://node-opcua-simulator");
    options = options || {};
    options.mass_variable = options.mass_variable || false;
    const objectsFolder = addressSpace.findNode("ObjectsFolder");
    const simulationFolder = namespace.addFolder(objectsFolder, {
        browseName: "Simulation",
        nodeId: "s=SimulationFolder"
    });
    add_access_right_variables(namespace, simulationFolder);
    const staticVariablesFolder = namespace.addFolder(simulationFolder, {
        browseName: "Static"
    });
    const allProfileFolder = namespace.addFolder(staticVariablesFolder, {
        browseName: "All Profiles"
    });
    // Scalars/Array/MultiDim array of all sorts
    await add_static_variables(namespace, allProfileFolder);
    if (options.mass_variables) {
        add_mass_variables(namespace, allProfileFolder);
    }
    add_analog_data_items(namespace, allProfileFolder);
    const dynamicVariablesFolder = namespace.addFolder(simulationFolder, {
        browseName: "Dynamic"
    });
    add_simulation_variables(namespace, dynamicVariablesFolder);
    add_very_large_array_variables(namespace, staticVariablesFolder);
    add_path_10deep(namespace, simulationFolder);
    add_node_with_references(namespace, simulationFolder);
    add_ObjectWithMethod(namespace, simulationFolder);
    (0, testHelpers_1.add_eventGeneratorObject)(namespace, simulationFolder);
    add_sampleView(namespace);
    add_enumeration_variable(namespace, simulationFolder);
    add_multi_state_value_discrete_variables(namespace, simulationFolder);
    add_two_state_discrete_variables(namespace, simulationFolder);
    add_multi_state_discrete_variable(namespace, simulationFolder);
    add_trigger_nodes(namespace, simulationFolder);
}
//# sourceMappingURL=address_space_for_conformance_testing.js.map