import { NodeClass } from "node-opcua-data-model";
import { NodeId } from "node-opcua-nodeid";
import { Argument, CallMethodResultOptions } from "node-opcua-types";
import { Variant, VariantLike } from "node-opcua-variant";
import { CallbackT } from "node-opcua-status-code";
import { BaseNode } from "./base_node";
import { ISessionContext } from "./session_context";
import { UAObject } from "./ua_object";
import { UAObjectType } from "./ua_object_type";
import { UAVariable } from "./ua_variable";
import { CloneExtraInfo, CloneFilter, CloneOptions } from "./clone_options";
export declare type MethodFunctorC = (this: UAMethod, inputArguments: Variant[], context: ISessionContext, callback: CallbackT<CallMethodResultOptions>) => void;
export declare type MethodFunctorA = (this: UAMethod, inputArguments: Variant[], context: ISessionContext) => Promise<CallMethodResultOptions>;
export type MethodFunctor = MethodFunctorC | MethodFunctorA;
export declare class UAMethod extends BaseNode {
    readonly nodeClass: NodeClass.Method;
    readonly typeDefinition: NodeId;
    readonly typeDefinitionObj: UAObjectType;
    readonly parent: UAObject | null;
    readonly inputArguments?: UAVariable;
    readonly outputArguments?: UAVariable;
    readonly methodDeclarationId: NodeId;
    /**
     *
     */
    _getExecutableFlag?: (sessionContext: ISessionContext | null) => boolean;
    bindMethod(methodFunction: MethodFunctor): void;
    getExecutableFlag(context: ISessionContext): boolean;
    getInputArguments(): Argument[];
    getOutputArguments(): Argument[];
    /**
     */
    execute(object: UAObject | UAObjectType | null, inputArguments: VariantLike[] | null, context: ISessionContext, callback: CallbackT<CallMethodResultOptions>): void;
    execute(object: UAObject | UAObjectType | null, inputArguments: null | VariantLike[], context: ISessionContext): Promise<CallMethodResultOptions>;
    clone(options: CloneOptions, optionalFilter?: CloneFilter, extraInfo?: CloneExtraInfo): UAMethod;
    isBound(): boolean;
}
