import { UAObject } from "./ua_object";
import { UAVariable } from "./ua_variable";
import { UAMethod } from "./ua_method";
import { UAObjectType } from "./ua_object_type";
import { UAVariableType } from "./ua_variable_type";
import { BaseNode } from "./base_node";
/** @private */
export declare function fullPath(node: BaseNode): string;
/** @private */
export declare function fullPath2(node: BaseNode): string;
/** @private */
export declare function exploreNode(node: BaseNode): void;
interface CloneInfo {
    cloned: UAObject | UAVariable | UAMethod;
    original: UAObject | UAVariable | UAMethod | UAVariableType | UAObjectType;
}
export declare class CloneHelper {
    level: number;
    private _context;
    private _contextStack;
    private readonly mapTypeInstanceChildren;
    pad(): string;
    getClonedArray(): CloneInfo[];
    pushContext<TO extends UAObject | UAVariable | UAMethod | UAObjectType | UAVariableType, TC extends UAObject | UAVariable | UAMethod>({ clonedParent, originalParent }: {
        clonedParent: TC;
        originalParent: TO;
    }): void;
    popContext(): void;
    registerClonedObject<TO extends UAObject | UAVariable | UAMethod | UAObjectType | UAVariableType, TC extends UAObject | UAVariable | UAMethod>({ clonedNode, originalNode }: {
        clonedNode: TC;
        originalNode: TO;
    }): void;
    getCloned({ originalParent, clonedParent, originalNode }: {
        originalParent: BaseNode;
        clonedParent: BaseNode;
        originalNode: UAVariable | UAObject;
    }): UAObject | UAVariable | UAMethod | null;
}
export declare function reconstructNonHierarchicalReferences(extraInfo: CloneHelper): void;
/**
 * recreate functional group types according to type definition
 *

 * @param baseType
 */
export declare function reconstructFunctionalGroupType(extraInfo: CloneHelper): void;
export {};
