import * as mqtt from "mqtt";
export default class myMqtt {
    #private;
    connected: boolean;
    hbInterval: number;
    hbTopic: string;
    hbCounter: number;
    lastHB: Record<string, {
        tf: Date;
        cnt: number;
    }>;
    tagBuffer: Record<string, {
        value: string[] | number[];
    }>;
    tagTopic: string;
    tagMaxInterval: number;
    tagMaxCount: number;
    tagPubTimeout: any;
    constructor(url: string, onMessage: (topic: string, message: string | Buffer, packet?: mqtt.IPublishPacket) => void, subscribeHB: boolean, certPath?: string, cert?: string, key?: string, ca?: string, user?: string, pwd?: string, clientId?: string, bufferOut?: boolean, hbInterval?: number, hbTopic?: string, tagTopic?: string, tagMaxInterval?: number, tagMaxCount?: number);
    publish(topic: string, message: string | Buffer, error?: (err: Error | undefined) => void): void;
    publishAsync(topic: string, message: string | Buffer): Promise<mqtt.Packet | undefined>;
    publishTags(tags: Record<string, {
        value?: string[] | number[];
        error?: number;
    }>): void;
    subscribe(topic: string | string[], error?: (err: Error | null) => void): void;
    subscribeAsync(topic: string | string[]): Promise<mqtt.ISubscriptionGrant[]>;
    unsubscribe(topic: string | string[]): void;
    end(): void;
    startHeartBeat(modulName: string): void;
    checkHeartBeat(modules: string[], interruptFcn: (errModules: string[]) => void): void;
    waitForHeartBeat(modules: string[], timeoutMs?: number): Promise<void>;
    onHeartBeat(topic: string, message: string): void;
    private sendTags;
}
