/**
 * Authorization outcome.
 *
 * @readonly
 * @enum {number}
 * @property {number} ALLOW - Allow access to a resource.
 * @property {number} DENY - Deny access to a resource and throw an error.
 */
const Authorization = {
  /**
   * Allow access to a resource.
   * @type {number}
   */
  ALLOW: 0,

  /**
   * Deny access to a resource and throw an error in `prepare()`.
   * @type {number}
   */
  DENY: 1,
};
module.exports = Authorization;
