/**
 * Get UUID string from OpenTelemetry trace ID hex string.
 * @param traceId - The hex string trace ID to convert
 * @returns UUID string representation
 */
export declare function getUuidFromOtelTraceId(traceId: string): string;
/**
 * Get UUID string from OpenTelemetry span ID hex string.
 * @param spanId - The hex string span ID to convert (8 bytes/16 hex chars)
 * @returns UUID string representation with zero padding at the front
 */
export declare function getUuidFromOtelSpanId(spanId: string): string;
