// OpenTelemetry GenAI semantic convention attribute names
export const GEN_AI_OPERATION_NAME = "gen_ai.operation.name";
export const GEN_AI_SYSTEM = "gen_ai.system";
export const GEN_AI_REQUEST_MODEL = "gen_ai.request.model";
export const GEN_AI_RESPONSE_MODEL = "gen_ai.response.model";
export const GEN_AI_USAGE_INPUT_TOKENS = "gen_ai.usage.input_tokens";
export const GEN_AI_USAGE_OUTPUT_TOKENS = "gen_ai.usage.output_tokens";
export const GEN_AI_USAGE_TOTAL_TOKENS = "gen_ai.usage.total_tokens";
export const GEN_AI_REQUEST_MAX_TOKENS = "gen_ai.request.max_tokens";
export const GEN_AI_REQUEST_TEMPERATURE = "gen_ai.request.temperature";
export const GEN_AI_REQUEST_TOP_P = "gen_ai.request.top_p";
export const GEN_AI_REQUEST_FREQUENCY_PENALTY = "gen_ai.request.frequency_penalty";
export const GEN_AI_REQUEST_PRESENCE_PENALTY = "gen_ai.request.presence_penalty";
export const GEN_AI_RESPONSE_FINISH_REASONS = "gen_ai.response.finish_reasons";
export const GENAI_PROMPT = "gen_ai.prompt";
export const GENAI_COMPLETION = "gen_ai.completion";
export const GEN_AI_REQUEST_EXTRA_QUERY = "gen_ai.request.extra_query";
export const GEN_AI_REQUEST_EXTRA_BODY = "gen_ai.request.extra_body";
export const GEN_AI_SERIALIZED_NAME = "gen_ai.serialized.name";
export const GEN_AI_SERIALIZED_SIGNATURE = "gen_ai.serialized.signature";
export const GEN_AI_SERIALIZED_DOC = "gen_ai.serialized.doc";
export const GEN_AI_RESPONSE_ID = "gen_ai.response.id";
export const GEN_AI_RESPONSE_SERVICE_TIER = "gen_ai.response.service_tier";
export const GEN_AI_RESPONSE_SYSTEM_FINGERPRINT = "gen_ai.response.system_fingerprint";
export const GEN_AI_USAGE_INPUT_TOKEN_DETAILS = "gen_ai.usage.input_token_details";
export const GEN_AI_USAGE_OUTPUT_TOKEN_DETAILS = "gen_ai.usage.output_token_details";
// LangSmith custom attributes
export const LANGSMITH_SESSION_ID = "langsmith.trace.session_id";
export const LANGSMITH_SESSION_NAME = "langsmith.trace.session_name";
export const LANGSMITH_RUN_TYPE = "langsmith.span.kind";
export const LANGSMITH_NAME = "langsmith.trace.name";
export const LANGSMITH_METADATA = "langsmith.metadata";
export const LANGSMITH_TAGS = "langsmith.span.tags";
export const LANGSMITH_RUNTIME = "langsmith.span.runtime";
export const LANGSMITH_REQUEST_STREAMING = "langsmith.request.streaming";
export const LANGSMITH_REQUEST_HEADERS = "langsmith.request.headers";
export const LANGSMITH_RUN_ID = "langsmith.span.id";
export const LANGSMITH_TRACE_ID = "langsmith.trace.id";
export const LANGSMITH_DOTTED_ORDER = "langsmith.span.dotted_order";
export const LANGSMITH_PARENT_RUN_ID = "langsmith.span.parent_id";
export const LANGSMITH_USAGE_METADATA = "langsmith.usage_metadata";
export const LANGSMITH_REFERENCE_EXAMPLE_ID = "langsmith.reference_example_id";
export const LANGSMITH_TRACEABLE = "langsmith.traceable";
export const LANGSMITH_IS_ROOT = "langsmith.is_root";
export const LANGSMITH_TRACEABLE_PARENT_OTEL_SPAN_ID = "langsmith.traceable_parent_otel_span_id";
// GenAI event names
export const GEN_AI_SYSTEM_MESSAGE = "gen_ai.system.message";
export const GEN_AI_USER_MESSAGE = "gen_ai.user.message";
export const GEN_AI_ASSISTANT_MESSAGE = "gen_ai.assistant.message";
export const GEN_AI_CHOICE = "gen_ai.choice";
export const AI_SDK_LLM_OPERATIONS = [
    "ai.generateText.doGenerate",
    "ai.streamText.doStream",
    "ai.generateObject.doGenerate",
    "ai.streamObject.doStream",
];
export const AI_SDK_TOOL_OPERATIONS = ["ai.toolCall"];
