import type { BaseLanguageModel } from "@langchain/core/language_models/base";
import type { Runnable } from "@langchain/core/runnables";
/**
 * Push a prompt to the hub.
 * If the specified repo doesn't already exist, it will be created.
 * @param repoFullName The full name of the repo.
 * @param runnable The prompt to push.
 * @param options
 * @returns The URL of the newly pushed prompt in the hub.
 */
export declare function basePush(repoFullName: string, runnable: Runnable, options?: {
    apiKey?: string;
    apiUrl?: string;
    parentCommitHash?: string;
    /** @deprecated Use isPublic instead. */
    newRepoIsPublic?: boolean;
    isPublic?: boolean;
    /** @deprecated Use description instead. */
    newRepoDescription?: string;
    description?: string;
    readme?: string;
    tags?: string[];
}): Promise<string>;
export declare function basePull(ownerRepoCommit: string, options?: {
    apiKey?: string;
    apiUrl?: string;
    includeModel?: boolean;
}): Promise<import("langsmith/schemas").PromptCommit>;
export declare function generateModelImportMap(modelClass?: new (...args: any[]) => BaseLanguageModel): Record<string, any>;
export declare function generateOptionalImportMap(modelClass?: new (...args: any[]) => BaseLanguageModel): Record<string, any>;
export declare function bindOutputSchema<T extends Runnable>(loadedSequence: T): T;
