export declare const PREFIX = "Answer the following questions truthfully and as best you can.";
export declare const AGENT_ACTION_FORMAT_INSTRUCTIONS = "Output a JSON markdown code snippet containing a valid JSON blob (denoted below by $JSON_BLOB).\nThis $JSON_BLOB must have a \"action\" key (with the name of the tool to use) and an \"action_input\" key (tool input).\n\nValid \"action\" values: \"Final Answer\" (which you must use when giving your final response to the user), or one of [{tool_names}].\n\nThe $JSON_BLOB must be valid, parseable JSON and only contain a SINGLE action. Here is an example of an acceptable output:\n\n```json\n{{\n  \"action\": $TOOL_NAME,\n  \"action_input\": $INPUT\n}}\n```\n\nRemember to include the surrounding markdown code snippet delimiters (begin with \"```\" json and close with \"```\")!\n";
export declare const FORMAT_INSTRUCTIONS = "You have access to the following tools.\nYou must format your inputs to these tools to match their \"JSON schema\" definitions below.\n\n\"JSON Schema\" is a declarative language that allows you to annotate and validate JSON documents.\n\nFor example, the example \"JSON Schema\" instance {{\"properties\": {{\"foo\": {{\"description\": \"a list of test words\", \"type\": \"array\", \"items\": {{\"type\": \"string\"}}}}}}, \"required\": [\"foo\"]}}}}\nwould match an object with one required property, \"foo\". The \"type\" property specifies \"foo\" must be an \"array\", and the \"description\" property semantically describes it as \"a list of test words\". The items within \"foo\" must be strings.\nThus, the object {{\"foo\": [\"bar\", \"baz\"]}} is a well-formatted instance of this example \"JSON Schema\". The object {{\"properties\": {{\"foo\": [\"bar\", \"baz\"]}}}} is not well-formatted.\n\nHere are the JSON Schema instances for the tools you have access to:\n\n{tool_schemas}\n\nThe way you use the tools is as follows:\n\n------------------------\n\nOutput a JSON markdown code snippet containing a valid JSON blob (denoted below by $JSON_BLOB).\nThis $JSON_BLOB must have a \"action\" key (with the name of the tool to use) and an \"action_input\" key (tool input).\n\nValid \"action\" values: \"Final Answer\" (which you must use when giving your final response to the user), or one of [{tool_names}].\n\nThe $JSON_BLOB must be valid, parseable JSON and only contain a SINGLE action. Here is an example of an acceptable output:\n\n```json\n{{\n  \"action\": $TOOL_NAME,\n  \"action_input\": $INPUT\n}}\n```\n\nRemember to include the surrounding markdown code snippet delimiters (begin with \"```\" json and close with \"```\")!\n\n\nIf you are using a tool, \"action_input\" must adhere to the tool's input schema, given above.\n\n------------------------\n\nALWAYS use the following format:\n\nQuestion: the input question you must answer\nThought: you should always think about what to do\nAction:\n```json\n$JSON_BLOB\n```\nObservation: the result of the action\n... (this Thought/Action/Observation can repeat N times)\nThought: I now know the final answer\nAction:\n```json\n{{\n  \"action\": \"Final Answer\",\n  \"action_input\": \"Final response to human\"\n}}\n```";
export declare const SUFFIX = "Begin! Reminder to ALWAYS use the above format, and to use tools if appropriate.";
