import React from "react";
import selectStyles from "../Select/Select.css";
import { Portal } from "react-portal";
import ContextMenu from "../ContextMenu/ContextMenu";
import styles from "./Select.css";
const MAX_LABEL_LENGTH = 50;
const Select = ({ options = [], placeholder = "[Select an option]", onChange, data, allowMultiple = false }) => {
    const [drawerOpen, setDrawerOpen] = React.useState(false);
    const [drawerCoordinates, setDrawerCoordinates] = React.useState({
        x: 0,
        y: 0
    });
    const wrapper = React.useRef(null);
    const closeDrawer = () => {
        setDrawerOpen(false);
    };
    const openDrawer = () => {
        if (!drawerOpen) {
            const wrapperRect = wrapper.current?.getBoundingClientRect();
            if (wrapperRect) {
                setDrawerCoordinates({
                    x: wrapperRect.x,
                    y: wrapperRect.y + wrapperRect.height
                });
                setDrawerOpen(true);
            }
        }
    };
    const handleOptionSelected = (option) => {
        if (allowMultiple && Array.isArray(data)) {
            onChange([...data, option.value]);
        }
        else {
            onChange(option.value);
        }
    };
    const handleOptionDeleted = (optionIndex) => {
        onChange([...data.slice(0, optionIndex), ...data.slice(optionIndex + 1)]);
    };
    const getFilteredOptions = () => allowMultiple ? options.filter(opt => !data.includes(opt.value)) : options;
    const selectedOption = React.useMemo(() => {
        const option = options.find(o => o.value === data);
        if (option) {
            return {
                ...option,
                label: option.label.length > MAX_LABEL_LENGTH
                    ? option.label.slice(0, MAX_LABEL_LENGTH) + "..."
                    : option.label
            };
        }
        return undefined;
    }, [options, data]);
    return (React.createElement(React.Fragment, null,
        allowMultiple && typeof data !== "string" ? (data.length ? (React.createElement("div", { className: styles.chipsWrapper }, data.map((val, i) => {
            const optLabel = (options.find(opt => opt.value === val) || {}).label || "";
            return (React.createElement(OptionChip, { onRequestDelete: () => handleOptionDeleted(i), key: val }, optLabel));
        }))) : null) : data ? (React.createElement(SelectedOption, { wrapperRef: wrapper, option: selectedOption, onClick: openDrawer })) : null,
        (allowMultiple || !data) && (React.createElement("div", { className: selectStyles.wrapper, ref: wrapper, onClick: openDrawer }, placeholder)),
        drawerOpen && (React.createElement(Portal, null,
            React.createElement(ContextMenu, { x: drawerCoordinates.x, y: drawerCoordinates.y, emptyText: "There are no options", options: getFilteredOptions(), onOptionSelected: handleOptionSelected, onRequestClose: closeDrawer })))));
};
export default Select;
const SelectedOption = ({ option: { label, description } = {
    label: "",
    description: "",
    value: ""
}, wrapperRef, onClick }) => (React.createElement("div", { className: styles.selectedWrapper, onClick: onClick, ref: wrapperRef, "data-flume-component": "select" },
    React.createElement("label", { "data-flume-component": "select-label" }, label),
    description ? (React.createElement("p", { "data-flume-component": "select-desc" }, description)) : null));
const OptionChip = ({ children, onRequestDelete }) => (React.createElement("div", { className: styles.chipWrapper },
    children,
    React.createElement("button", { className: styles.deleteButton, onMouseDown: e => {
            e.stopPropagation();
        }, onClick: onRequestDelete }, "\u2715")));
//# sourceMappingURL=Select.js.map