import React from "react";
import styles from "./ColorPicker.css";
import { Colors } from "../../typeBuilders";
export default ({ x, y, onColorPicked, onRequestClose }) => {
    const wrapper = React.useRef(null);
    const testClickOutside = React.useCallback((e) => {
        console.log("testClickOutside", e.type);
        if (wrapper.current && !wrapper.current.contains(e.target)) {
            onRequestClose();
            document.removeEventListener("click", testClickOutside);
            document.removeEventListener("contextmenu", testClickOutside);
        }
    }, [wrapper, onRequestClose]);
    const testEscape = React.useCallback((e) => {
        if (e.key === "Escape") {
            onRequestClose();
            document.removeEventListener("keydown", testEscape);
        }
    }, [onRequestClose]);
    React.useEffect(() => {
        setTimeout(() => {
            document.addEventListener("keydown", testEscape);
            document.addEventListener("click", testClickOutside);
            document.addEventListener("contextmenu", testClickOutside);
        });
        return () => {
            document.removeEventListener("click", testClickOutside);
            document.removeEventListener("contextmenu", testClickOutside);
            document.removeEventListener("keydown", testEscape);
        };
    }, [testClickOutside, testEscape]);
    return (React.createElement("div", { "data-flume-component": "color-picker", ref: wrapper, className: styles.wrapper, style: {
            left: x,
            top: y
        } }, Object.values(Colors).map(colorString => {
        const color = colorString;
        return (React.createElement(ColorButton, { onSelected: () => {
                onColorPicked(color);
                onRequestClose();
            }, color: color, key: color }));
    })));
};
const ColorButton = ({ color, onSelected }) => (React.createElement("div", { className: styles.colorButtonWrapper },
    React.createElement("button", { "data-flume-component": "color-button", className: styles.colorButton, onClick: onSelected, "data-color": color, "aria-label": color })));
//# sourceMappingURL=ColorPicker.js.map