import React from "react";
import warning from "warning";
import { As, AssignableRef, ComponentWithAs, ComponentWithForwardedRef, DistributiveOmit, ElementByTag, ElementTagNameMap, ForwardRefExoticComponentWithAs, ForwardRefWithAsRenderFunction, FunctionComponentWithAs, MemoExoticComponentWithAs, PropsFromAs, PropsWithAs, SingleOrArray, ThenArg } from "./types";
/**
 * React currently throws a warning when using useLayoutEffect on the server.
 * To get around it, we can conditionally useEffect on the server (no-op) and
 * useLayoutEffect in the browser. We occasionally need useLayoutEffect to
 * ensure we don't get a render flash for certain operations, but we may also
 * need affected components to render on the server. One example is when setting
 * a component's descendants to retrieve their index values.
 *
 * Important to note that using this hook as an escape hatch will break the
 * eslint dependency warnings unless you rename the import to `useLayoutEffect`.
 * Use sparingly only when the effect won't effect the rendered HTML to avoid
 * any server/client mismatch.
 *
 * If a useLayoutEffect is needed and the result would create a mismatch, it's
 * likely that the component in question shouldn't be rendered on the server at
 * all, so a better approach would be to lazily render those in a parent
 * component after client-side hydration.
 *
 * TODO: We are calling useLayoutEffect in a couple of places that will likely
 * cause some issues for SSR users, whether the warning shows or not. Audit and
 * fix these.
 *
 * https://gist.github.com/gaearon/e7d97cdf38a2907924ea12e4ebdf3c85
 * https://github.com/reduxjs/react-redux/blob/master/src/utils/useIsomorphicLayoutEffect.js
 *
 * @param effect
 * @param deps
 */
export declare const useIsomorphicLayoutEffect: typeof React.useLayoutEffect;
/**
 * Copy of Facebook's warning package.
 */
export { warning };
/**
 * When in dev mode, checks that styles for a given @reach package are loaded.
 *
 * @param packageName Name of the package to check.
 * @example checkStyles("dialog") will check for styles for @reach/dialog
 */
declare let checkStyles: (packageName: string) => void;
export { checkStyles };
/**
 * Ponyfill for the global object in some environments.
 *
 * @link https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
 */
export declare const ponyfillGlobal: any;
/**
 * Passes or assigns an arbitrary value to a ref function or object.
 *
 * @param ref
 * @param value
 */
export declare function assignRef<RefValueType = any>(ref: AssignableRef<RefValueType> | null | undefined, value: any): void;
/**
 * Checks true|"true" vs false|"false"
 *
 * @param value
 */
export declare function boolOrBoolString(value: any): value is "true" | true;
export declare function canUseDOM(): boolean;
/**
 * Type-safe clone element
 *
 * @param element
 * @param props
 * @param children
 */
export declare function cloneValidElement<Props>(element: React.ReactElement<Props> | React.ReactNode, props?: Partial<Props> & React.Attributes, ...children: React.ReactNode[]): React.ReactElement<Props> | React.ReactNode;
export declare function createNamedContext<ContextValueType>(name: string, defaultValue: ContextValueType): React.Context<ContextValueType>;
/**
 * This is a hack for sure. The thing is, getting a component to intelligently
 * infer props based on a component or JSX string passed into an `as` prop is
 * kind of a huge pain. Getting it to work and satisfy the constraints of
 * `forwardRef` seems dang near impossible. To avoid needing to do this awkward
 * type song-and-dance every time we want to forward a ref into a component
 * that accepts an `as` prop, we abstract all of that mess to this function for
 * the time time being.
 */
export declare function forwardRefWithAs<Props, ComponentType extends As = "div">(render: ForwardRefWithAsRenderFunction<ComponentType, Props>): ForwardRefExoticComponentWithAs<ComponentType, Props>;
export declare function memoWithAs<Props, ComponentType extends As = "div">(Component: FunctionComponentWithAs<ComponentType, Props>, propsAreEqual?: (prevProps: Readonly<React.PropsWithChildren<Props>>, nextProps: Readonly<React.PropsWithChildren<Props>>) => boolean): MemoExoticComponentWithAs<ComponentType, Props>;
/**
 * Get the size of the working document minus the scrollbar offset.
 *
 * @param element
 */
export declare function getDocumentDimensions(element?: HTMLElement | null | undefined): {
    width: number;
    height: number;
};
/**
 * Get the scoll position of the global window object relative to a given node.
 *
 * @param element
 */
export declare function getScrollPosition(element?: HTMLElement | null | undefined): {
    scrollX: number;
    scrollY: number;
};
/**
 * Get a computed style value by property, backwards compatible with IE
 * @param element
 * @param styleProp
 */
export declare function getElementComputedStyle(element: HTMLElement & {
    currentStyle?: Record<string, string>;
}, styleProp: string): string | null;
/**
 * Get an element's owner document. Useful when components are used in iframes
 * or other environments like dev tools.
 *
 * @param element
 */
export declare function getOwnerDocument<T extends HTMLElement = HTMLElement>(element: T | null): Document | null;
export declare function getOwnerWindow<T extends HTMLElement = HTMLElement>(element: T | null): (Window & typeof globalThis) | null;
/**
 * Get the scrollbar offset distance.
 *
 * TODO: Remove in 1.0 (we used this in public examples)
 */
export declare function getScrollbarOffset(): number;
/**
 * Checks whether or not a value is a boolean.
 *
 * @param value
 */
export declare function isBoolean(value: any): value is boolean;
/**
 * Checks whether or not a value is a function.
 *
 * @param value
 */
export declare function isFunction(value: any): value is Function;
/**
 * Checks whether or not a value is a number.
 *
 * @param value
 */
export declare function isNumber(value: any): value is number;
/**
 * Detects right clicks
 *
 * @param nativeEvent
 */
export declare function isRightClick(nativeEvent: MouseEvent): boolean;
/**
 * Checks whether or not a value is a string.
 *
 * @param value
 */
export declare function isString(value: any): value is string;
/**
 * Joins strings to format IDs for compound components.
 *
 * @param args
 */
export declare function makeId(...args: (string | number | null | undefined)[]): string;
/**
 * No-op function.
 */
export declare function noop(): void;
/**
 * Convert our state strings for HTML data attributes.
 * No need for a fancy kebab-caser here, we know what our state strings are!
 *
 * @param state
 */
export declare function stateToAttributeString(state: any): string;
/**
 * Check if a component is controlled or uncontrolled and return the correct
 * state value and setter accordingly. If the component state is controlled by
 * the app, the setter is a noop.
 *
 * @param controlledValue
 * @param defaultValue
 */
export declare function useControlledState<T = any>(controlledValue: T | undefined, defaultValue: T): [T, React.Dispatch<React.SetStateAction<T>>];
/**
 * Logs a warning in dev mode when a component switches from controlled to
 * uncontrolled, or vice versa
 *
 * A single prop should typically be used to determine whether or not a
 * component is controlled or not.
 *
 * @param controlledValue
 * @param controlledPropName
 * @param componentName
 */
declare let useControlledSwitchWarning: (controlledValue: any, controlledPropName: string, componentName: string) => void;
export { useControlledSwitchWarning };
declare let useCheckStyles: (packageName: string) => void;
export { useCheckStyles };
/**
 * React hook for creating a value exactly once.
 * @see https://github.com/Andarist/use-constant
 */
export declare function useConstant<ValueType>(fn: () => ValueType): ValueType;
/**
 * @param callback
 */
export declare function useEventCallback<E extends Event | React.SyntheticEvent>(callback: (event: E, ...args: any[]) => void): (event: E, ...args: any[]) => void;
/**
 * @param callback
 */
export declare function useCallbackProp<F extends Function>(callback: F | undefined): F;
/**
 * Adds a DOM event listener
 *
 * @param eventName
 * @param listener
 * @param element
 */
export declare function useEventListener<K extends keyof WindowEventMap>(eventName: K, listener: (event: WindowEventMap[K]) => any, element?: HTMLElement | Document | Window | EventTarget): void;
/**
 * Detect when focus changes in our document.
 *
 * @param handleChange
 * @param when
 * @param ownerDocument
 */
export declare function useFocusChange(handleChange?: (activeElement: Element | null, previousActiveElement: Element | null, event?: FocusEvent) => void, when?: "focus" | "blur", ownerDocument?: Document): void;
/**
 * Passes or assigns a value to multiple refs (typically a DOM node). Useful for
 * dealing with components that need an explicit ref for DOM calculations but
 * also forwards refs assigned by an app.
 *
 * @param refs Refs to fork
 */
export declare function useForkedRef<RefValueType = any>(...refs: (AssignableRef<RefValueType> | null | undefined)[]): ((node: any) => void) | null;
/**
 * Returns the previous value of a reference after a component update.
 *
 * @param value
 */
export declare function usePrevious<ValueType = any>(value: ValueType): ValueType | null;
/**
 * Call an effect after a component update, skipping the initial mount.
 *
 * @param effect Effect to call
 * @param deps Effect dependency list
 */
export declare function useUpdateEffect(effect: React.EffectCallback, deps?: React.DependencyList): void;
/**
 * Just a lil state logger
 *
 * @param state
 * @param DEBUG
 */
declare let useStateLogger: (state: string, DEBUG: boolean) => void;
export { useStateLogger };
/**
 * Wraps a lib-defined event handler and a user-defined event handler, returning
 * a single handler that allows a user to prevent lib-defined handlers from
 * firing.
 *
 * @param theirHandler User-supplied event handler
 * @param ourHandler Library-supplied event handler
 */
export declare function wrapEvent<EventType extends React.SyntheticEvent | Event>(theirHandler: ((event: EventType) => any) | undefined, ourHandler: (event: EventType) => any): (event: EventType) => any;
export { As, AssignableRef, ComponentWithAs, ComponentWithForwardedRef, DistributiveOmit, ElementByTag, ElementTagNameMap, ForwardRefExoticComponentWithAs, FunctionComponentWithAs, MemoExoticComponentWithAs, PropsFromAs, PropsWithAs, SingleOrArray, ThenArg, };
