/** Generic error produced by the Hrana client. */
export class ClientError extends Error {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "ClientError";
    }
}
/** Error thrown when the server violates the protocol. */
export class ProtoError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "ProtoError";
    }
}
/** Error thrown when the server returns an error response. */
export class ResponseError extends ClientError {
    code;
    /** @internal */
    proto;
    /** @private */
    constructor(message, protoError) {
        super(message);
        this.name = "ResponseError";
        this.code = protoError.code;
        this.proto = protoError;
        this.stack = undefined;
    }
}
/** Error thrown when the client or stream is closed. */
export class ClosedError extends ClientError {
    /** @private */
    constructor(message, cause) {
        if (cause !== undefined) {
            super(`${message}: ${cause}`);
            this.cause = cause;
        }
        else {
            super(message);
        }
        this.name = "ClosedError";
    }
}
/** Error thrown when the environment does not seem to support WebSockets. */
export class WebSocketUnsupportedError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "WebSocketUnsupportedError";
    }
}
/** Error thrown when we encounter a WebSocket error. */
export class WebSocketError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "WebSocketError";
    }
}
/** Error thrown when the HTTP server returns an error response. */
export class HttpServerError extends ClientError {
    status;
    /** @private */
    constructor(message, status) {
        super(message);
        this.status = status;
        this.name = "HttpServerError";
    }
}
/** Error thrown when a libsql URL is not valid. */
export class LibsqlUrlParseError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "LibsqlUrlParseError";
    }
}
/** Error thrown when the protocol version is too low to support a feature. */
export class ProtocolVersionError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "ProtocolVersionError";
    }
}
/** Error thrown when an internal client error happens. */
export class InternalError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "InternalError";
    }
}
/** Error thrown when the API is misused. */
export class MisuseError extends ClientError {
    /** @private */
    constructor(message) {
        super(message);
        this.name = "MisuseError";
    }
}
