import { Embeddings, EmbeddingsParams } from "@langchain/core/embeddings";
import { Ollama } from "ollama/browser";
import type { Options as OllamaOptions } from "ollama";
import { OllamaCamelCaseOptions } from "./types.js";
/**
 * Interface for OllamaEmbeddings parameters. Extends EmbeddingsParams and
 * defines additional parameters specific to the OllamaEmbeddings class.
 */
export interface OllamaEmbeddingsParams extends EmbeddingsParams {
    /**
     * The Ollama model to use for embeddings.
     * @default "mxbai-embed-large"
     */
    model?: string;
    /**
     * Base URL of the Ollama server
     * @default "http://localhost:11434"
     */
    baseUrl?: string;
    /**
     * Defaults to "5m"
     */
    keepAlive?: string | number;
    /**
     * Whether or not to truncate the input text to fit inside the model's
     * context window.
     * @default false
     */
    truncate?: boolean;
    /**
     * Optional HTTP Headers to include in the request.
     */
    headers?: Headers | Record<string, string>;
    /**
     * Advanced Ollama API request parameters in camelCase, see
     * https://github.com/ollama/ollama/blob/main/docs/modelfile.md#valid-parameters-and-values
     * for details of the available parameters.
     */
    requestOptions?: OllamaCamelCaseOptions & Partial<OllamaOptions>;
    /**
     * The fetch function to use.
     * @default fetch
     */
    fetch?: typeof fetch;
}
export declare class OllamaEmbeddings extends Embeddings {
    model: string;
    baseUrl: string;
    keepAlive?: string | number;
    requestOptions?: Partial<OllamaOptions>;
    client: Ollama;
    truncate: boolean;
    constructor(fields?: OllamaEmbeddingsParams);
    /** convert camelCased Ollama request options like "useMMap" to
     * the snake_cased equivalent which the ollama API actually uses.
     * Used only for consistency with the llms/Ollama and chatModels/Ollama classes
     */
    _convertOptions(requestOptions: OllamaCamelCaseOptions): Partial<OllamaOptions>;
    embedDocuments(texts: string[]): Promise<number[][]>;
    embedQuery(text: string): Promise<number[]>;
    private embeddingWithRetry;
}
