import { CallbackManagerForChainRun } from "@langchain/core/callbacks/manager";
import { Runnable, RunnableConfig } from "@langchain/core/runnables";
export interface RunnableCallableArgs extends Partial<any> {
    name?: string;
    func: (...args: any[]) => any;
    tags?: string[];
    trace?: boolean;
    recurse?: boolean;
}
export declare class RunnableCallable<I = unknown, O = unknown> extends Runnable<I, O> {
    lc_namespace: string[];
    func: (...args: any[]) => any;
    tags?: string[];
    config?: RunnableConfig;
    trace: boolean;
    recurse: boolean;
    constructor(fields: RunnableCallableArgs);
    protected _tracedInvoke(input: I, config?: Partial<RunnableConfig>, runManager?: CallbackManagerForChainRun): Promise<O>;
    invoke(input: I, options?: Partial<RunnableConfig> | undefined): Promise<O>;
}
export declare function prefixGenerator<T, Prefix extends string>(generator: Generator<T>, prefix: Prefix): Generator<[Prefix, T]>;
export declare function prefixGenerator<T>(generator: Generator<T>, prefix?: undefined): Generator<T>;
export declare function prefixGenerator<T, Prefix extends string | undefined = undefined>(generator: Generator<T>, prefix?: Prefix | undefined): Generator<Prefix extends string ? [Prefix, T] : T>;
export declare function gatherIterator<T>(i: AsyncIterable<T> | Promise<AsyncIterable<T>> | Iterable<T> | Promise<Iterable<T>>): Promise<Array<T>>;
export declare function gatherIteratorSync<T>(i: Iterable<T>): Array<T>;
export declare function patchConfigurable(config: RunnableConfig | undefined, patch: Record<string, any>): RunnableConfig;
export declare function isAsyncGeneratorFunction(val: unknown): val is AsyncGeneratorFunction;
export declare function isGeneratorFunction(val: unknown): val is GeneratorFunction;
