"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PregelNode = exports.ChannelRead = void 0;
const runnables_1 = require("@langchain/core/runnables");
const constants_js_1 = require("../constants.cjs");
const write_js_1 = require("./write.cjs");
const utils_js_1 = require("../utils.cjs");
class ChannelRead extends utils_js_1.RunnableCallable {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    constructor(channel, 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    mapper, fresh = false) {
        super({
            func: (_, config) => ChannelRead.doRead(config, this.channel, this.fresh, this.mapper),
        });
        Object.defineProperty(this, "lc_graph_name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "ChannelRead"
        });
        Object.defineProperty(this, "channel", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "fresh", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        Object.defineProperty(this, "mapper", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.fresh = fresh;
        this.mapper = mapper;
        this.channel = channel;
        this.name = Array.isArray(channel)
            ? `ChannelRead<${channel.join(",")}>`
            : `ChannelRead<${channel}>`;
    }
    static doRead(config, channel, fresh, mapper) {
        const read = config.configurable?.[constants_js_1.CONFIG_KEY_READ];
        if (!read) {
            throw new Error("Runnable is not configured with a read function. Make sure to call in the context of a Pregel process");
        }
        if (mapper) {
            return mapper(read(channel, fresh));
        }
        else {
            return read(channel, fresh);
        }
    }
}
exports.ChannelRead = ChannelRead;
const defaultRunnableBound = 
/* #__PURE__ */ new runnables_1.RunnablePassthrough();
class PregelNode extends runnables_1.RunnableBinding {
    constructor(fields) {
        const { channels, triggers, mapper, writers, bound, kwargs, metadata, retryPolicy, cachePolicy, tags, subgraphs, ends, } = fields;
        const mergedTags = [
            ...(fields.config?.tags ? fields.config.tags : []),
            ...(tags ?? []),
        ];
        super({
            ...fields,
            bound: fields.bound ??
                defaultRunnableBound,
            config: {
                ...(fields.config ? fields.config : {}),
                tags: mergedTags,
            },
        });
        Object.defineProperty(this, "lc_graph_name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "PregelNode"
        });
        Object.defineProperty(this, "channels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "triggers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        Object.defineProperty(this, "mapper", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "writers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "bound", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: defaultRunnableBound
        });
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        Object.defineProperty(this, "kwargs", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(this, "metadata", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(this, "tags", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "retryPolicy", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "cachePolicy", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "subgraphs", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "ends", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.channels = channels;
        this.triggers = triggers;
        this.mapper = mapper;
        this.writers = writers ?? this.writers;
        this.bound = bound ?? this.bound;
        this.kwargs = kwargs ?? this.kwargs;
        this.metadata = metadata ?? this.metadata;
        this.tags = mergedTags;
        this.retryPolicy = retryPolicy;
        this.cachePolicy = cachePolicy;
        this.subgraphs = subgraphs;
        this.ends = ends;
    }
    getWriters() {
        const newWriters = [...this.writers];
        while (newWriters.length > 1 &&
            // eslint-disable-next-line no-instanceof/no-instanceof
            newWriters[newWriters.length - 1] instanceof write_js_1.ChannelWrite &&
            // eslint-disable-next-line no-instanceof/no-instanceof
            newWriters[newWriters.length - 2] instanceof write_js_1.ChannelWrite) {
            // we can combine writes if they are consecutive
            // careful to not modify the original writers list or ChannelWrite
            const endWriters = newWriters.slice(-2);
            const combinedWrites = endWriters[0].writes.concat(endWriters[1].writes);
            newWriters[newWriters.length - 2] = new write_js_1.ChannelWrite(combinedWrites, endWriters[0].config?.tags);
            newWriters.pop();
        }
        return newWriters;
    }
    getNode() {
        const writers = this.getWriters();
        if (this.bound === defaultRunnableBound && writers.length === 0) {
            return undefined;
        }
        else if (this.bound === defaultRunnableBound && writers.length === 1) {
            return writers[0];
        }
        else if (this.bound === defaultRunnableBound) {
            return new runnables_1.RunnableSequence({
                first: writers[0],
                middle: writers.slice(1, writers.length - 1),
                last: writers[writers.length - 1],
                omitSequenceTags: true,
            });
        }
        else if (writers.length > 0) {
            return new runnables_1.RunnableSequence({
                first: this.bound,
                middle: writers.slice(0, writers.length - 1),
                last: writers[writers.length - 1],
                omitSequenceTags: true,
            });
        }
        else {
            return this.bound;
        }
    }
    join(channels) {
        if (!Array.isArray(channels)) {
            throw new Error("channels must be a list");
        }
        if (typeof this.channels !== "object") {
            throw new Error("all channels must be named when using .join()");
        }
        return new PregelNode({
            channels: {
                ...this.channels,
                ...Object.fromEntries(channels.map((chan) => [chan, chan])),
            },
            triggers: this.triggers,
            mapper: this.mapper,
            writers: this.writers,
            bound: this.bound,
            kwargs: this.kwargs,
            config: this.config,
            retryPolicy: this.retryPolicy,
            cachePolicy: this.cachePolicy,
        });
    }
    pipe(coerceable) {
        if (write_js_1.ChannelWrite.isWriter(coerceable)) {
            return new PregelNode({
                channels: this.channels,
                triggers: this.triggers,
                mapper: this.mapper,
                writers: [...this.writers, coerceable],
                bound: this.bound,
                config: this.config,
                kwargs: this.kwargs,
                retryPolicy: this.retryPolicy,
                cachePolicy: this.cachePolicy,
            });
        }
        else if (this.bound === defaultRunnableBound) {
            return new PregelNode({
                channels: this.channels,
                triggers: this.triggers,
                mapper: this.mapper,
                writers: this.writers,
                bound: (0, runnables_1._coerceToRunnable)(coerceable),
                config: this.config,
                kwargs: this.kwargs,
                retryPolicy: this.retryPolicy,
                cachePolicy: this.cachePolicy,
            });
        }
        else {
            return new PregelNode({
                channels: this.channels,
                triggers: this.triggers,
                mapper: this.mapper,
                writers: this.writers,
                bound: this.bound.pipe(coerceable),
                config: this.config,
                kwargs: this.kwargs,
                retryPolicy: this.retryPolicy,
                cachePolicy: this.cachePolicy,
            });
        }
    }
}
exports.PregelNode = PregelNode;
//# sourceMappingURL=read.js.map