import type { RunnableConfig } from "@langchain/core/runnables";
import type { CallbackManagerForChainRun } from "@langchain/core/callbacks/manager";
import { BaseCheckpointSaver, Checkpoint, PendingWrite, CheckpointPendingWrite, CheckpointMetadata, All, BaseStore, AsyncBatchedStore, BaseCache, CacheFullKey, CacheNamespace } from "@langchain/langgraph-checkpoint";
import { BaseChannel } from "../channels/base.js";
import type { Call, Durability, PregelExecutableTask, StreamMode } from "./types.js";
import { Command } from "../constants.js";
import { PregelNode } from "./read.js";
import { LangGraphRunnableConfig } from "./runnable_types.js";
import { IterableReadableWritableStream } from "./stream.js";
export type PregelLoopInitializeParams = {
    input?: any | Command;
    config: RunnableConfig;
    checkpointer?: BaseCheckpointSaver;
    outputKeys: string | string[];
    streamKeys: string | string[];
    nodes: Record<string, PregelNode>;
    channelSpecs: Record<string, BaseChannel>;
    stream: IterableReadableWritableStream;
    store?: BaseStore;
    cache?: BaseCache<PendingWrite<string>[]>;
    interruptAfter: string[] | All;
    interruptBefore: string[] | All;
    durability: Durability;
    manager?: CallbackManagerForChainRun;
    debug: boolean;
    triggerToNodes: Record<string, string[]>;
};
type PregelLoopParams = {
    input?: any | Command;
    config: RunnableConfig;
    checkpointer?: BaseCheckpointSaver;
    checkpoint: Checkpoint;
    checkpointMetadata: CheckpointMetadata;
    checkpointPreviousVersions: Record<string, string | number>;
    checkpointPendingWrites: CheckpointPendingWrite[];
    checkpointConfig: RunnableConfig;
    channels: Record<string, BaseChannel>;
    step: number;
    stop: number;
    outputKeys: string | string[];
    streamKeys: string | string[];
    nodes: Record<string, PregelNode>;
    checkpointNamespace: string[];
    skipDoneTasks: boolean;
    isNested: boolean;
    manager?: CallbackManagerForChainRun;
    stream: IterableReadableWritableStream;
    store?: AsyncBatchedStore;
    cache?: BaseCache<PendingWrite<string>[]>;
    prevCheckpointConfig: RunnableConfig | undefined;
    interruptAfter: string[] | All;
    interruptBefore: string[] | All;
    durability: Durability;
    debug: boolean;
    triggerToNodes: Record<string, string[]>;
};
declare class AsyncBatchedCache extends BaseCache<PendingWrite<string>[]> {
    protected cache: BaseCache<PendingWrite<string>[]>;
    private queue;
    constructor(cache: BaseCache<unknown>);
    get(keys: CacheFullKey[]): Promise<{
        key: CacheFullKey;
        value: PendingWrite<string>[];
    }[]>;
    set(pairs: {
        key: CacheFullKey;
        value: PendingWrite<string>[];
        ttl?: number;
    }[]): Promise<void>;
    clear(namespaces: CacheNamespace[]): Promise<void>;
    stop(): Promise<void>;
    private enqueueOperation;
}
export declare class PregelLoop {
    protected input?: any | Command;
    output: any;
    config: LangGraphRunnableConfig;
    protected checkpointer?: BaseCheckpointSaver;
    protected checkpointerGetNextVersion: (current: number | undefined) => number;
    channels: Record<string, BaseChannel>;
    protected checkpoint: Checkpoint;
    protected checkpointIdSaved: string | undefined;
    protected checkpointConfig: RunnableConfig;
    checkpointMetadata: CheckpointMetadata;
    protected checkpointNamespace: string[];
    protected checkpointPendingWrites: CheckpointPendingWrite[];
    protected checkpointPreviousVersions: Record<string, string | number>;
    step: number;
    protected stop: number;
    protected durability: Durability;
    protected outputKeys: string | string[];
    protected streamKeys: string | string[];
    protected nodes: Record<string, PregelNode>;
    protected skipDoneTasks: boolean;
    protected prevCheckpointConfig: RunnableConfig | undefined;
    status: "pending" | "done" | "interrupt_before" | "interrupt_after" | "out_of_steps";
    tasks: Record<string, PregelExecutableTask<any, any>>;
    stream: IterableReadableWritableStream;
    checkpointerPromises: Promise<unknown>[];
    isNested: boolean;
    protected _checkpointerChainedPromise: Promise<unknown>;
    store?: AsyncBatchedStore;
    cache?: AsyncBatchedCache;
    manager?: CallbackManagerForChainRun;
    interruptAfter: string[] | All;
    interruptBefore: string[] | All;
    toInterrupt: PregelExecutableTask<string, string>[];
    debug: boolean;
    triggerToNodes: Record<string, string[]>;
    get isResuming(): any;
    constructor(params: PregelLoopParams);
    static initialize(params: PregelLoopInitializeParams): Promise<PregelLoop>;
    protected _checkpointerPutAfterPrevious(input: {
        config: RunnableConfig;
        checkpoint: Checkpoint;
        metadata: CheckpointMetadata;
        newVersions: Record<string, string | number>;
    }): void;
    /**
     * Put writes for a task, to be read by the next tick.
     * @param taskId
     * @param writes
     */
    putWrites(taskId: string, writes: PendingWrite<string>[]): void;
    _outputWrites(taskId: string, writes: [string, unknown][], cached?: boolean): void;
    _matchCachedWrites(): Promise<{
        task: PregelExecutableTask<string, string>;
        result: unknown;
    }[]>;
    /**
     * Execute a single iteration of the Pregel loop.
     * Returns true if more iterations are needed.
     * @param params
     */
    tick(params: {
        inputKeys?: string | string[];
    }): Promise<boolean>;
    finishAndHandleError(error?: Error): Promise<boolean>;
    acceptPush(task: PregelExecutableTask<string, string>, writeIdx: number, call?: Call): Promise<PregelExecutableTask<string, string> | void>;
    protected _suppressInterrupt(e?: Error): boolean;
    protected _first(inputKeys: string | string[]): Promise<void>;
    protected _emit(values: [StreamMode, unknown][]): void;
    protected _putCheckpoint(inputMetadata: Omit<CheckpointMetadata, "step" | "parents">): void;
    protected _flushPendingWrites(): void;
    protected _matchWrites(tasks: Record<string, PregelExecutableTask<string, string>>): void;
}
export {};
