import { RemoveMessage, convertToChunk, coerceMessageLikeToMessage, isBaseMessageChunk, } from "@langchain/core/messages";
function tryConvertToChunk(message) {
    try {
        return convertToChunk(message);
    }
    catch {
        return null;
    }
}
function tryCoerceMessageLikeToMessage(message) {
    // TODO: this is unnecessary with https://github.com/langchain-ai/langchainjs/pull/8941
    if (message.type === "remove" && message.id != null) {
        return new RemoveMessage({ ...message, id: message.id });
    }
    return coerceMessageLikeToMessage(message);
}
export class MessageTupleManager {
    constructor() {
        Object.defineProperty(this, "chunks", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        this.chunks = {};
    }
    add(serialized, metadata) {
        // TODO: this is sometimes sent from the API
        // figure out how to prevent this or move this to LC.js
        if (serialized.type.endsWith("MessageChunk")) {
            // eslint-disable-next-line no-param-reassign
            serialized.type = serialized.type
                .slice(0, -"MessageChunk".length)
                .toLowerCase();
        }
        const message = tryCoerceMessageLikeToMessage(serialized);
        const chunk = tryConvertToChunk(message);
        const { id } = chunk ?? message;
        if (!id) {
            console.warn("No message ID found for chunk, ignoring in state", serialized);
            return null;
        }
        this.chunks[id] ??= {};
        this.chunks[id].metadata = metadata ?? this.chunks[id].metadata;
        if (chunk) {
            const prev = this.chunks[id].chunk;
            this.chunks[id].chunk =
                (isBaseMessageChunk(prev) ? prev : null)?.concat(chunk) ?? chunk;
        }
        else {
            this.chunks[id].chunk = message;
        }
        return id;
    }
    clear() {
        this.chunks = {};
    }
    get(id, defaultIndex) {
        if (id == null)
            return null;
        if (this.chunks[id] == null)
            return null;
        if (defaultIndex != null)
            this.chunks[id].index ??= defaultIndex;
        return this.chunks[id];
    }
}
export const toMessageDict = (chunk) => {
    const { type, data } = chunk.toDict();
    return { ...data, type };
};
