import type { CheckpointsStreamEvent, CustomStreamEvent, DebugStreamEvent, ErrorStreamEvent, EventsStreamEvent, FeedbackStreamEvent, MessagesTupleStreamEvent, MetadataStreamEvent, TasksStreamEvent, UpdatesStreamEvent, ValuesStreamEvent } from "../types.stream.js";
import { MessageTupleManager } from "./messages.js";
import type { Message } from "../types.messages.js";
type BagTemplate = {
    ConfigurableType?: Record<string, unknown>;
    InterruptType?: unknown;
    CustomEventType?: unknown;
    UpdateType?: unknown;
};
type GetUpdateType<Bag extends BagTemplate, StateType extends Record<string, unknown>> = Bag extends {
    UpdateType: unknown;
} ? Bag["UpdateType"] : Partial<StateType>;
type GetCustomEventType<Bag extends BagTemplate> = Bag extends {
    CustomEventType: unknown;
} ? Bag["CustomEventType"] : unknown;
type EventStreamMap<StateType, UpdateType, CustomType> = {
    values: ValuesStreamEvent<StateType>;
    updates: UpdatesStreamEvent<UpdateType>;
    custom: CustomStreamEvent<CustomType>;
    debug: DebugStreamEvent;
    messages: MessagesTupleStreamEvent;
    events: EventsStreamEvent;
    metadata: MetadataStreamEvent;
    checkpoints: CheckpointsStreamEvent<StateType>;
    tasks: TasksStreamEvent<StateType, UpdateType>;
    error: ErrorStreamEvent;
    feedback: FeedbackStreamEvent;
};
export type EventStreamEvent<StateType, UpdateType, CustomType> = EventStreamMap<StateType, UpdateType, CustomType>[keyof EventStreamMap<StateType, UpdateType, CustomType>];
interface StreamManagerEventCallbacks<StateType extends Record<string, unknown>, Bag extends BagTemplate = BagTemplate> {
    onUpdateEvent?: (data: UpdatesStreamEvent<GetUpdateType<Bag, StateType>>["data"], options: {
        namespace: string[] | undefined;
        mutate: (update: Partial<StateType> | ((prev: StateType) => Partial<StateType>)) => void;
    }) => void;
    onCustomEvent?: (data: GetCustomEventType<Bag>, options: {
        namespace: string[] | undefined;
        mutate: (update: Partial<StateType> | ((prev: StateType) => Partial<StateType>)) => void;
    }) => void;
    onMetadataEvent?: (data: MetadataStreamEvent["data"]) => void;
    onLangChainEvent?: (data: EventsStreamEvent["data"]) => void;
    onDebugEvent?: (data: DebugStreamEvent["data"], options: {
        namespace: string[] | undefined;
    }) => void;
    onCheckpointEvent?: (data: CheckpointsStreamEvent<StateType>["data"], options: {
        namespace: string[] | undefined;
    }) => void;
    onTaskEvent?: (data: TasksStreamEvent<StateType, GetUpdateType<Bag, StateType>>["data"], options: {
        namespace: string[] | undefined;
    }) => void;
}
export declare class StreamManager<StateType extends Record<string, unknown>, Bag extends BagTemplate = BagTemplate> {
    private abortRef;
    private messages;
    private listeners;
    private state;
    constructor(messages: MessageTupleManager);
    private setState;
    private notifyListeners;
    subscribe: (listener: () => void) => (() => void);
    getSnapshot: () => {
        isLoading: boolean;
        values: [values: StateType, kind: "stream" | "stop"] | null;
        error: unknown;
    };
    get isLoading(): boolean;
    get values(): StateType | null;
    get error(): unknown;
    setStreamValues: (values: (StateType | null) | ((prev: StateType | null, kind: "stream" | "stop") => StateType | null), kind?: "stream" | "stop") => void;
    private getMutateFn;
    private matchEventType;
    start: (action: (signal: AbortSignal) => Promise<AsyncGenerator<EventStreamEvent<StateType, GetUpdateType<Bag, StateType>, GetCustomEventType<Bag>>>>, options: {
        getMessages: (values: StateType) => Message[];
        setMessages: (current: StateType, messages: Message[]) => StateType;
        initialValues: StateType;
        callbacks: StreamManagerEventCallbacks<StateType, Bag>;
        onSuccess: () => StateType | null | undefined | void | Promise<StateType | null | undefined | void>;
        onError: (error: unknown) => void | Promise<void>;
        onFinish?: () => void;
    }) => Promise<void>;
    stop: (historyValues: StateType, options: {
        onStop?: (options: {
            mutate: (update: Partial<StateType> | ((prev: StateType) => Partial<StateType>)) => void;
        }) => void;
    }) => Promise<void>;
    clear: () => void;
}
export {};
