import type { ThreadState } from "../schema.js";
interface Node<StateType = any> {
    type: "node";
    value: ThreadState<StateType>;
    path: string[];
}
interface Fork<StateType = any> {
    type: "fork";
    items: Array<Sequence<StateType>>;
}
export interface Sequence<StateType = any> {
    type: "sequence";
    items: Array<Node<StateType> | Fork<StateType>>;
}
export declare function getBranchSequence<StateType extends Record<string, unknown>>(history: ThreadState<StateType>[]): {
    rootSequence: Sequence<any>;
    paths: string[][];
};
export declare function getBranchView<StateType extends Record<string, unknown>>(sequence: Sequence<StateType>, paths: string[][], branch: string): {
    history: ThreadState<StateType>[];
    branchByCheckpoint: Record<string, {
        branch: string | undefined;
        branchOptions: string[] | undefined;
    }>;
};
export declare function getBranchContext<StateType extends Record<string, unknown>>(branch: string, history: ThreadState<StateType>[] | undefined): {
    branchTree: Sequence<any>;
    flatHistory: ThreadState<any>[];
    branchByCheckpoint: Record<string, {
        branch: string | undefined;
        branchOptions: string[] | undefined;
    }>;
    threadHead: ThreadState<any> | undefined;
};
export {};
