"use strict";
"use client";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useControllableThreadId = void 0;
const react_1 = require("react");
const useControllableThreadId = (options) => {
    const [localThreadId, _setLocalThreadId] = (0, react_1.useState)(options?.threadId ?? null);
    const onThreadIdRef = (0, react_1.useRef)(options?.onThreadId);
    onThreadIdRef.current = options?.onThreadId;
    const setThreadId = (0, react_1.useCallback)((threadId) => {
        _setLocalThreadId(threadId);
        onThreadIdRef.current?.(threadId);
    }, []);
    if (!options || !("threadId" in options)) {
        return [localThreadId, setThreadId];
    }
    return [options.threadId ?? null, setThreadId];
};
exports.useControllableThreadId = useControllableThreadId;
