import { useState } from "react";
import { useStreamLGP } from "./stream.lgp.js";
import { useStreamCustom } from "./stream.custom.js";
function isCustomOptions(options) {
    return "transport" in options;
}
export function useStream(options) {
    // Store this in useState to make sure we're not changing the implementation in re-renders
    const [isCustom] = useState(isCustomOptions(options));
    if (isCustom) {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        return useStreamCustom(options);
    }
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return useStreamLGP(options);
}
