"use strict";
//Protokol zajistujici komunikaci s Modbus PLC
//konstrukce a volani prikazu je z commManageru, publikace hodnot je do MQTT (liveDataPub)
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const myerror_1 = __importDefault(require("myerror"));
const mymqtt_1 = __importDefault(require("mymqtt"));
const utilities = __importStar(require("utilities"));
const modbus_serial_1 = __importDefault(require("modbus-serial"));
let errObj = new myerror_1.default("Modbus PLC", ["mqtt"]);
const sleep = require("util").promisify(setTimeout);
class modbusPLC {
    constructor() {
        this.terminate = false;
        this.blockRead = false;
        this.msgTimeout = 5000;
        this.client = {};
        this.mqttTopic = "";
        this.mqttUrl = process.env.mqttUrl || "mqtt://127.0.0.1:8883";
        this.certDir = process.env.certDir || "/data/certs/";
        this.tenantID = "1";
        //MQTT client komunikaci se stackem
        this.mqttInt = {};
        this.readTimer = null;
        this.maxGap = 100;
        this.maxItems = 200;
        /*dataToPub: Record<string, { value: string[] | number[] }> = {};
        dataPubTimeout: any = null;
        dataPubMaxTm: number = 1000; //maximalni perioda odesilani do MQTT [ms]
        dataPubMaxNr: number = 10; //maximalni davka po ktere se odesila do MQTT*/
        this.actTags = {}; //prvni adresa , objekt s vsemy daty pod danym tagem vcetne scale a tagu pro navrat
        this.readGroups = {}; //1.klic modbusID, 2.klic je typ oblasti (R H I O)
        this.connId = -1;
        this.connData = {};
        this.connStatus = { connected: false, data: { cycleTime: NaN } };
    }
    setID(id) {
        this.connId = id;
    }
    async init(plcInfo, tenantId) {
        try {
            this.client = new modbus_serial_1.default();
            this.connId = plcInfo.id;
            this.mqttTopic = "myscada/stack/liveDataPub/";
            if (tenantId != null) {
                this.mqttTopic += tenantId + "/";
                this.tenantID = tenantId;
            }
            this.mqttTopic += plcInfo.id;
            this.connData = plcInfo.data;
            //nastaveni optimalizaci
            if (this.connData.maxGap)
                this.maxGap = this.connData.maxGap;
            if (this.connData.maxLength)
                this.maxItems = this.connData.maxLength;
            //nastaveni timeoutu zpravy
            if (this.connData.timeout)
                this.msgTimeout = this.connData.timeout;
            //inicializace MQTT clienta
            this.mqttInt = new mymqtt_1.default(this.mqttUrl, async function (topic, message) { }, false, this.certDir + "mosquitto/client/", undefined, //cert
            undefined, //key
            undefined, //ca
            undefined, //user
            undefined, //pwd
            undefined, //clientId
            undefined, undefined, undefined, "myscada/stack/liveDataPub/" + tenantId + "/" + plcInfo.id, this.connData.bufferTimeout, this.connData.bufferItems);
            //casovac pro odesilani stavu PLC
            setInterval(async () => {
                try {
                    this.mqttInt.publish("myscada/stack/plcStatus/" + this.tenantID + "/" + plcInfo.id, JSON.stringify(this.connStatus));
                }
                catch (e) {
                    errObj.logWarn("Can't publish PLC staus message: " + e.message, this.tenantID);
                }
            }, 5000);
            await this.connect(5000);
        }
        catch (e) {
            errObj.logError("Can' init Modbus PLC " + e, this.tenantID);
            process.exit(1);
        }
    }
    async connect(timeoutMs) {
        return await new Promise(async (resolve, reject) => {
            errObj.logInfo("Connecting.", this.tenantID);
            try {
                if (!this.connData.transport || this.connData.transport == "tcp") {
                    this.client.connectTCP(this.connData.ip, { port: this.connData.port, timeout: timeoutMs }, (err) => {
                        if (err) {
                            errObj.logError("Can't connect to " + this.connData.ip + ":" + this.connData.port + ": " + err.message, this.tenantID);
                            this.connStatus.connected = false;
                            resolve(false);
                            return;
                        }
                        errObj.logInfo("Modbus PLC " + this.connData.ip + ":" + this.connData.port + " connected.", this.tenantID);
                        this.connStatus.connected = true;
                        //nastavi device ID
                        this.client.setID(this.connData.deviceId);
                        resolve(true);
                    });
                }
                else if (this.connData.transport == "udp") {
                    this.client.connectUDP(this.connData.ip, { port: this.connData.port }, (err) => {
                        if (err) {
                            errObj.logError("Can't connect to " + this.connData.ip + ":" + this.connData.port + ": " + err.message, this.tenantID);
                            this.connStatus.connected = false;
                            resolve(false);
                            return;
                        }
                        errObj.logInfo("Modbus PLC" + this.connData.ip + ":" + this.connData.port + " UDP socket created.", this.tenantID);
                        this.connStatus.connected = true;
                        //nastavi device ID
                        this.client.setID(this.connData.deviceId);
                        resolve(true);
                    });
                }
                else {
                    errObj.logError("Connect: Unknown transport type: " + this.connData.transport, this.tenantID);
                    this.connStatus.connected = false;
                    resolve(false);
                }
            }
            catch (e) {
                if (e instanceof Error) {
                    errObj.logError("Can't connect Modbus PLC: " + this.connData.ip + ":" + this.connData.port + ": " + e.message);
                }
                else {
                    errObj.logError("Can't connect Modbus PLC: " + this.connData.ip + ":" + this.connData.port + ": " + e);
                }
            }
        });
    }
    async optimzeTags(adresses) {
        this.readGroups = {};
        errObj.logDebug("Optimizing Tags: " + JSON.stringify(adresses), this.tenantID);
        let sortedTags = this.sortModbusTags(adresses);
        for (let tag in sortedTags) {
            //nastaveni user ID
            let baseTag = tag;
            let adrParts = tag.split(":");
            let modbusID = this.connData.deviceId;
            if (adrParts.length == 3) {
                modbusID = parseInt(adrParts[0]);
                baseTag = adrParts[1] + ":" + adrParts[2];
            }
            let match = baseTag.match(/([a-zA-Z]):(\d+)/);
            //overim format tagu a ze ma infromaci o delce
            if ((match === null || match === void 0 ? void 0 : match.length) == 3) {
                let type = match[1];
                let addr = parseInt(match[2]);
                let typeLen = (sortedTags[tag].bits || 16) / 16;
                //pokud ma tag vyplnene id
                /*if (adresses[tag].userData && adresses[tag].userData.hasOwnProperty("id")) {
                  let usrData: { id?: number } = adresses[tag].userData;
                  if (usrData.id != null) modbusID = usrData.id;
                }*/
                //pokud uz je v grupach tento typ oblasti
                if (this.readGroups.hasOwnProperty(modbusID) && this.readGroups[modbusID].hasOwnProperty(type)) {
                    //prochazim jednotlive existujici grupy
                    let tagPlaced = false;
                    for (let grp of this.readGroups[modbusID][type]) {
                        let grpEnd = grp.startAddr + grp.len - 1;
                        let tagEnd = addr + typeLen - 1;
                        //tag je mozne prilepit ke grupe pred
                        if (tagEnd < grp.startAddr && grp.startAddr - tagEnd < this.maxGap && grpEnd - addr < this.maxItems) {
                            //uprava grupy
                            grp.len = grp.len + (grp.startAddr - tagEnd + 1);
                            grp.startAddr = addr;
                            tagPlaced = true;
                            break;
                        }
                        //tag je mozne prilepit ke grupe za
                        else if (addr > grpEnd && addr - grpEnd < this.maxGap && tagEnd - grp.startAddr < this.maxItems) {
                            grp.len = tagEnd - grp.startAddr + 1;
                            tagPlaced = true;
                            break;
                        }
                        //adresu tagu uz je uvnitr grupy
                        else if (addr <= grpEnd && addr >= grp.startAddr && tagEnd - grp.startAddr < this.maxItems) {
                            //tag konci dale nez grupa
                            if (tagEnd > grpEnd) {
                                grp.len = tagEnd - grp.startAddr + 1;
                            }
                            tagPlaced = true;
                            break;
                        }
                    }
                    //pokud tag nebyl prirazen k zadne skupine vytvorime novou
                    if (!tagPlaced) {
                        this.readGroups[modbusID][type].push({ startAddr: addr, len: typeLen });
                    }
                }
                //pridavam prvni oblast
                else {
                    if (!this.readGroups.hasOwnProperty(modbusID))
                        this.readGroups[modbusID] = {};
                    this.readGroups[modbusID][type] = [{ startAddr: addr, len: typeLen }];
                }
            }
            else {
                errObj.logError("Wrong tag format: " + tag, this.tenantID);
            }
        }
        errObj.logDebug("Read Groups: " + JSON.stringify(this.readGroups), this.tenantID);
    }
    async readTags(adresses) {
        try {
            errObj.logDebug("Read Tags", this.tenantID);
            if (!this.connStatus.connected) {
                if (!(await this.connect(500))) {
                    errObj.logError("Can't connect PLC " + this.connData.ip + ":" + this.connData.port + ". Terminating read.", this.tenantID);
                    return;
                }
            }
            //vyplneni / update actTags
            for (let adress in adresses) {
                //pokud je zarazena k vycitani, poslu hodnotu, pokud je
                if (this.actTags.hasOwnProperty(adress)) {
                    //kontrola zda je tag stejny
                    if (this.actTags[adress].type != adresses[adress].type ||
                        JSON.stringify(this.actTags[adress].tags) != JSON.stringify(adresses[adress].tags) ||
                        JSON.stringify(this.actTags[adress].scale) != JSON.stringify(adresses[adress].scale)) {
                        //smazani posledni hodnoty a prirazeni novych hodnot
                        this.actTags[adress].value = [];
                        this.actTags[adress].type = adresses[adress].type;
                        this.actTags[adress].tags = adresses[adress].tags;
                        this.actTags[adress].scale = adresses[adress].scale;
                        this.actTags[adress].bits = adresses[adress].bits || 16;
                        this.actTags[adress].subtype = adresses[adress].subtype || "int";
                    }
                    else {
                        let dataToPub = {};
                        for (let tag of this.actTags[adress].tags) {
                            dataToPub[tag] = {
                                value: this.actTags[adress].value,
                            };
                        }
                        this.mqttInt.publishTags(dataToPub);
                    }
                }
                //
                else {
                    //pridani do aktivnich tagu
                    this.actTags[adress] = {
                        value: [],
                        type: adresses[adress].type,
                        tags: adresses[adress].tags,
                        scale: adresses[adress].scale,
                        bits: adresses[adress].bits || 16,
                        subtype: adresses[adress].subtype || "int",
                    };
                }
            }
            //naplneni read groups na zaklade optimalizacnich podminek
            this.optimzeTags(adresses);
            //odstartovani timeru vycitani dat
            let readInProgress = false;
            if (this.readTimer == null) {
                errObj.logInfo("Starting read loop.", this.tenantID);
                this.readTimer = setInterval(async () => {
                    var _a;
                    if (readInProgress) {
                        errObj.logWarn("Read in progress.", this.tenantID);
                        return;
                    }
                    else
                        readInProgress = true;
                    while (this.blockRead) {
                        await sleep(10);
                    }
                    let startTm = new Date();
                    //projiti vsech device ID
                    for (let deviceID in this.readGroups) {
                        this.client.setID(parseInt(deviceID));
                        await sleep(50);
                        //projdu jednotlive typy oblasti
                        for (let type in this.readGroups[deviceID]) {
                            //errObj.logDebug("Processing area: " + type, this.tenantID);
                            //projiti jednotlivych skupin
                            for (let grp of this.readGroups[deviceID][type]) {
                                let readedData = {};
                                try {
                                    //errObj.logDebug("Processing group: " + type + grp.startAddr + "  len: " + grp.len, this.tenantID);
                                    if (type == "H") {
                                        readedData = await Promise.race([
                                            this.client.readHoldingRegisters(grp.startAddr, grp.len),
                                            new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading holding registers")), this.msgTimeout)),
                                        ]);
                                    }
                                    else if (type == "R") {
                                        readedData = await Promise.race([
                                            this.client.readInputRegisters(grp.startAddr, grp.len),
                                            new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading input registers")), this.msgTimeout)),
                                        ]);
                                    }
                                    else if (type == "I") {
                                        readedData = await Promise.race([
                                            this.client.readDiscreteInputs(grp.startAddr, grp.len),
                                            new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading inputs")), this.msgTimeout)),
                                        ]);
                                    }
                                    else if (type == "O") {
                                        readedData = await Promise.race([
                                            this.client.readCoils(grp.startAddr, grp.len),
                                            new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading coils")), this.msgTimeout)),
                                        ]);
                                    }
                                    //errObj.logDebug("Processing group complete.", this.tenantID);
                                }
                                catch (e) {
                                    if (e instanceof Error) {
                                        errObj.logError("Can't read " + type + ":" + grp.startAddr + ", len " + grp.len + " :" + e.message, this.tenantID);
                                    }
                                    else {
                                        errObj.logError("Can't read " + type + ":" + grp.startAddr + ", len " + grp.len + " :" + e, this.tenantID);
                                    }
                                }
                                //propsani dat z oblasti zpet do tagu
                                if (((_a = readedData.data) === null || _a === void 0 ? void 0 : _a.length) > 0) {
                                    //projdu vsechny tagy pokusim se doplnit jejich hodnoty
                                    for (let address in this.actTags) {
                                        let adrParts = address.split(":");
                                        //jedna se o tag s uvedenym ID
                                        if (adrParts.length == 3 && adrParts[0] != deviceID)
                                            continue;
                                        //tag s defaultnim ID
                                        if (adrParts.length == 2 && parseInt(deviceID) != this.connData.deviceId)
                                            continue;
                                        let match = address.match(/([a-zA-Z]):(\d+)/);
                                        if ((match === null || match === void 0 ? void 0 : match.length) == 3) {
                                            let tagType = match[1];
                                            let addr = parseInt(match[2]);
                                            let tagValue = NaN;
                                            //pokud je adresa uvnitr vyctene oblasti
                                            if (type == tagType && addr >= grp.startAddr && addr + this.actTags[address].bits / 16 <= grp.startAddr + grp.len) {
                                                //viceregistrovy typ
                                                if (this.actTags[address].bits > 16) {
                                                    if (this.actTags[address].subtype == "int") {
                                                        tagValue = this.getInt(readedData.data.slice(addr - grp.startAddr, addr - grp.startAddr + this.actTags[address].bits / 16), this.actTags[address].bits, false, this.connData.byteOrder, this.connData.bitOrder);
                                                    }
                                                    else if (this.actTags[address].subtype == "uint") {
                                                        tagValue = this.getInt(readedData.data.slice(addr - grp.startAddr, addr - grp.startAddr + this.actTags[address].bits / 16), this.actTags[address].bits, true, this.connData.byteOrder, this.connData.bitOrder);
                                                    }
                                                    else if (this.actTags[address].subtype == "float") {
                                                        tagValue = this.getFloat(readedData.data.slice(addr - grp.startAddr, addr - grp.startAddr + this.actTags[address].bits / 16), this.actTags[address].bits, this.connData.byteOrder, this.connData.bitOrder);
                                                    }
                                                }
                                                else {
                                                    tagValue = readedData.data[addr - grp.startAddr];
                                                }
                                                this.processData(address, tagValue);
                                                //console.log(address + " = " + tagValue);
                                            }
                                        }
                                    }
                                }
                                else {
                                    errObj.logDebug("No data to process.", this.tenantID);
                                }
                            }
                        }
                    }
                    //update cycle time
                    let stopTm = new Date();
                    let data = { cycleTime: stopTm.getTime() - startTm.getTime() };
                    this.connStatus.data = data;
                    readInProgress = false;
                }, this.connData.refresh);
            }
        }
        catch (e) {
            if (e instanceof Error) {
                errObj.logError("Read error " + e.message, this.tenantID);
            }
            else {
                errObj.logError("Read error: " + e, this.tenantID);
            }
        }
    }
    reverseBits16(val) {
        val = ((val & 0x5555) << 1) | ((val >> 1) & 0x5555);
        val = ((val & 0x3333) << 2) | ((val >> 2) & 0x3333);
        val = ((val & 0x0f0f) << 4) | ((val >> 4) & 0x0f0f);
        val = ((val & 0x00ff) << 8) | ((val >> 8) & 0x00ff);
        return val;
    }
    getFloat(array, bits, byteOrder = "LE", bitOrder = "std") {
        if (bits !== 32 && bits !== 64) {
            errObj.logError("Only 32 or 64 bits are supported for floats", this.tenantID);
        }
        const totalBytes = bits / 8;
        if (array.length * 2 < totalBytes) {
            errObj.logError("Input array too short for specified float length", this.tenantID);
        }
        const byteList = [];
        for (let i = 0; i < totalBytes / 2; i++) {
            let word = array[i];
            if (bitOrder === "rev") {
                word = this.reverseBits16(word);
            }
            if (byteOrder === "BE") {
                byteList.push((word >> 8) & 0xff); // high byte
                byteList.push(word & 0xff); // low byte
            }
            else {
                byteList.push(word & 0xff); // low byte
                byteList.push((word >> 8) & 0xff); // high byte
            }
        }
        const buffer = new ArrayBuffer(totalBytes);
        const byteView = new Uint8Array(buffer);
        for (let i = 0; i < totalBytes; i++) {
            byteView[i] = byteList[i];
        }
        const view = new DataView(buffer);
        if (bits === 32) {
            return view.getFloat32(0, byteOrder === "LE");
        }
        else {
            return view.getFloat64(0, byteOrder === "LE");
        }
    }
    encodeFloat(value, bits, byteOrder = "LE", bitOrder = "std") {
        if (bits !== 32 && bits !== 64) {
            errObj.logError("Only 32 or 64 bits are supported for floats", this.tenantID);
        }
        const totalBytes = bits / 8;
        const buffer = new ArrayBuffer(totalBytes);
        const view = new DataView(buffer);
        if (bits === 32) {
            view.setFloat32(0, value, byteOrder === "LE");
        }
        else {
            view.setFloat64(0, value, byteOrder === "LE");
        }
        const byteView = new Uint8Array(buffer);
        const words = [];
        for (let i = 0; i < totalBytes; i += 2) {
            let byte1 = byteView[i];
            let byte2 = byteView[i + 1];
            let word;
            if (byteOrder === "BE") {
                word = (byte1 << 8) | byte2;
            }
            else {
                word = (byte2 << 8) | byte1;
            }
            if (bitOrder === "rev") {
                word = this.reverseBits16(word);
            }
            words.push(word);
        }
        return words;
    }
    getInt(array, bits, unsigned = false, byteOrder = "LE", bitOrder = "std") {
        if (bits !== 32 && bits !== 64) {
            errObj.logError("Only 32 or 64 bits supported", this.tenantID);
        }
        const totalBytes = bits / 8;
        if (array.length * 2 < totalBytes) {
            errObj.logError("Input array too short for specified bit length", this.tenantID);
        }
        // Build byte list from 16-bit words
        const byteList = [];
        for (let i = 0; i < totalBytes / 2; i++) {
            let word = array[i];
            if (bitOrder === "rev") {
                word = this.reverseBits16(word);
            }
            if (byteOrder === "BE") {
                byteList.push((word >> 8) & 0xff); // high byte first
                byteList.push(word & 0xff); // low byte
            }
            else {
                byteList.push(word & 0xff); // low byte first
                byteList.push((word >> 8) & 0xff); // high byte
            }
        }
        // Copy bytes into buffer
        const buffer = new ArrayBuffer(totalBytes);
        const byteView = new Uint8Array(buffer);
        for (let i = 0; i < totalBytes; i++) {
            byteView[i] = byteList[i];
        }
        const view = new DataView(buffer);
        if (bits === 32) {
            return unsigned ? view.getUint32(0, byteOrder === "LE") : view.getInt32(0, byteOrder === "LE");
        }
        else {
            return unsigned ? view.getBigUint64(0, byteOrder === "LE") : view.getBigInt64(0, byteOrder === "LE");
        }
    }
    encodeInt(value, bits, byteOrder = "LE", bitOrder = "std") {
        if (bits !== 32 && bits !== 64) {
            errObj.logError("Only 32 or 64 bits supported", this.tenantID);
        }
        const totalBytes = bits / 8;
        const buffer = new ArrayBuffer(totalBytes);
        const view = new DataView(buffer);
        if (bits === 32) {
            view.setUint32(0, Number(value), byteOrder === "LE");
        }
        else {
            view.setBigUint64(0, BigInt(value), byteOrder === "LE");
        }
        const byteView = new Uint8Array(buffer);
        const words = [];
        for (let i = 0; i < totalBytes; i += 2) {
            let byte1 = byteView[i];
            let byte2 = byteView[i + 1];
            let word;
            if (byteOrder === "BE") {
                word = (byte1 << 8) | byte2;
            }
            else {
                word = (byte2 << 8) | byte1;
            }
            if (bitOrder === "rev") {
                word = this.reverseBits16(word);
            }
            words.push(word);
        }
        return words;
    }
    async delTags(addresses) {
        //prochazi tagy ke smazani
        for (let adrToDel in addresses) {
            //prochazi monitorovane polozky
        }
    }
    async reloadConnection(plcInfo) {
        //opoji stavajici connection, znovu pripoji s novymi parametry, znovu nacte vsechny aktivni tagy
        this.client.destroy();
        await this.connect(5000);
        let currentActTags = JSON.parse(JSON.stringify(this.actTags));
        this.actTags = {};
        await this.readTags(currentActTags);
    }
    //
    processData(tagName, dataValue) {
        var _a;
        try {
            //zpracovavam pouze pokud je to vycitany tag
            if (this.actTags.hasOwnProperty(tagName)) {
                //ulozim hodnotu
                let tmpVal = [];
                //pokud je to pole vkladam naprimo
                if (Array.isArray(dataValue)) {
                    tmpVal = dataValue;
                    //single hodnotu vkladam jako pole
                }
                else
                    tmpVal.push(dataValue);
                //nacteni scale
                let scale;
                if ((_a = this.actTags) === null || _a === void 0 ? void 0 : _a[tagName].scale) {
                    scale = this.actTags[tagName].scale;
                }
                //projde vschny hodnoty v poli
                for (let idx in tmpVal) {
                    //nahrada true/false
                    if (tmpVal[idx] === false)
                        tmpVal[idx] = 0;
                    else if (tmpVal[idx] === true)
                        tmpVal[idx] = 1;
                    //scale
                    if (scale && typeof tmpVal[idx] == "number") {
                        tmpVal[idx] = tmpVal[idx] * (scale.A / scale.B) + scale.C;
                    }
                }
                //ulozeni a publikace pouze pri zmene tagu ( u bigint nepocitam s polem)
                if ((!this.isBigIntArray(tmpVal) && JSON.stringify(this.actTags[tagName].value) != JSON.stringify(tmpVal)) ||
                    !this.compareBigIntArrays(this.actTags[tagName].value, tmpVal)) {
                    this.actTags[tagName].value = tmpVal;
                    //projdu vsechny tagy a pridam k odeslani
                    let dataToPub = {};
                    for (let tag of this.actTags[tagName].tags) {
                        dataToPub[tag] = {
                            value: this.actTags[tagName].value,
                        };
                    }
                    this.mqttInt.publishTags(dataToPub);
                }
            }
        }
        catch (e) {
            errObj.logError("Process data error: " + e, this.tenantID);
        }
    }
    isBigIntArray(value) {
        return Array.isArray(value) && value.every((v) => typeof v === "bigint");
    }
    compareBigIntArrays(a, b) {
        if (a.length !== b.length)
            return false;
        for (let i = 0; i < a.length; i++) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    }
    async writeTags(adresses) {
        try {
            errObj.logDebug("Write Tags", this.tenantID);
            if (!this.connStatus.connected) {
                if (!(await this.connect(500))) {
                    errObj.logError("Can't connect PLC " + this.connData.ip + ":" + this.connData.port + ". Terminating write.", this.tenantID);
                    return;
                }
            }
            for (let adress in adresses) {
                let writeTag = adresses[adress];
                /*//nastaveni user ID
                if (writeTag.userData && writeTag.userData.hasOwnProperty("id")) {
                  let usrData: { id?: number } = writeTag.userData;
                  if (usrData.id != null) this.client.setID(usrData.id);
                  else this.client.setID(this.connData.deviceId);
                } else this.client.setID(this.connData.deviceId);*/
                if (writeTag.wData) {
                    let wData = writeTag.wData;
                    //je to single hodnota
                    let tmpVal = null;
                    let tagName = writeTag.tags[0]; //pro zjisteni zda to je bit nebo prvek pole
                    let isBit = false;
                    let isArrayItem = false;
                    let arrIdx = 0;
                    let bitNr = 0;
                    let parentTag = tagName;
                    let pattern = /(.+)(\[(.+)\]$)|(.+)((\[(.+)\])\/(\d+)$)|(.+)(\/(\d+)$)/;
                    let matchBit = tagName.match(pattern);
                    let lastVal = null;
                    if (matchBit) {
                        //pokud je zarazena k vycitani zkontroluju ze je vycena hodnota
                        if (this.actTags.hasOwnProperty(adress)) {
                            if (this.actTags[adress].value != null) {
                                lastVal = this.actTags[adress].value;
                            }
                            else {
                                errObj.logError("Value of tag: " + adress + " not readed for write ", this.tenantID);
                                continue;
                            }
                        }
                        //pokud se jeste nevycita pridam k vycitani a cekam na hodnotu
                        else {
                            await this.readTags({ adress: writeTag });
                            //cekani na vycteni dat (je potreba minimlne type)
                            const startTime = Date.now();
                            await new Promise((resolve, reject) => {
                                const checkInterval = setInterval(() => {
                                    // Check if the condition is met
                                    if (this.actTags[adress].value != null && this.actTags[adress].value.length > 0) {
                                        clearInterval(checkInterval); // Stop the interval
                                        resolve(true); // Resolve the promise
                                        return;
                                    }
                                    // Check for timeout
                                    if (Date.now() - startTime > 15000) {
                                        clearInterval(checkInterval); // Stop the interval
                                        errObj.logError("Tag " + adress + " not ready for write.", this.tenantID);
                                        reject(new Error("Timeout exceeded while waiting for tag.type"));
                                    }
                                }, 500);
                            });
                        }
                        //je to prvek pole
                        if (matchBit[1]) {
                            isArrayItem = true;
                            arrIdx = parseInt(matchBit[3]);
                            parentTag = matchBit[1];
                        }
                        //je to bit z pole
                        else if (matchBit[4]) {
                            isBit = true;
                            isArrayItem = true;
                            arrIdx = parseInt(matchBit[7]);
                            bitNr = parseInt(matchBit[8]);
                            parentTag = matchBit[4];
                        }
                        //je to bit
                        else if (matchBit[9]) {
                            isBit = true;
                            bitNr = parseInt(matchBit[11]);
                            parentTag = matchBit[9];
                        }
                        //je to polozka pole pripadne polozka pole a bit
                        if (lastVal != null) {
                            tmpVal = lastVal;
                            if (isArrayItem) {
                                if (isBit) {
                                    tmpVal[arrIdx] = utilities.setBit(lastVal[arrIdx], wData[0], bitNr);
                                }
                                else {
                                    tmpVal[arrIdx] = wData[0];
                                }
                            }
                            //je to bit
                            else if (isBit) {
                                tmpVal = utilities.setBit(lastVal[0], wData[0], bitNr);
                            }
                        }
                        else if (isArrayItem || isBit) {
                            continue;
                        }
                    }
                    //nejedna se o bit ani prvek pole
                    else {
                        //TODO dodelat toggle inc/dec
                        if (wData.length == 1)
                            tmpVal = wData[0];
                        else {
                            tmpVal = wData;
                        }
                    }
                    /*let writeItem: any = {
                      nodeId: adress,
                      attributeId: 0,
                      value: {
                        value: {
                          dataType: opcType,
                          value: tmpVal,
                          //value: new Uint16Array(tmpVal),
                        },
                      },
                    };*/
                    //nastaveni user ID
                    let adrParts = adress.split(":");
                    if (adrParts.length == 3) {
                        this.client.setID(parseInt(adrParts[0]));
                        adress = adrParts[1] + ":" + adrParts[2];
                    }
                    else
                        this.client.setID(this.connData.deviceId);
                    let match = adress.match(/([a-zA-Z]):(\d+)/);
                    //overim format tagu a ze ma infromaci o delce
                    if ((match === null || match === void 0 ? void 0 : match.length) == 3) {
                        let type = match[1];
                        let addr = parseInt(match[2]);
                        this.blockRead = true;
                        if (type == "H") {
                            //rozlozeni delsich typu do registru
                            if (writeTag.bits && writeTag.bits > 16) {
                                if (!writeTag.subtype || writeTag.subtype == "int") {
                                    tmpVal = this.encodeInt(tmpVal, writeTag.bits, this.connData.byteOrder, this.connData.bitOrder);
                                }
                                else if (writeTag.subtype == "float") {
                                    tmpVal = this.encodeFloat(tmpVal, writeTag.bits, this.connData.byteOrder, this.connData.bitOrder);
                                }
                                else {
                                    errObj.logError("Can't write: Unsupported subtype: " + writeTag.subtype, this.tenantID);
                                }
                            }
                            else {
                                tmpVal = [tmpVal];
                            }
                            if (this.connData.useSingleWrites) {
                                for (let singleVal of tmpVal) {
                                    await Promise.race([
                                        this.client.writeRegister(addr, singleVal),
                                        new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading input registers")), this.msgTimeout)),
                                    ]);
                                    addr++;
                                }
                            }
                            else {
                                await Promise.race([
                                    this.client.writeRegisters(addr, tmpVal),
                                    new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading input registers")), this.msgTimeout)),
                                ]);
                            }
                        }
                        else if (type == "O") {
                            tmpVal = [tmpVal];
                            if (this.connData.useSingleWrites) {
                                for (let singleVal of tmpVal) {
                                    await Promise.race([
                                        this.client.writeCoil(addr, singleVal),
                                        new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading input registers")), this.msgTimeout)),
                                    ]);
                                    addr++;
                                }
                            }
                            else {
                                await Promise.race([
                                    this.client.writeCoils(addr, tmpVal),
                                    new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout reading input registers")), this.msgTimeout)),
                                ]);
                            }
                        }
                        else if (type == "R") {
                            errObj.logWarn("Write not allowed on input registers", this.tenantID);
                        }
                        else if (type == "I") {
                            errObj.logWarn("Write not allowed on input registers", this.tenantID);
                        }
                        this.blockRead = false;
                    }
                }
            }
        }
        catch (e) {
            this.blockRead = false;
            if (e instanceof Error) {
                errObj.logError("General write error: " + e.message, this.tenantID);
            }
            else {
                errObj.logError("General write error: " + e, this.tenantID);
            }
        }
    }
    stopExec() {
        this.terminate = true;
    }
    sortModbusTags(tags) {
        const sortedEntries = Object.entries(tags).sort(([keyA], [keyB]) => {
            const [prefixA, numA] = keyA.split(":");
            const [prefixB, numB] = keyB.split(":");
            if (prefixA < prefixB)
                return -1;
            if (prefixA > prefixB)
                return 1;
            return Number(numA) - Number(numB);
        });
        return Object.fromEntries(sortedEntries);
    }
}
exports.default = modbusPLC;
