"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripArrayTags = stripArrayTags;
exports.stripArrayTag = stripArrayTag;
exports.getTagValue = getTagValue;
exports.tagsToArrayTags = tagsToArrayTags;
exports._post = _post;
exports._get = _get;
exports.formatDate = formatDate;
exports.formatNumber = formatNumber;
exports.getLocalizedStringForObject = getLocalizedStringForObject;
exports.processMessageWithTagReplace = processMessageWithTagReplace;
exports.readLiveAlarms = readLiveAlarms;
exports.getHistoAlarms = getHistoAlarms;
exports.getTagStatistics = getTagStatistics;
exports.getHistoricalData = getHistoricalData;
exports.getHistoricalDataAsTable = getHistoricalDataAsTable;
exports.sendWriteRequest = sendWriteRequest;
exports.getTagNames = getTagNames;
exports.removeTags = removeTags;
exports.removeTagsStartingWith = removeTagsStartingWith;
exports.addTag = addTag;
exports.stripMarkdown = stripMarkdown;
exports.markdownToWordXml = markdownToWordXml;
exports.searchUsingAI = searchUsingAI;
exports.chatWithAI = chatWithAI;
exports.searchAI = searchAI;
exports.notifyObj = notifyObj;
exports.notifyReport = notifyReport;
exports.notifyAlarms = notifyAlarms;
exports.notify = notify;
exports.liveDataGet = liveDataGet;
exports.sleep = sleep;
exports.codeTableGet = codeTableGet;
exports.getLocalizedText = getLocalizedText;
const http_1 = __importDefault(require("http"));
//const MarkdownIt = require("markdown-it");
const markdown_it_1 = __importDefault(require("markdown-it"));
//const http = require("http");
function stripArrayTags(tags) {
    let _tags = [];
    for (let _t of tags) {
        let t = _t;
        if (t.includes("/")) {
            t = t.split("/")[0];
        }
        if (t.includes("[") && !t.includes("].")) {
            t = t.split("[")[0];
        }
        if (!_tags.includes(t)) {
            _tags.push(t);
        }
    }
    return _tags;
}
function stripArrayTag(tag) {
    let t = tag;
    if (t.includes("/")) {
        t = t.split("/")[0];
    }
    if (t.includes("[") && !t.includes("].")) {
        t = t.split("[")[0];
    }
    return t;
}
function getTagValue(tagIn, value) {
    let index = -1;
    let bit = -1;
    let tag = tagIn;
    if (tagIn.includes("/")) {
        let parts = tag.split("/");
        bit = parseInt(parts[1]);
        tag = parts[0];
    }
    //zprocesujeme i pole
    if (tag.includes("[") && !tag.includes("].")) {
        //kolikaty je to index v poli
        let match = tag.match(/\[(\d+)\]$/);
        if (match) {
            index = parseInt(match[1]);
        }
        tag = tag.split("[")[0];
    }
    if (index == -1 && bit == -1) {
        return value;
    }
    if (index == -1) {
        index = 0;
    }
    if (value.length < index - 1) {
        return null;
    }
    let v = value[index];
    if (bit >= 0) {
        v = (v >>> bit) & 1;
    }
    return [v];
}
function tagsToArrayTags(arrayTags, tags) {
    let res = {};
    for (let t of arrayTags) {
        let tag = stripArrayTag(t);
        let o = tags[tag];
        if (o) {
            res[t] = getTagValue(t, o.value);
        }
    }
    return res;
}
function _post(tenantid, url, port, postData, customIP) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            let data = "";
            // Options for the POST request
            let ip = "127.0.0.1";
            if (customIP) {
                ip = customIP;
            }
            const options = {
                hostname: ip,
                port: port,
                path: url,
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "Content-Length": Buffer.byteLength(postData),
                    "x-tenantid": tenantid,
                    apikey: "internalapi",
                },
            };
            // Make the POST request
            const req = http_1.default.request(options, (res) => {
                // Handling response data
                res.on("data", (chunk) => {
                    data += chunk;
                });
                res.on("end", () => {
                    try {
                        let d = JSON.parse(data);
                        resolve(d);
                    }
                    catch (e) {
                        reject(e);
                    }
                });
            });
            // Handling errors
            req.on("error", (error) => {
                reject(error);
            });
            // Send the data
            req.write(postData);
            req.end();
        });
    });
}
function _get(url) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            let data = "";
            const req = http_1.default.get(url, (res) => {
                res.on("data", (chunk) => {
                    data += chunk;
                });
                res.on("end", () => {
                    try {
                        let d = JSON.parse(data);
                        resolve(d);
                    }
                    catch (e) {
                        reject(e);
                    }
                });
            });
            // Handling HTTP request errors
            req.on("error", (err) => {
                reject(new Error("HTTP request failed: " + err.message));
            });
            // Timeout handler
            req.on("timeout", () => {
                req.abort();
                reject(new Error("HTTP request timed out"));
            });
        });
    });
}
function formatDate(date, format, locale = "en-US") {
    try {
        date = new Date(date);
        const monthLong = new Intl.DateTimeFormat(locale, { month: "long" }).format(date);
        const yyyy = date.getFullYear() + "";
        const MM = String(date.getMonth() + 1).padStart(2, "0");
        const dd = String(date.getDate()).padStart(2, "0");
        const HH = String(date.getHours()).padStart(2, "0");
        const hh = String(date.getHours() % 12 || 12).padStart(2, "0");
        const mm = String(date.getMinutes()).padStart(2, "0");
        const ss = String(date.getSeconds()).padStart(2, "0");
        const a = date.getHours() < 12 ? "AM" : "PM";
        return format
            .replace(/yyyy/g, yyyy)
            .replace(/MMMM/g, monthLong)
            .replace(/MM/g, MM)
            .replace(/dd/g, dd)
            .replace(/HH/g, HH)
            .replace(/hh/g, hh)
            .replace(/mm/g, mm)
            .replace(/ss/g, ss)
            .replace(/\ba\b/g, a); // match only whole word "a" to avoid false positives
    }
    catch (e) {
        return "";
    }
}
function formatNumber(value, format) {
    if (value == null) {
        return "";
    }
    // Split the format into integer and decimal parts
    const [intFormat, decimalFormat] = format.split(".");
    // Split the value into integer and decimal parts
    let [intValue, decimalValue] = value.toString().split(".");
    intValue = intValue || "0"; // Fallback if integer part is empty
    decimalValue = decimalValue || ""; // Fallback if decimal part is missing
    // Handle the integer part
    let formattedInt = "";
    let intFormatIndex = intFormat.length - 1;
    let intValueIndex = intValue.length - 1;
    // This loop ensures that all digits are kept and not dropped
    while (intFormatIndex >= 0 || intValueIndex >= 0) {
        let currentFormatChar = intFormat[intFormatIndex] || "#"; // Default to '#' when the format string ends
        if (currentFormatChar === "0" || currentFormatChar === "#") {
            // Add the corresponding number or pad with 0 if needed
            formattedInt = (intValueIndex >= 0 ? intValue[intValueIndex] : currentFormatChar === "0" ? "0" : "") + formattedInt;
            intValueIndex--;
        }
        else {
            // Add any other characters in the format (like commas, spaces)
            formattedInt = currentFormatChar + formattedInt;
        }
        intFormatIndex--;
    }
    // Handle the decimal part if specified in the format
    let formattedDecimal = "";
    if (decimalFormat) {
        for (let i = 0; i < decimalFormat.length; i++) {
            if (decimalFormat[i] === "0" || decimalFormat[i] === "#") {
                // Add the corresponding decimal digits or pad with 0 if required
                formattedDecimal += decimalValue[i] || (decimalFormat[i] === "0" ? "0" : "");
            }
            else {
                formattedDecimal += decimalFormat[i];
            }
        }
    }
    // Combine the integer and decimal parts
    let result = formattedInt;
    if (formattedDecimal) {
        result += "." + formattedDecimal;
    }
    // Replace any custom text part in the format (for cases like "Value 00.00 °C")
    return format.replace(/[#0.,]+/, result);
}
function getLocalizedStringForObject(d, language, defaultStr) {
    if (d == null) {
        return defaultStr;
    }
    if (typeof d === "string") {
        return d;
    }
    let m = d[language];
    if (!m) {
        m = d["en"];
    }
    if (!m) {
        let klic = Object.keys(d);
        if (klic.length > 0) {
            m = d[klic[0]];
        }
        else {
            m = defaultStr;
        }
    }
    return m;
}
function processMessageWithTagReplace(tag, language, message) {
    let _tag = {
        tagFormat: tag.format,
        tagUnit: tag.unit,
        tagLabel: tag.label,
        tagNote: tag.note,
        message: message,
        id: tag._id,
    };
    correctAlarms([_tag], language);
    return _tag.message;
}
function correctAlarms(items, _language, definition, tf) {
    for (let d of items) {
        let langs = [];
        if (typeof _language === "string") {
            langs = [_language];
        }
        else {
            langs = _language;
        }
        let finalMsg = {};
        for (let i = 0; i < langs.length; i++) {
            let language = langs[i];
            //zapracujeme prevod datumu pokud je definovano tf
            if (tf) {
                let newDat = formatDate(d.tf, tf, language);
                d.tf = newDat;
                if (d.actTime) {
                    d.actTime = formatDate(d.actTime, tf, language);
                }
                if (d.deActTime) {
                    d.deActTime = formatDate(d.deActTime, tf, language);
                }
                if (d.confTime) {
                    d.confTime = formatDate(d.confTime, tf, language);
                }
                let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                if (d.value != null)
                    d.value = formatNumber(d.value, m);
                if (d.difference != null)
                    d.difference = formatNumber(d.difference, m);
                if (d.limit != null)
                    d.limit = formatNumber(d.limit, m);
                if (d.limitto != null)
                    d.limitto = formatNumber(d.limitto, m);
                if (d.action === 0) {
                    d.status = "ACT";
                }
                else if (d.action === 1) {
                    d.status = "DEACT";
                }
                else if (d.action === 2) {
                    d.status = "CONF";
                }
                else if (d.action === 3) {
                    d.status = "SUPP";
                }
                else if (d.action === 4) {
                    d.status = "UNSUPP";
                }
                else if (d.action === 5) {
                    d.status = "ERRORED";
                }
                else {
                    d.status = "?";
                }
            }
            let m = getLocalizedStringForObject(d.message, language, "");
            //neni nastavena zprava pro alarmy vytvorime defaultni
            if (m == null || m == "") {
                m = "{tag.labelOrName}. Value: {tag.value}{tag.unit}. Limit: {limit.value}{tag.unit}.";
            }
            m = m.replace(/\{tagValue:(\d+)(?:\s+DP:([^\s\}]+))?(?:\s+L:([^\s\}]+))?(?:\s+VTT:([^\}]+))?\}/g, (_, index, dpRaw, lenRaw, vtRaw) => {
                const indexInteger = parseInt(index, 10);
                if (d.addTags && Array.isArray(d.addTags) && d.addTags.length > indexInteger) {
                    const value = d.addTags[indexInteger];
                    // Validate DP and L
                    const dp = /^\d+$/.test(dpRaw) ? parseInt(dpRaw, 10) : null;
                    const len = /^\d+$/.test(lenRaw) ? parseInt(lenRaw, 10) : null;
                    // Parse VT map if provided
                    let vtMap = null;
                    if (vtRaw) {
                        vtMap = {};
                        vtRaw.split(",").forEach((pair) => {
                            const [k, v] = pair.split("=");
                            if (k && v)
                                vtMap[k.trim()] = v.trim();
                        });
                    }
                    if (typeof value === "number") {
                        if (vtMap) {
                            // Match value as a string to VT map keys
                            const mapped = vtMap[String(value)];
                            return mapped !== undefined ? mapped : "?";
                        }
                        else if (dp !== null) {
                            return value.toFixed(dp);
                        }
                        else if (!Number.isInteger(value)) {
                            return value.toFixed(2); // default rounding
                        }
                        else {
                            return value.toString(); // integer
                        }
                    }
                    else if (typeof value === "string") {
                        if (len !== null) {
                            return value.substring(0, len);
                        }
                        else {
                            return value;
                        }
                    }
                }
                return "?"; // fallback for invalid index or type
            });
            let msg = m.replace(/\{([^}]+)\}/g, (match, path) => {
                if (path === "tag.value") {
                    if (definition) {
                        return "__VALUE__";
                    }
                    if (d.value == null) {
                        return "?";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.value, m);
                    }
                    else {
                        return d.value;
                    }
                }
                else if (path === "limit.value") {
                    if (d.limit == null) {
                        return "---";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.limit, m);
                    }
                    else {
                        return d.limit;
                    }
                }
                else if (path === "limit.valueto") {
                    if (d.limitto == null) {
                        return "---";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.limitto, m);
                    }
                    else {
                        return d.limitto;
                    }
                }
                else if (path === "limit.difference") {
                    if (definition) {
                        return "__DIFFERENCE__";
                    }
                    if (d.difference == null) {
                        return "---";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.difference, m);
                    }
                    else {
                        return d.difference;
                    }
                }
                else if (path === "tag.unit") {
                    if (d.tagUnit) {
                        return getLocalizedStringForObject(d.tagUnit, language, "");
                    }
                    else {
                        return "";
                    }
                }
                else if (path === "tag.label") {
                    if (d.tagLabel) {
                        return getLocalizedStringForObject(d.tagLabel, language, "");
                    }
                    else {
                        return "";
                    }
                }
                else if (path === "tag.labelOrName") {
                    if (d.tagLabel) {
                        return getLocalizedStringForObject(d.tagLabel, language, "");
                    }
                    else {
                        let parts = d.id.split("#");
                        let msg = parts[0].split(".").slice(1).join(".");
                        if (parts.length > 1) {
                            if (parts[1].includes("HH")) {
                                msg = msg + " HH";
                            }
                            else if (parts[1].includes("H")) {
                                msg = msg + " HH";
                            }
                            if (parts[1].includes("LL")) {
                                msg = msg + " L";
                            }
                            else if (parts[1].includes("L")) {
                                msg = msg + " L";
                            }
                        }
                        return msg;
                    }
                }
                else if (path === "tag.note") {
                    if (d.tagNote) {
                        return getLocalizedStringForObject(d.tagNote, language, "");
                    }
                    else {
                        return "";
                    }
                }
                else if (path === "tag.name") {
                    return d.id.split("#")[0];
                }
                return match;
            });
            if (langs.length > 1) {
                finalMsg[langs[i]] = msg;
            }
            else {
                d.message = msg;
            }
        }
        if (langs.length > 1) {
            d.message = finalMsg;
        }
    }
}
//read active alarms
function readLiveAlarms(language, filterType, filterActions, tf, all, definition) {
    return __awaiter(this, void 0, void 0, function* () {
        let url = "/apiv1/live/alarms/?type=getLiveAlarms";
        if (all) {
            url = url + "&filter=all";
        }
        url += "&_=" + new Date().getTime();
        let ret = null;
        try {
            let config = {
                method: "GET",
                hostname: "127.0.0.1",
                path: url,
                port: 4101,
                //mode: "cors",
                headers: {
                    //  "Access-Control-Allow-Origin": "*",
                    "x-tenantid": this.tenantID,
                    apikey: "internalapi",
                },
            };
            try {
                ret = yield _get(config);
            }
            catch (e) {
                try {
                    yield sleep(300);
                    ret = yield _get(config);
                }
                catch (e) {
                    return null;
                }
            }
        }
        catch (e) { }
        if (ret && ret.data) {
            correctAlarms(ret.data, language, definition, tf);
        }
        else {
            return null;
        }
        if (filterType || filterActions) {
            let f = {
                alarm: true,
                warning: true,
                errored: true,
                active_confirmed: true,
                active_notconfirmed: true,
                active_suppresed: true,
                inactive_confirmed: true,
                inactive_notconfirmed: true,
                inactive_suppresed: true,
            };
            if (filterType) {
                f.alarm = filterType.alarm;
                f.warning = filterType.warning;
                f.errored = filterType.errored;
            }
            if (filterActions) {
                f.active_confirmed = filterActions.active_confirmed;
                f.active_notconfirmed = filterActions.active_notconfirmed;
                f.active_suppresed = filterActions.active_suppresed;
                f.inactive_confirmed = filterActions.inactive_confirmed;
                f.inactive_notconfirmed = filterActions.inactive_notconfirmed;
                f.inactive_suppresed = filterActions.inactive_suppresed;
            }
            let filtered = [];
            for (let alm of ret.data) {
                //Alarm | Warning
                if (alm.error != null) {
                    if (f.errored) {
                        filtered.push(alm);
                    }
                }
                else if ((!alm.warning && f.alarm) || (alm.warning && f.warning)) {
                    if (alm.active) {
                        // aktivni
                        if (f.active_confirmed && alm.confirmed) {
                            filtered.push(alm);
                        }
                        else if (f.active_notconfirmed && !alm.confirmed) {
                            filtered.push(alm);
                        }
                        else if (f.active_suppresed && !alm.suppresed) {
                            filtered.push(alm);
                        }
                    }
                    else if (!alm.active) {
                        // neaktivni
                        if (f.inactive_confirmed && alm.confirmed) {
                            filtered.push(alm);
                        }
                        else if (f.inactive_notconfirmed && !alm.confirmed) {
                            filtered.push(alm);
                        }
                        else if (f.inactive_suppresed && !alm.suppresed) {
                            filtered.push(alm);
                        }
                    }
                }
            }
            return filtered;
        }
        return ret.data;
    });
}
//get historical alarms from system
function getHistoAlarms(language, from, to, limit, type, FilterType, FilterCategory, limitPerTag, ids, tfFormat) {
    return __awaiter(this, void 0, void 0, function* () {
        let fc = [];
        if (FilterCategory) {
            fc = FilterCategory;
        }
        //let time1 = new Date().getTime();
        // posilat na /oauth pokud je uzivatel prihlasen
        let url = "/apiv1/history/";
        if (process.env.NODE_ENV === "development") {
            url = "http://localhost:4101/apiv1/history/";
        }
        url = url + "alarms?from=" + encodeURIComponent(from.toISOString());
        url = url + "&to=" + encodeURIComponent(to.toISOString());
        if (limit) {
            url = url + "&limit=" + encodeURIComponent(limit);
        }
        if (limitPerTag) {
            url = url + "&limitPerTag=" + encodeURIComponent(limitPerTag);
        }
        if (ids && ids.length > 0) {
            let idstext = "";
            for (const col of ids) {
                idstext = idstext + "&ids[]=" + encodeURIComponent(col);
            }
            url = url + idstext;
        }
        if (type && type.error) {
            url = url + "&error=true";
        }
        if (type && type.warning) {
            url = url + "&warning=true";
        }
        if (FilterType) {
            let pole = [];
            if (FilterType.Activate) {
                pole.push(0);
            }
            if (FilterType.Deactivate) {
                pole.push(1);
            }
            if (FilterType.Confirm) {
                pole.push(2);
            }
            if (FilterType.Suppress) {
                pole.push(3);
            }
            if (FilterType.Unsuppress) {
                pole.push(4);
            }
            if (FilterType.Error) {
                pole.push(5);
            }
            url = url + "&filterType=" + encodeURIComponent(pole.join("|"));
        }
        if (fc && Array.isArray(fc) && fc.length > 0) {
            url = url + "&filterCategory=" + encodeURIComponent(JSON.stringify(fc));
        }
        url += "&_=" + new Date().getTime();
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        let ret = null;
        try {
            ret = yield _get(config);
        }
        catch (e) {
            try {
                yield sleep(300);
                ret = yield _get(config);
            }
            catch (e) {
                return null;
            }
        }
        if (ret && !ret.error) {
            correctAlarms(ret, language, undefined, tfFormat);
            //spojime alarmy do skupin, tj zgrupujeme dle id
            /*
            if (group) {
              const groupedData = ret.reduce((acc: any, item: any) => {
                let status = "";
                if (item.action == 0) {
                  status = "Activation";
                }
                if (item.action == 1) {
                  status = "Deactivation";
                }
                if (item.action == 3) {
                  status = "Confirmation";
                }
                if (item.action == 4) {
                  status = "Suppressed";
                }
                if (item.action == 5) {
                  status = "Unsuppressed";
                }
                if (item.action == 6) {
                  status = "Errored";
                }
        
                let type = "error";
                if (item.warning) {
                  type = "warning";
                }
        
                if (!acc[item.id]) {
                  let unit = getLocalizedStringForObject(item.tagUnit, language, "");
        
                  acc[item.id] = {
                    message: item.message,
                    categories: item.categories,
                    type: type,
                    unit: unit,
                    limit: item.limit,
                    history: [],
                  };
                }
        
                acc[item.id].history.push({ time: item.tf, status: status, value: item.value });
                return acc;
              }, {});
        
              ret = Object.values(groupedData);
            }
            */
        }
        else {
            return null;
        }
        return ret;
    });
}
function getTagStatistics(tag, from, to, statistics, limit) {
    return __awaiter(this, void 0, void 0, function* () {
        let time1 = new Date().getTime();
        let itms = tag.split(".");
        let firstItem = itms.shift();
        if (firstItem === "0") {
        }
        else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
            tag = this.connections.name[firstItem] + "." + itms.join(".");
        }
        let url = "/apiv1/history/";
        url = url + "statistics?from=" + encodeURIComponent(from.toISOString());
        url = url + "&to=" + encodeURIComponent(to.toISOString());
        if (limit) {
            url = url + "&limit=" + encodeURIComponent(limit);
        }
        if (tag) {
            url = url + "&tag=" + encodeURIComponent(tag);
        }
        if (statistics) {
            url = url + "&statistics=" + encodeURIComponent(statistics);
        }
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        let ret = null;
        try {
            ret = yield _get(config);
        }
        catch (e) {
            try {
                yield sleep(300);
                ret = yield _get(config);
            }
            catch (e) {
                return null;
            }
        }
        return ret;
    });
}
function getHistoricalData(tgs, from, to, _groupBy, groupByValue, customGroupBy, limit, densify, fillEndValue, fillStartValue, formatValuesLanguage, tfFormat) {
    return __awaiter(this, void 0, void 0, function* () {
        let time1 = new Date().getTime();
        if (_groupBy === "---") {
            _groupBy = "raw";
        }
        let groupBy = _groupBy === "raw" ? "" : _groupBy;
        if (!Array.isArray(tgs)) {
            tgs = [tgs];
        }
        let tags = [];
        for (let t of tgs) {
            let itms = t.split(".");
            let firstItem = itms.shift();
            if (firstItem === "0") {
                tags.push(t);
            }
            else if (firstItem === "equations") {
                tags.push(t.replace("equations.", "0."));
            }
            else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
                let newTag = this.connections.name[firstItem] + "." + itms.join(".");
                tags.push(newTag);
            }
        }
        let url = "/apiv1/history/";
        url = url + "data?from=" + encodeURIComponent(from.toISOString());
        url = url + "&to=" + encodeURIComponent(to.toISOString());
        for (const t of tags) {
            url = url + "&tags[]=" + encodeURIComponent(t);
        }
        if (groupBy) {
            url = url + "&groupBy=" + encodeURIComponent(groupBy);
        }
        if (groupByValue) {
            url = url + "&groupByValue=" + encodeURIComponent(groupByValue);
        }
        if (customGroupBy) {
            for (const col of customGroupBy) {
                url = url + "&customGroupBy%5B%5D=" + encodeURIComponent(JSON.stringify(col));
            }
        }
        if (limit) {
            url = url + "&limit=" + encodeURIComponent(limit);
        }
        if (formatValuesLanguage) {
            url = url + "&formatValuesLanguage=" + encodeURIComponent(formatValuesLanguage);
        }
        if (tfFormat) {
            url = url + "&tfFormat=" + encodeURIComponent(tfFormat);
        }
        if (densify) {
            url = url + "&densify=" + encodeURIComponent(densify);
        }
        if (fillEndValue != null) {
            url = url + "&fillEndValue=" + encodeURIComponent(fillEndValue);
        }
        if (fillStartValue != null) {
            url = url + "&fillStartValue=" + encodeURIComponent(fillStartValue);
        }
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        let ret = null;
        try {
            ret = yield _get(config);
        }
        catch (e) {
            try {
                yield sleep(300);
                ret = yield _get(config);
            }
            catch (e) {
                return null;
            }
        }
        if (ret != null && ret !== false) {
            let result = {};
            for (let key in ret) {
                try {
                    let itms = key.split(".");
                    let firstItem = itms.shift();
                    if (firstItem === "0") {
                        result[key] = ret[key];
                    }
                    else if (firstItem && this.connections != null && this.connections.id != null && this.connections.id[firstItem] != null) {
                        let newKey = this.connections.id[firstItem] + "." + itms.join(".");
                        result[newKey] = ret[key];
                    }
                }
                catch (e) { }
            }
            if (this.singleTag) {
                for (let key in ret) {
                    let value = ret[key];
                    if (Array.isArray(value) && value.length === 1) {
                        return value[0];
                    }
                    else {
                        return value;
                    }
                }
            }
            else {
                return result;
            }
        }
        let time2 = new Date().getTime();
        // console.log("Historead GET Request time [ms]:" + (time2 - time1));
        return ret;
    });
}
function getHistoricalDataAsTable(tgs, from, to, _groupBy, groupByValue, customGroupBy, limit, densify, fillEndValue, fillStartValue, aggregationFunctions, tagToKeys, formatValuesLanguage, tfFormat) {
    return __awaiter(this, void 0, void 0, function* () {
        if (_groupBy === "---") {
            _groupBy = "raw";
        }
        if (_groupBy) {
            if (!["raw", "hours", "minutes", "days"].includes(_groupBy)) {
                return null;
            }
        }
        if (aggregationFunctions) {
            if (aggregationFunctions.length !== tgs.length) {
                return null;
            }
        }
        if (tagToKeys) {
            if (tagToKeys.length !== tgs.length) {
                return null;
            }
        }
        let aggFcns = {};
        let time1 = new Date().getTime();
        let groupBy = _groupBy === "raw" ? "" : _groupBy;
        let tags = [];
        let index = 0;
        for (let _t of tgs) {
            let t = _t;
            if (_t.startsWith("equations.")) {
                t = _t.replace("equations.", "0.");
            }
            let itms = t.split(".");
            let firstItem = itms.shift();
            if (firstItem === "0") {
                tags.push(t);
                if (tagToKeys) {
                    if (!aggregationFunctions) {
                        aggFcns[tagToKeys[index]] = "value";
                    }
                    else {
                        if (aggregationFunctions[index] === "avg") {
                            aggFcns[tagToKeys[index]] = "value";
                        }
                        else {
                            aggFcns[tagToKeys[index]] = aggregationFunctions[index];
                        }
                    }
                }
                else {
                    if (!aggregationFunctions) {
                        aggFcns[t] = "value";
                    }
                    else {
                        if (aggregationFunctions[index] === "avg") {
                            aggFcns[t] = "value";
                        }
                        else {
                            aggFcns[t] = aggregationFunctions[index];
                        }
                    }
                }
            }
            else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
                let newTag = this.connections.name[firstItem] + "." + itms.join(".");
                tags.push(newTag);
                if (tagToKeys) {
                    if (!aggregationFunctions) {
                        aggFcns[tagToKeys[index]] = "value";
                    }
                    else {
                        if (aggregationFunctions[index] === "avg") {
                            aggFcns[tagToKeys[index]] = "value";
                        }
                        else {
                            aggFcns[tagToKeys[index]] = aggregationFunctions[index];
                        }
                    }
                }
                else {
                    if (!aggregationFunctions) {
                        aggFcns[t] = "value";
                    }
                    else {
                        if (aggregationFunctions[index] === "avg") {
                            aggFcns[newTag] = "value";
                        }
                        else {
                            aggFcns[newTag] = aggregationFunctions[index];
                        }
                    }
                }
            }
            index++;
        }
        let url = "/apiv1/history/";
        url = url + "data?from=" + encodeURIComponent(from.toISOString());
        url = url + "&to=" + encodeURIComponent(to.toISOString());
        for (const t of tags) {
            url = url + "&tags[]=" + encodeURIComponent(t);
        }
        if (groupBy) {
            url = url + "&groupBy=" + encodeURIComponent(groupBy);
        }
        if (groupByValue) {
            url = url + "&groupByValue=" + encodeURIComponent(groupByValue);
        }
        if (customGroupBy) {
            for (const col of customGroupBy) {
                url = url + "&customGroupBy%5B%5D=" + encodeURIComponent(JSON.stringify(col));
            }
        }
        if (limit) {
            url = url + "&limit=" + encodeURIComponent(limit);
        }
        if (formatValuesLanguage) {
            url = url + "&formatValuesLanguage=" + encodeURIComponent(formatValuesLanguage);
        }
        if (tfFormat) {
            url = url + "&tfFormat=" + encodeURIComponent(tfFormat);
        }
        if (densify) {
            url = url + "&densify=" + encodeURIComponent(densify);
        }
        if (fillEndValue != null) {
            url = url + "&fillEndValue=" + encodeURIComponent(fillEndValue);
        }
        if (fillStartValue != null) {
            url = url + "&fillStartValue=" + encodeURIComponent(fillStartValue);
        }
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        let ret = null;
        try {
            ret = yield _get(config);
        }
        catch (e) {
            try {
                yield sleep(300);
                ret = yield _get(config);
            }
            catch (e) {
                return null;
            }
        }
        if (ret != null && ret !== false) {
            let retConverted = {};
            for (let key in ret) {
                try {
                    let itms = key.split(".");
                    let firstItem = itms.shift();
                    if (firstItem === "0") {
                        if (tagToKeys) {
                            for (let i = 0; i < tgs.length; i++) {
                                if (tgs[i] === key || tgs[i] === "equations." + key.substring(2)) {
                                    retConverted[tagToKeys[i]] = ret[key];
                                    break;
                                }
                            }
                        }
                        else {
                            retConverted[key] = ret[key];
                        }
                    }
                    else if (firstItem && this.connections != null && this.connections.id != null && this.connections.id[firstItem] != null) {
                        let newKey = this.connections.id[firstItem] + "." + itms.join(".");
                        if (tagToKeys) {
                            for (let i = 0; i < tgs.length; i++) {
                                if (tgs[i] === newKey) {
                                    retConverted[tagToKeys[i]] = ret[key];
                                    break;
                                }
                            }
                        }
                        else {
                            retConverted[newKey] = ret[key];
                        }
                    }
                }
                catch (e) { }
            }
            //now we convert to table based on time;
            // Step 1: Create a Set of all unique timestamps
            const allTimestamps = new Set();
            for (const key in retConverted) {
                for (const entry of retConverted[key]) {
                    allTimestamps.add(entry.tf);
                }
            }
            // Step 2: Build a map for fast access by tf
            const valueMaps = {};
            for (const key in retConverted) {
                valueMaps[key] = {};
                for (const entry of retConverted[key]) {
                    valueMaps[key][entry.tf] = entry[aggFcns[key]];
                }
            }
            // Step 3: Merge into unified array
            const result = Array.from(allTimestamps)
                .sort() // optional: sort by time
                .map((tf) => {
                var _a;
                const merged = { tf };
                for (const key in valueMaps) {
                    merged[key] = (_a = valueMaps[key][tf]) !== null && _a !== void 0 ? _a : null; // null for missing values
                }
                return merged;
            });
            return result;
        }
        let time2 = new Date().getTime();
        // console.log("Historead GET Request time [ms]:" + (time2 - time1));
        return ret;
    });
}
function sendWriteRequest(tgs) {
    return __awaiter(this, void 0, void 0, function* () {
        let tags = {};
        let hasAny = false;
        for (let key in tgs) {
            let itms = key.split(".");
            let firstItem = itms.shift();
            if (firstItem && this.connections && this.connections.name && this.connections.name[firstItem]) {
                let newTag = this.connections.name[firstItem] + "." + itms.join(".");
                let v = tgs[key];
                if (Array.isArray(v)) {
                    for (let i = 0; i < v.length; i++) {
                        if (v[i] === true) {
                            v[i] = 1;
                        }
                        else if (v[i] === false) {
                            v[i] = 0;
                        }
                    }
                    tags[newTag] = v;
                }
                else {
                    if (v === true) {
                        v = 1;
                    }
                    else if (v === false) {
                        v = 0;
                    }
                    tags[newTag] = [v];
                }
                hasAny = true;
            }
        }
        if (hasAny) {
            let write = {
                writeData: tags,
                confirm: 0,
            };
            try {
                yield _post(this.tenantID, "/apiv1/live/data", 4101, JSON.stringify(write));
                return true;
            }
            catch (e) {
                return false;
            }
        }
        return true;
    });
}
function dataFetch(tenantid, project, dataobj) {
    return __awaiter(this, void 0, void 0, function* () {
        let command = dataobj.command;
        let urlarray = command.split("/");
        dataobj.command = urlarray[1];
        if (project) {
            dataobj.project = project;
        }
        let ret = yield _post(tenantid, "/" + urlarray[0], 4001, JSON.stringify(dataobj));
        //pokud se nepodari vycist zkusime znovu
        if (ret === undefined) {
            yield sleep(200);
            ret = yield _post(tenantid, "/" + urlarray[0], 4001, JSON.stringify(dataobj));
        }
        if (ret === undefined) {
            return [true, {}];
        }
        else {
            return [false, ret];
        }
    });
}
function getTagNames(connection, f, limit) {
    return __awaiter(this, void 0, void 0, function* () {
        if ((this.connections == undefined || this.connections.name) == undefined || this.connections.name[connection] == undefined) {
            return { err: true, message: "Connection does not exist." };
        }
        let connId = this.connections.name[connection];
        let filter = connId + ".";
        let [err, ret] = yield dataFetch(this.tenantID, this.project, {
            command: "db/tagsStartsWith",
            filter: filter,
            data: { limit: limit, customFilter: f },
        });
        if (ret) {
            //we need to convert 1.tag to conn.tag
            let retConverted = [];
            for (let t of ret) {
                let itms = t.split(".");
                let firstItem = itms.shift();
                if (firstItem && this.connections && this.connections.id && this.connections.id[firstItem]) {
                    let newTag = this.connections.id[firstItem] + "." + itms.join(".");
                    retConverted.push(newTag);
                }
                else if (firstItem == "0") {
                    retConverted.push(t);
                }
            }
            return retConverted;
        }
        else {
            return [];
        }
    });
}
function removeTags(tgs) {
    return __awaiter(this, void 0, void 0, function* () {
        let tags = [];
        for (let tag of tgs) {
            let itms = tag.split(".");
            let firstItem = itms.shift();
            if (firstItem && this.connections !== undefined && this.connections.name !== undefined && this.connections.name[firstItem] !== undefined) {
                let newTag = this.connections.name[firstItem] + "." + itms.join(".");
                tags.push(newTag);
            }
        }
        if (tags.length > 0) {
            yield dataFetch(this.tenantID, this.project, {
                command: "db/removeTags",
                data: { keys: tags },
            });
        }
        else {
            return false;
        }
    });
}
function removeTagsStartingWith(connection, f) {
    return __awaiter(this, void 0, void 0, function* () {
        if ((this.connections == undefined || this.connections.name == undefined || this.connections.name[connection]) == undefined) {
            return { err: true, message: "Connection does not exist." };
        }
        let connId = this.connections.name[connection];
        let filter = connId + "." + f;
        let [err, ret] = yield dataFetch(this.tenantID, this.project, {
            command: "db/removeKeysWithPattern",
            key: filter,
        });
        return ret;
    });
}
function addTag(tagname, data) {
    return __awaiter(this, void 0, void 0, function* () {
        let itms = tagname.split(".");
        let firstItem = itms.shift();
        if (firstItem && this.connections !== undefined && this.connections.name !== undefined && this.connections.name[firstItem] !== undefined) {
            let newTag = this.connections.name[firstItem] + "." + itms.join(".");
            let [err, ret] = yield dataFetch(this.tenantID, this.project, {
                command: "db/addTag",
                data: data,
                key: newTag,
            });
            return ret;
        }
        return false;
    });
}
function _notify(_prefix, notificationGroup, definitions, alarms, title, body, file) {
    let groupDef = definitions.groups[notificationGroup];
    if (!groupDef) {
        for (let g of definitions.groups) {
            if (g.id === notificationGroup) {
                groupDef = g;
            }
        }
    }
    if (groupDef) {
        if (!groupDef.message) {
            groupDef.message = {
                deflang: "en",
                body: {},
                subject: {},
            };
        }
        if (!groupDef.message.deflang) {
            groupDef.message.deflang = "en";
        }
        if (!groupDef.message.body) {
            groupDef.message.body = {};
        }
        if (!groupDef.message.subject) {
            groupDef.message.subject = {};
        }
        let getMessage = (lang) => {
            let message = groupDef.message.body[lang];
            if (!message) {
                message = groupDef.message.body[groupDef.message.deflang];
            }
            if (typeof body === "string") {
                message = body;
            }
            else if (body && body[lang]) {
                message = body[lang];
            }
            if (alarms != null && !message) {
                message = "{alarms}";
            }
            if (alarms != null && message.includes("{alarms}")) {
                let newAlarms = JSON.parse(JSON.stringify(alarms));
                correctAlarms([newAlarms], lang);
                let alarmMsg = newAlarms.message;
                message = message.replaceAll("{alarms}", alarmMsg);
            }
            if (!message) {
                message = "";
            }
            return message;
        };
        let getSubject = (lang) => {
            let message = groupDef.message.subject[lang];
            if (!message) {
                message = groupDef.message.subject[groupDef.message.deflang];
            }
            if (typeof title === "string") {
                message = title;
            }
            else if (title && title[lang]) {
                message = title[lang];
            }
            if (alarms != null && !message) {
                message = "Alarm Activations";
            }
            if (!message) {
                message = "";
            }
            return message;
        };
        let getFile = (lang) => {
            if (!file) {
                return undefined;
            }
            if (typeof file === "string") {
                return file;
            }
            let f = file[lang];
            if (f) {
                return f;
            }
            let f2 = file[groupDef.message.deflang];
            if (f2) {
                return f2;
            }
            let keys = Object.keys(file);
            if (keys.length > 0) {
                return file[keys[0]];
            }
            return undefined;
        };
        let users = definitions.users;
        for (let data of groupDef.data) {
            let url = data.url;
            let groups = data.groups;
            let _users = data.users;
            let done = false;
            if ((url.includes("{email}") || url.includes("{phone}")) && groups && groups.length > 0) {
                // /users.current;
                for (let u of users) {
                    let hasSame = u.group.some((item) => groups.includes(item));
                    if (hasSame) {
                        let lang = groupDef.message.deflang;
                        if (u.lang) {
                            lang = u.lang;
                        }
                        let body = getMessage(lang);
                        let subject = getSubject(lang);
                        let _file = getFile(lang);
                        if (url.includes("{email}") && u.email) {
                            done = true;
                            let newurl = url.replaceAll("{email}", u.email);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                        else if (url.includes("{phone}") && u.tel) {
                            done = true;
                            let newurl = url.replaceAll("{phone}", u.tel);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                    }
                }
            }
            if ((url.includes("{email}") || url.includes("{phone}")) && _users && _users.length > 0) {
                // /users.current;
                for (let u of users) {
                    let hasSame = _users.includes(u.id);
                    if (hasSame) {
                        let lang = groupDef.message.deflang;
                        if (u.lang) {
                            lang = u.lang;
                        }
                        let body = getMessage(lang);
                        let subject = getSubject(lang);
                        let _file = getFile(lang);
                        if (url.includes("{email}") && u.email) {
                            done = true;
                            let newurl = url.replaceAll("{email}", u.email);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                        else if (url.includes("{phone}") && u.tel) {
                            done = true;
                            let newurl = url.replaceAll("{phone}", u.tel);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                    }
                }
            }
            if (!done) {
                let body2 = getMessage(groupDef.message.deflang);
                let subject = getSubject(groupDef.message.deflang);
                let o = { url: url, title: subject, body: body2 };
                let _file = getFile(groupDef.message.deflang);
                if (_file) {
                    o.attach = _file;
                }
                notifyObj(_prefix, o);
            }
        }
    }
}
function stripMarkdown(markdown) {
    return (markdown
        // Remove headers (e.g., # Heading)
        .replace(/^#{1,6}\s+/gm, "")
        // Remove bold (**text** or __text__)
        .replace(/(\*\*|__)(.*?)\1/g, "$2")
        // Remove italic (*text* or _text_)
        .replace(/(\*|_)(.*?)\1/g, "$2")
        // Remove inline code (`code`)
        .replace(/`([^`]+)`/g, "$1")
        // Remove links but keep text [text](url)
        .replace(/\[([^\]]+)\]\([^)]+\)/g, "$1")
        // Remove images ![alt](url)
        .replace(/!\[.*?\]\(.*?\)/g, "")
        // Remove blockquotes
        .replace(/^\s*>+\s?/gm, "")
        // Remove horizontal rules
        .replace(/^[-*_]{3,}$/gm, "")
        // Remove lists (*, -, +)
        .replace(/^\s*([-*+]|\d+\.)\s+/gm, "")
        // Remove remaining formatting characters
        .replace(/\\([*_`~])/g, "$1")
        // Remove extra spaces
        .replace(/\s{2,}/g, " ")
        .trim());
}
function markdownToWordXml(markdownText) {
    var _a;
    const md = new markdown_it_1.default();
    const tokens = (_a = md.parseInline(markdownText, {})[0].children) !== null && _a !== void 0 ? _a : [];
    const result = [];
    const currentStyle = {};
    for (const token of tokens) {
        switch (token.type) {
            case "text":
                result.push(makeRun(token.content, currentStyle));
                break;
            case "strong_open":
                currentStyle.bold = true;
                break;
            case "strong_close":
                currentStyle.bold = false;
                break;
            case "em_open":
                currentStyle.italic = true;
                break;
            case "em_close":
                currentStyle.italic = false;
                break;
            case "softbreak":
            case "hardbreak":
                result.push("||<w:br/>||");
                break;
        }
    }
    return result.join("");
}
function makeRun(text, style) {
    const props = [];
    if (style.bold)
        props.push("<w:b/>");
    if (style.italic)
        props.push("<w:i/>");
    return '||<w:r xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main">' + `<w:rPr>${props.join("")}</w:rPr>` + `<w:t>${escapeXml(text)}</w:t>` + "</w:r>||";
}
function escapeXml(str) {
    return str.replace(/[<>&'"]/g, (c) => {
        var _a;
        return ((_a = {
            "<": "&lt;",
            ">": "&gt;",
            "&": "&amp;",
            "'": "&apos;",
            '"': "&quot;",
        }[c]) !== null && _a !== void 0 ? _a : c);
    });
}
function searchUsingAI(_prefix, question, _lang, history, chatID) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let lang = _lang;
            if (this.language) {
                lang = this.language;
            }
            let object = {
                lang: lang,
                message: question,
                chatid: chatID,
                history: history,
            };
            let prefix = _prefix;
            if (this.tenantID) {
                prefix = this.tenantID;
            }
            //let url = "/apiAI/chat/";
            //let url = "apiv1/ai/chat/";
            let port = 4501;
            //let port = 4101;
            let url = "/search";
            let reply = yield _post(prefix, url, port, JSON.stringify(object));
            return reply;
        }
        catch (e) {
            return "?";
        }
    });
}
function chatWithAI(_prefix, question, _lang, history, chatID, output) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let lang = _lang;
            if (this.language) {
                lang = this.language;
            }
            let object = {
                lang: lang,
                message: question,
                chatid: chatID,
            };
            let prefix = _prefix;
            if (this.tenantID) {
                prefix = this.tenantID;
            }
            //let url = "apiv1/ai/chat/";
            //let port = 4101;
            let port = 4501;
            let url = "/chat";
            let reply = yield _post(prefix, url, port, JSON.stringify(object));
            if (reply && reply.message) {
                if (output === "text") {
                    reply.message = stripMarkdown(reply.message);
                }
                if (output === "docx") {
                    reply.message = markdownToWordXml(reply.message);
                }
                return reply.message;
            }
            else {
                return "";
            }
        }
        catch (e) {
            console.log(e);
            console.error(e);
            return "?";
        }
    });
}
function searchAI(prefix, question) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let object = {
                message: question,
            };
            let reply = yield _post(prefix, "/notify", 4601, JSON.stringify(object));
            return reply;
        }
        catch (e) {
            return { err: true, message: e };
        }
    });
}
function notifyObj(prefix, object) {
    setTimeout(() => __awaiter(this, void 0, void 0, function* () {
        if (object.url.startsWith("modemsms://")) {
            try {
                let parts = object.url.split("//");
                let o = {
                    phone: parts[1],
                    sms: object.body,
                };
                yield _post(prefix, "/notify", 4801, JSON.stringify(o), "host.docker.internal");
                return true;
            }
            catch (e) {
                return false;
            }
        }
        else {
            try {
                yield _post(prefix, "/notify", 4601, JSON.stringify(object));
                return true;
            }
            catch (e) {
                return false;
            }
        }
    }), 1);
}
function notifyReport(_prefix, notificationGroup, definitions, title, body, file) {
    _notify(_prefix, notificationGroup, definitions, null, title, body, file);
}
function notifyAlarms(_prefix, notificationGroup, definitions, alarms, title, body, file) {
    _notify(_prefix, notificationGroup, definitions, alarms, title, body);
}
function notify(_prefix, group, title, body, file) {
    return __awaiter(this, void 0, void 0, function* () {
        _notify(this.tenantID, group, this.notificationGroupDefinitions, null, title, body, file);
        /*
        let prefix = this.tenantID;
        if (_prefix) {
          prefix = _prefix;
        }
        let write: any = {
          body: body,
          title: title,
          prefix: prefix + "",
          id: group,
        };
      
        if (file) {
          write.attach = file;
        }
      
        try {
          await _post(prefix, "/notify", 4601, JSON.stringify(write));
          return true;
        } catch (e) {
          return false;
        }
          */
        return true;
    });
}
function liveDataGet(tgs) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!Array.isArray(tgs)) {
            tgs = [tgs];
        }
        let _tags = [];
        if (this.connections) {
            for (let t of tgs) {
                let itms = t.split(".");
                let firstItem = itms.shift();
                if (firstItem === "0") {
                    _tags.push(t);
                }
                else if (firstItem === "equations") {
                    let newTag = "0." + itms.join(".");
                    _tags.push(newTag);
                }
                else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
                    let newTag = this.connections.name[firstItem] + "." + itms.join(".");
                    _tags.push(newTag);
                }
            }
        }
        else {
            _tags = tgs;
        }
        let tags = stripArrayTags(_tags);
        let url = "/apiv1/";
        url = url + "live/data/?";
        let tagstext = "";
        for (const col of tags) {
            if (tagstext) {
                tagstext = tagstext + "&";
            }
            tagstext = tagstext + "tags[]=" + encodeURIComponent(col);
        }
        url = url + tagstext + "&_=" + new Date().getTime();
        let ret = null;
        try {
            let config = {
                method: "GET",
                hostname: "127.0.0.1",
                path: url,
                port: 4101,
                //mode: "cors",
                headers: {
                    //  "Access-Control-Allow-Origin": "*",
                    "x-tenantid": this.tenantID,
                    apikey: "internalapi",
                },
            };
            try {
                ret = yield _get(config);
            }
            catch (e) {
                try {
                    yield sleep(300);
                    ret = yield _get(config);
                }
                catch (e) {
                    return null;
                }
            }
            if (ret && ret.data && Object.keys(ret.data).length !== tgs.length) {
                yield sleep(100);
                ret = yield _get(config);
            }
            if (ret && ret.data && Object.keys(ret.data).length !== tgs.length) {
                yield sleep(300);
                ret = yield _get(config);
            }
        }
        catch (e) { }
        // console.log("Live data GET Request time [ms]:" + (time2 - time1));
        if (ret && ret.data) {
            let ts = tagsToArrayTags(_tags, ret.data);
            if (this.connections) {
                //we need to convert 1.tag to conn.tag
                let retConverted = {};
                for (let t in ts) {
                    let itms = t.split(".");
                    let firstItem = itms.shift();
                    if (firstItem && this.connections && this.connections.id && this.connections.id[firstItem]) {
                        let newTag = this.connections.id[firstItem] + "." + itms.join(".");
                        retConverted[newTag] = ts[t];
                    }
                    else if (firstItem == "0") {
                        let newTag = "equations" + "." + itms.join(".");
                        retConverted[newTag] = ts[t];
                    }
                }
                if (this.singleTag) {
                    for (let key in retConverted) {
                        let value = retConverted[key];
                        if (Array.isArray(value) && value.length === 1) {
                            return value[0];
                        }
                        else {
                            return value;
                        }
                    }
                }
                else {
                    return retConverted;
                }
            }
            else {
                if (this.singleTag) {
                    for (let key in ts) {
                        let value = ts[key];
                        if (Array.isArray(value) && value.length === 1) {
                            return value[0];
                        }
                        else {
                            return value;
                        }
                    }
                }
                else {
                    return ts;
                }
            }
        }
        if (this.singleTag && ret.data) {
            for (let key in ret.data) {
                try {
                    let value = ret.data[key].value;
                    if (Array.isArray(value) && value.length === 1) {
                        return value[0];
                    }
                    else {
                        return value;
                    }
                }
                catch (e) {
                    return null;
                }
            }
        }
        else {
            return ret;
        }
        return ret;
    });
}
function sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}
function codeTableGet(name, view, filter, type, returnType, lang, limit, orderBy, columns) {
    return __awaiter(this, void 0, void 0, function* () {
        let time1 = new Date().getTime();
        let url = "/apiv1/";
        url = url + "codetable?name=" + encodeURIComponent(name);
        if (view) {
            if (view === "__default_view__") {
                url = url + "&view=" + encodeURIComponent("fulldata");
            }
            else {
                url = url + "&view=" + encodeURIComponent(view);
            }
        }
        if (type) {
            url = url + "&type=" + encodeURIComponent(type);
        }
        if (filter) {
            let filt = "";
            let index = 0;
            for (const f of filter) {
                index++;
                if (filt.length === 0) {
                    filt = JSON.stringify(f);
                }
                else {
                    if (index === 1) {
                        filt = "filter[]=" + JSON.stringify(f);
                    }
                    else {
                        filt = JSON.stringify(f);
                    }
                }
                url = url + "&filter%5B%5D=" + encodeURIComponent(filt);
            }
        }
        if (columns) {
            for (const col of columns) {
                url = url + "&columns%5B%5D=" + encodeURIComponent(col);
            }
        }
        if (limit) {
            url = url + "&limit=" + encodeURIComponent(limit);
        }
        if (orderBy) {
            url = url + "&orderBy=" + encodeURIComponent(orderBy);
        }
        if (returnType) {
            url = url + "&returnType=" + encodeURIComponent(returnType);
        }
        if (lang) {
            url = url + "&lang=" + encodeURIComponent(lang);
        }
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        let ret = null;
        try {
            ret = yield _get(config);
        }
        catch (e) {
            try {
                yield sleep(300);
                ret = yield _get(config);
            }
            catch (e) {
                return { err: true, message: "Timeout" };
            }
        }
        if (ret && ret.data) {
            return ret.data;
        }
        else {
            return { err: true, message: "No Data" };
        }
    });
}
function getLocalizedText(lang, data, deftxt) {
    if (data == null) {
        if (deftxt) {
            return deftxt;
        }
        return "";
    }
    if (typeof data === "string") {
        return data;
    }
    let label = data[lang];
    if (!label) {
        label = data["en"];
    }
    if (!label) {
        let klice = Object.keys(data);
        if (klice && klice.length > 0) {
            label = data[klice[0]];
        }
    }
    if (!label) {
        if (deftxt) {
            return deftxt;
        }
        label = "";
    }
    return label;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFpbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7O0FBS0Esd0NBZ0JDO0FBRUQsc0NBU0M7QUFFRCxrQ0F1Q0M7QUFFRCwwQ0FVQztBQUVELHNCQStDQztBQUVELG9CQThCQztBQWdCRCxnQ0EyQkM7QUFFRCxvQ0FxREM7QUFFRCxrRUF1QkM7QUFFRCxvRUFXQztBQTRNRCx3Q0FzR0M7QUFHRCx3Q0FtS0M7QUFFRCw0Q0FxREM7QUFFRCw4Q0ErSUM7QUFFRCw0REFtUEM7QUFFRCw0Q0EyQ0M7QUF5QkQsa0NBNkJDO0FBRUQsZ0NBa0JDO0FBRUQsd0RBV0M7QUFFRCx3QkFhQztBQXNNRCxzQ0EyQkM7QUFFRCw4Q0FvQ0M7QUF3QkQsc0NBOEJDO0FBRUQsZ0NBd0NDO0FBRUQsNEJBVUM7QUFFRCw4QkF1QkM7QUFFRCxvQ0FFQztBQUVELG9DQUVDO0FBRUQsd0JBMEJDO0FBRUQsa0NBMElDO0FBRUQsc0JBR0M7QUFFRCxvQ0FtR0M7QUFFRCw0Q0E4QkM7QUE1aEVELGdEQUF3QjtBQUN4Qiw0Q0FBNEM7QUFDNUMsOERBQXFDO0FBQ3JDLCtCQUErQjtBQUUvQixTQUFnQixjQUFjLENBQUMsSUFBYztJQUMzQyxJQUFJLEtBQUssR0FBYSxFQUFFLENBQUM7SUFDekIsS0FBSyxJQUFJLEVBQUUsSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUNwQixJQUFJLENBQUMsR0FBRyxFQUFFLENBQUM7UUFDWCxJQUFJLENBQUMsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNwQixDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN0QixDQUFDO1FBQ0QsSUFBSSxDQUFDLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO1lBQ3pDLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3RCLENBQUM7UUFFRCxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQ3ZCLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDaEIsQ0FBQztJQUNILENBQUM7SUFDRCxPQUFPLEtBQUssQ0FBQztBQUNmLENBQUM7QUFFRCxTQUFnQixhQUFhLENBQUMsR0FBVztJQUN2QyxJQUFJLENBQUMsR0FBRyxHQUFHLENBQUM7SUFDWixJQUFJLENBQUMsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztRQUNwQixDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBQ0QsSUFBSSxDQUFDLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO1FBQ3pDLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFDRCxPQUFPLENBQUMsQ0FBQztBQUNYLENBQUM7QUFFRCxTQUFnQixXQUFXLENBQUMsS0FBYSxFQUFFLEtBQVU7SUFDbkQsSUFBSSxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDZixJQUFJLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUViLElBQUksR0FBRyxHQUFHLEtBQUssQ0FBQztJQUNoQixJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztRQUN4QixJQUFJLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzNCLEdBQUcsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDekIsR0FBRyxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNqQixDQUFDO0lBRUQscUJBQXFCO0lBQ3JCLElBQUksR0FBRyxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQztRQUM3Qyw2QkFBNkI7UUFDN0IsSUFBSSxLQUFLLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUNwQyxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ1YsS0FBSyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUM3QixDQUFDO1FBRUQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDMUIsQ0FBQztJQUVELElBQUksS0FBSyxJQUFJLENBQUMsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLENBQUMsRUFBRSxDQUFDO1FBQzdCLE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELElBQUksS0FBSyxJQUFJLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDaEIsS0FBSyxHQUFHLENBQUMsQ0FBQztJQUNaLENBQUM7SUFFRCxJQUFJLEtBQUssQ0FBQyxNQUFNLEdBQUcsS0FBSyxHQUFHLENBQUMsRUFBRSxDQUFDO1FBQzdCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVELElBQUksQ0FBQyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNyQixJQUFJLEdBQUcsSUFBSSxDQUFDLEVBQUUsQ0FBQztRQUNiLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUNELE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUNiLENBQUM7QUFFRCxTQUFnQixlQUFlLENBQUMsU0FBbUIsRUFBRSxJQUFTO0lBQzVELElBQUksR0FBRyxHQUFRLEVBQUUsQ0FBQztJQUNsQixLQUFLLElBQUksQ0FBQyxJQUFJLFNBQVMsRUFBRSxDQUFDO1FBQ3hCLElBQUksR0FBRyxHQUFHLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUMzQixJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDbEIsSUFBSSxDQUFDLEVBQUUsQ0FBQztZQUNOLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxXQUFXLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNuQyxDQUFDO0lBQ0gsQ0FBQztJQUNELE9BQU8sR0FBRyxDQUFDO0FBQ2IsQ0FBQztBQUVELFNBQXNCLEtBQUssQ0FBQyxRQUFnQixFQUFFLEdBQVcsRUFBRSxJQUFZLEVBQUUsUUFBYSxFQUFFLFFBQWlCOztRQUN2RyxPQUFPLElBQUksT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLE1BQU0sRUFBRSxFQUFFO1lBQ3JDLElBQUksSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUNkLCtCQUErQjtZQUMvQixJQUFJLEVBQUUsR0FBRyxXQUFXLENBQUM7WUFDckIsSUFBSSxRQUFRLEVBQUUsQ0FBQztnQkFDYixFQUFFLEdBQUcsUUFBUSxDQUFDO1lBQ2hCLENBQUM7WUFDRCxNQUFNLE9BQU8sR0FBRztnQkFDZCxRQUFRLEVBQUUsRUFBRTtnQkFDWixJQUFJLEVBQUUsSUFBSTtnQkFDVixJQUFJLEVBQUUsR0FBRztnQkFDVCxNQUFNLEVBQUUsTUFBTTtnQkFDZCxPQUFPLEVBQUU7b0JBQ1AsY0FBYyxFQUFFLGtCQUFrQjtvQkFDbEMsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7b0JBQzdDLFlBQVksRUFBRSxRQUFRO29CQUN0QixNQUFNLEVBQUUsYUFBYTtpQkFDdEI7YUFDRixDQUFDO1lBRUYsd0JBQXdCO1lBQ3hCLE1BQU0sR0FBRyxHQUFHLGNBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUMsR0FBUSxFQUFFLEVBQUU7Z0JBQzdDLHlCQUF5QjtnQkFDekIsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxLQUFVLEVBQUUsRUFBRTtvQkFDNUIsSUFBSSxJQUFJLEtBQUssQ0FBQztnQkFDaEIsQ0FBQyxDQUFDLENBQUM7Z0JBRUgsR0FBRyxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsR0FBRyxFQUFFO29CQUNqQixJQUFJLENBQUM7d0JBQ0gsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDekIsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNiLENBQUM7b0JBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQzt3QkFDWCxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ1osQ0FBQztnQkFDSCxDQUFDLENBQUMsQ0FBQztZQUNMLENBQUMsQ0FBQyxDQUFDO1lBRUgsa0JBQWtCO1lBQ2xCLEdBQUcsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUMsS0FBVSxFQUFFLEVBQUU7Z0JBQzdCLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNoQixDQUFDLENBQUMsQ0FBQztZQUVILGdCQUFnQjtZQUNoQixHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3BCLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUNaLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUFBO0FBRUQsU0FBc0IsSUFBSSxDQUFDLEdBQVc7O1FBQ3BDLE9BQU8sSUFBSSxPQUFPLENBQUMsQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7WUFDckMsSUFBSSxJQUFJLEdBQUcsRUFBRSxDQUFDO1lBRWQsTUFBTSxHQUFHLEdBQUcsY0FBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxHQUFRLEVBQUUsRUFBRTtnQkFDckMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxLQUFVLEVBQUUsRUFBRTtvQkFDNUIsSUFBSSxJQUFJLEtBQUssQ0FBQztnQkFDaEIsQ0FBQyxDQUFDLENBQUM7Z0JBRUgsR0FBRyxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsR0FBRyxFQUFFO29CQUNqQixJQUFJLENBQUM7d0JBQ0gsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDekIsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNiLENBQUM7b0JBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQzt3QkFDWCxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ1osQ0FBQztnQkFDSCxDQUFDLENBQUMsQ0FBQztZQUNMLENBQUMsQ0FBQyxDQUFDO1lBRUgsK0JBQStCO1lBQy9CLEdBQUcsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUMsR0FBVSxFQUFFLEVBQUU7Z0JBQzdCLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyx1QkFBdUIsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztZQUMzRCxDQUFDLENBQUMsQ0FBQztZQUVILGtCQUFrQjtZQUNsQixHQUFHLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxHQUFHLEVBQUU7Z0JBQ3JCLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDWixNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO1lBQzlDLENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQUE7QUFnQkQsU0FBZ0IsVUFBVSxDQUFDLElBQTRCLEVBQUUsTUFBYyxFQUFFLE1BQU0sR0FBRyxPQUFPO0lBQ3ZGLElBQUksQ0FBQztRQUNILElBQUksR0FBRyxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN0QixNQUFNLFNBQVMsR0FBRyxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRWxGLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxXQUFXLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDckMsTUFBTSxFQUFFLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3hELE1BQU0sRUFBRSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ25ELE1BQU0sRUFBRSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3BELE1BQU0sRUFBRSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDL0QsTUFBTSxFQUFFLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdEQsTUFBTSxFQUFFLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdEQsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFFN0MsT0FBTyxNQUFNO2FBQ1YsT0FBTyxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUM7YUFDdEIsT0FBTyxDQUFDLE9BQU8sRUFBRSxTQUFTLENBQUM7YUFDM0IsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7YUFDbEIsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7YUFDbEIsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7YUFDbEIsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7YUFDbEIsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7YUFDbEIsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7YUFDbEIsT0FBTyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLHFEQUFxRDtJQUNoRixDQUFDO0lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztRQUNYLE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztBQUNILENBQUM7QUFFRCxTQUFnQixZQUFZLENBQUMsS0FBYSxFQUFFLE1BQWM7SUFDeEQsSUFBSSxLQUFLLElBQUksSUFBSSxFQUFFLENBQUM7UUFDbEIsT0FBTyxFQUFFLENBQUM7SUFDWixDQUFDO0lBQ0Qsa0RBQWtEO0lBQ2xELE1BQU0sQ0FBQyxTQUFTLEVBQUUsYUFBYSxDQUFDLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUVyRCxpREFBaUQ7SUFDakQsSUFBSSxDQUFDLFFBQVEsRUFBRSxZQUFZLENBQUMsR0FBRyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQzNELFFBQVEsR0FBRyxRQUFRLElBQUksR0FBRyxDQUFDLENBQUMsb0NBQW9DO0lBQ2hFLFlBQVksR0FBRyxZQUFZLElBQUksRUFBRSxDQUFDLENBQUMsc0NBQXNDO0lBRXpFLDBCQUEwQjtJQUMxQixJQUFJLFlBQVksR0FBRyxFQUFFLENBQUM7SUFDdEIsSUFBSSxjQUFjLEdBQUcsU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7SUFDMUMsSUFBSSxhQUFhLEdBQUcsUUFBUSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7SUFFeEMsNkRBQTZEO0lBQzdELE9BQU8sY0FBYyxJQUFJLENBQUMsSUFBSSxhQUFhLElBQUksQ0FBQyxFQUFFLENBQUM7UUFDakQsSUFBSSxpQkFBaUIsR0FBRyxTQUFTLENBQUMsY0FBYyxDQUFDLElBQUksR0FBRyxDQUFDLENBQUMsNkNBQTZDO1FBRXZHLElBQUksaUJBQWlCLEtBQUssR0FBRyxJQUFJLGlCQUFpQixLQUFLLEdBQUcsRUFBRSxDQUFDO1lBQzNELHVEQUF1RDtZQUN2RCxZQUFZLEdBQUcsQ0FBQyxhQUFhLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLGlCQUFpQixLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsR0FBRyxZQUFZLENBQUM7WUFDcEgsYUFBYSxFQUFFLENBQUM7UUFDbEIsQ0FBQzthQUFNLENBQUM7WUFDTiwrREFBK0Q7WUFDL0QsWUFBWSxHQUFHLGlCQUFpQixHQUFHLFlBQVksQ0FBQztRQUNsRCxDQUFDO1FBQ0QsY0FBYyxFQUFFLENBQUM7SUFDbkIsQ0FBQztJQUVELHFEQUFxRDtJQUNyRCxJQUFJLGdCQUFnQixHQUFHLEVBQUUsQ0FBQztJQUMxQixJQUFJLGFBQWEsRUFBRSxDQUFDO1FBQ2xCLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxhQUFhLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7WUFDOUMsSUFBSSxhQUFhLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxJQUFJLGFBQWEsQ0FBQyxDQUFDLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQztnQkFDekQsaUVBQWlFO2dCQUNqRSxnQkFBZ0IsSUFBSSxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQy9FLENBQUM7aUJBQU0sQ0FBQztnQkFDTixnQkFBZ0IsSUFBSSxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDdkMsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0lBRUQsd0NBQXdDO0lBQ3hDLElBQUksTUFBTSxHQUFHLFlBQVksQ0FBQztJQUMxQixJQUFJLGdCQUFnQixFQUFFLENBQUM7UUFDckIsTUFBTSxJQUFJLEdBQUcsR0FBRyxnQkFBZ0IsQ0FBQztJQUNuQyxDQUFDO0lBRUQsK0VBQStFO0lBQy9FLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDM0MsQ0FBQztBQUVELFNBQWdCLDJCQUEyQixDQUFDLENBQU0sRUFBRSxRQUFnQixFQUFFLFVBQWtCO0lBQ3RGLElBQUksQ0FBQyxJQUFJLElBQUksRUFBRSxDQUFDO1FBQ2QsT0FBTyxVQUFVLENBQUM7SUFDcEIsQ0FBQztJQUVELElBQUksT0FBTyxDQUFDLEtBQUssUUFBUSxFQUFFLENBQUM7UUFDMUIsT0FBTyxDQUFDLENBQUM7SUFDWCxDQUFDO0lBRUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQ3BCLElBQUksQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNQLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDZCxDQUFDO0lBQ0QsSUFBSSxDQUFDLENBQUMsRUFBRSxDQUFDO1FBQ1AsSUFBSSxJQUFJLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUMxQixJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDcEIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNqQixDQUFDO2FBQU0sQ0FBQztZQUNOLENBQUMsR0FBRyxVQUFVLENBQUM7UUFDakIsQ0FBQztJQUNILENBQUM7SUFFRCxPQUFPLENBQUMsQ0FBQztBQUNYLENBQUM7QUFFRCxTQUFnQiw0QkFBNEIsQ0FBQyxHQUFRLEVBQUUsUUFBZ0IsRUFBRSxPQUFlO0lBQ3RGLElBQUksSUFBSSxHQUFHO1FBQ1QsU0FBUyxFQUFFLEdBQUcsQ0FBQyxNQUFNO1FBQ3JCLE9BQU8sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNqQixRQUFRLEVBQUUsR0FBRyxDQUFDLEtBQUs7UUFDbkIsT0FBTyxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2pCLE9BQU8sRUFBRSxPQUFPO1FBQ2hCLEVBQUUsRUFBRSxHQUFHLENBQUMsR0FBRztLQUNaLENBQUM7SUFDRixhQUFhLENBQUMsQ0FBQyxJQUFJLENBQUMsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUNoQyxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7QUFDdEIsQ0FBQztBQUVELFNBQVMsYUFBYSxDQUFDLEtBQVksRUFBRSxTQUE0QixFQUFFLFVBQW9CLEVBQUUsRUFBVztJQUNsRyxLQUFLLElBQUksQ0FBQyxJQUFJLEtBQUssRUFBRSxDQUFDO1FBQ3BCLElBQUksS0FBSyxHQUFHLEVBQUUsQ0FBQztRQUNmLElBQUksT0FBTyxTQUFTLEtBQUssUUFBUSxFQUFFLENBQUM7WUFDbEMsS0FBSyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDdEIsQ0FBQzthQUFNLENBQUM7WUFDTixLQUFLLEdBQUcsU0FBUyxDQUFDO1FBQ3BCLENBQUM7UUFFRCxJQUFJLFFBQVEsR0FBUSxFQUFFLENBQUM7UUFFdkIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztZQUN0QyxJQUFJLFFBQVEsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFFeEIsa0RBQWtEO1lBRWxELElBQUksRUFBRSxFQUFFLENBQUM7Z0JBQ1AsSUFBSSxNQUFNLEdBQUcsVUFBVSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLFFBQVEsQ0FBQyxDQUFDO2dCQUM1QyxDQUFDLENBQUMsRUFBRSxHQUFHLE1BQU0sQ0FBQztnQkFDZCxJQUFJLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztvQkFDZCxDQUFDLENBQUMsT0FBTyxHQUFHLFVBQVUsQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUUsRUFBRSxRQUFRLENBQUMsQ0FBQztnQkFDbEQsQ0FBQztnQkFDRCxJQUFJLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztvQkFDaEIsQ0FBQyxDQUFDLFNBQVMsR0FBRyxVQUFVLENBQUMsQ0FBQyxDQUFDLFNBQVMsRUFBRSxFQUFFLEVBQUUsUUFBUSxDQUFDLENBQUM7Z0JBQ3RELENBQUM7Z0JBQ0QsSUFBSSxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7b0JBQ2YsQ0FBQyxDQUFDLFFBQVEsR0FBRyxVQUFVLENBQUMsQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFLEVBQUUsUUFBUSxDQUFDLENBQUM7Z0JBQ3BELENBQUM7Z0JBRUQsSUFBSSxDQUFDLEdBQUcsMkJBQTJCLENBQUMsQ0FBQyxDQUFDLFNBQVMsRUFBRSxRQUFRLEVBQUUsTUFBTSxDQUFDLENBQUM7Z0JBQ25FLElBQUksQ0FBQyxDQUFDLEtBQUssSUFBSSxJQUFJO29CQUFFLENBQUMsQ0FBQyxLQUFLLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxDQUFDLFVBQVUsSUFBSSxJQUFJO29CQUFFLENBQUMsQ0FBQyxVQUFVLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3ZFLElBQUksQ0FBQyxDQUFDLEtBQUssSUFBSSxJQUFJO29CQUFFLENBQUMsQ0FBQyxLQUFLLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxDQUFDLE9BQU8sSUFBSSxJQUFJO29CQUFFLENBQUMsQ0FBQyxPQUFPLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBRTlELElBQUksQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztvQkFDbkIsQ0FBQyxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7Z0JBQ25CLENBQUM7cUJBQU0sSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRSxDQUFDO29CQUMxQixDQUFDLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQztnQkFDckIsQ0FBQztxQkFBTSxJQUFJLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFLENBQUM7b0JBQzFCLENBQUMsQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO2dCQUNwQixDQUFDO3FCQUFNLElBQUksQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztvQkFDMUIsQ0FBQyxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7Z0JBQ3BCLENBQUM7cUJBQU0sSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRSxDQUFDO29CQUMxQixDQUFDLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQztnQkFDdEIsQ0FBQztxQkFBTSxJQUFJLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFLENBQUM7b0JBQzFCLENBQUMsQ0FBQyxNQUFNLEdBQUcsU0FBUyxDQUFDO2dCQUN2QixDQUFDO3FCQUFNLENBQUM7b0JBQ04sQ0FBQyxDQUFDLE1BQU0sR0FBRyxHQUFHLENBQUM7Z0JBQ2pCLENBQUM7WUFDSCxDQUFDO1lBRUQsSUFBSSxDQUFDLEdBQUcsMkJBQTJCLENBQUMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFFN0Qsc0RBQXNEO1lBQ3RELElBQUksQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksRUFBRSxFQUFFLENBQUM7Z0JBQ3pCLENBQUMsR0FBRyxrRkFBa0YsQ0FBQztZQUN6RixDQUFDO1lBRUQsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsa0ZBQWtGLEVBQUUsQ0FBQyxDQUFNLEVBQUUsS0FBYSxFQUFFLEtBQWEsRUFBRSxNQUFjLEVBQUUsS0FBVSxFQUFFLEVBQUU7Z0JBQ3JLLE1BQU0sWUFBWSxHQUFHLFFBQVEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBRXpDLElBQUksQ0FBQyxDQUFDLE9BQU8sSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLE1BQU0sR0FBRyxZQUFZLEVBQUUsQ0FBQztvQkFDN0UsTUFBTSxLQUFLLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztvQkFFdEMsb0JBQW9CO29CQUNwQixNQUFNLEVBQUUsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7b0JBQzVELE1BQU0sR0FBRyxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztvQkFFL0QsMkJBQTJCO29CQUMzQixJQUFJLEtBQUssR0FBUSxJQUFJLENBQUM7b0JBQ3RCLElBQUksS0FBSyxFQUFFLENBQUM7d0JBQ1YsS0FBSyxHQUFHLEVBQUUsQ0FBQzt3QkFDWCxLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQVksRUFBRSxFQUFFOzRCQUN4QyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7NEJBQy9CLElBQUksQ0FBQyxJQUFJLENBQUM7Z0NBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQzt3QkFDekMsQ0FBQyxDQUFDLENBQUM7b0JBQ0wsQ0FBQztvQkFFRCxJQUFJLE9BQU8sS0FBSyxLQUFLLFFBQVEsRUFBRSxDQUFDO3dCQUM5QixJQUFJLEtBQUssRUFBRSxDQUFDOzRCQUNWLHlDQUF5Qzs0QkFDekMsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDOzRCQUNwQyxPQUFPLE1BQU0sS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO3dCQUM3QyxDQUFDOzZCQUFNLElBQUksRUFBRSxLQUFLLElBQUksRUFBRSxDQUFDOzRCQUN2QixPQUFPLEtBQUssQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7d0JBQzNCLENBQUM7NkJBQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQzs0QkFDcEMsT0FBTyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsbUJBQW1CO3dCQUM5QyxDQUFDOzZCQUFNLENBQUM7NEJBQ04sT0FBTyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQyxVQUFVO3dCQUNyQyxDQUFDO29CQUNILENBQUM7eUJBQU0sSUFBSSxPQUFPLEtBQUssS0FBSyxRQUFRLEVBQUUsQ0FBQzt3QkFDckMsSUFBSSxHQUFHLEtBQUssSUFBSSxFQUFFLENBQUM7NEJBQ2pCLE9BQU8sS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7d0JBQ2pDLENBQUM7NkJBQU0sQ0FBQzs0QkFDTixPQUFPLEtBQUssQ0FBQzt3QkFDZixDQUFDO29CQUNILENBQUM7Z0JBQ0gsQ0FBQztnQkFFRCxPQUFPLEdBQUcsQ0FBQyxDQUFDLHFDQUFxQztZQUNuRCxDQUFDLENBQUMsQ0FBQztZQUVILElBQUksR0FBRyxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLENBQUMsS0FBVSxFQUFFLElBQVMsRUFBRSxFQUFFO2dCQUM1RCxJQUFJLElBQUksS0FBSyxXQUFXLEVBQUUsQ0FBQztvQkFDekIsSUFBSSxVQUFVLEVBQUUsQ0FBQzt3QkFDZixPQUFPLFdBQVcsQ0FBQztvQkFDckIsQ0FBQztvQkFDRCxJQUFJLENBQUMsQ0FBQyxLQUFLLElBQUksSUFBSSxFQUFFLENBQUM7d0JBQ3BCLE9BQU8sR0FBRyxDQUFDO29CQUNiLENBQUM7eUJBQU0sSUFBSSxDQUFDLENBQUMsU0FBUyxFQUFFLENBQUM7d0JBQ3ZCLElBQUksQ0FBQyxHQUFHLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxTQUFTLEVBQUUsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO3dCQUNuRSxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO29CQUNsQyxDQUFDO3lCQUFNLENBQUM7d0JBQ04sT0FBTyxDQUFDLENBQUMsS0FBSyxDQUFDO29CQUNqQixDQUFDO2dCQUNILENBQUM7cUJBQU0sSUFBSSxJQUFJLEtBQUssYUFBYSxFQUFFLENBQUM7b0JBQ2xDLElBQUksQ0FBQyxDQUFDLEtBQUssSUFBSSxJQUFJLEVBQUUsQ0FBQzt3QkFDcEIsT0FBTyxLQUFLLENBQUM7b0JBQ2YsQ0FBQzt5QkFBTSxJQUFJLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQzt3QkFDdkIsSUFBSSxDQUFDLEdBQUcsMkJBQTJCLENBQUMsQ0FBQyxDQUFDLFNBQVMsRUFBRSxRQUFRLEVBQUUsTUFBTSxDQUFDLENBQUM7d0JBQ25FLE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7b0JBQ2xDLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixPQUFPLENBQUMsQ0FBQyxLQUFLLENBQUM7b0JBQ2pCLENBQUM7Z0JBQ0gsQ0FBQztxQkFBTSxJQUFJLElBQUksS0FBSyxlQUFlLEVBQUUsQ0FBQztvQkFDcEMsSUFBSSxDQUFDLENBQUMsT0FBTyxJQUFJLElBQUksRUFBRSxDQUFDO3dCQUN0QixPQUFPLEtBQUssQ0FBQztvQkFDZixDQUFDO3lCQUFNLElBQUksQ0FBQyxDQUFDLFNBQVMsRUFBRSxDQUFDO3dCQUN2QixJQUFJLENBQUMsR0FBRywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsU0FBUyxFQUFFLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQzt3QkFDbkUsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQztvQkFDcEMsQ0FBQzt5QkFBTSxDQUFDO3dCQUNOLE9BQU8sQ0FBQyxDQUFDLE9BQU8sQ0FBQztvQkFDbkIsQ0FBQztnQkFDSCxDQUFDO3FCQUFNLElBQUksSUFBSSxLQUFLLGtCQUFrQixFQUFFLENBQUM7b0JBQ3ZDLElBQUksVUFBVSxFQUFFLENBQUM7d0JBQ2YsT0FBTyxnQkFBZ0IsQ0FBQztvQkFDMUIsQ0FBQztvQkFDRCxJQUFJLENBQUMsQ0FBQyxVQUFVLElBQUksSUFBSSxFQUFFLENBQUM7d0JBQ3pCLE9BQU8sS0FBSyxDQUFDO29CQUNmLENBQUM7eUJBQU0sSUFBSSxDQUFDLENBQUMsU0FBUyxFQUFFLENBQUM7d0JBQ3ZCLElBQUksQ0FBQyxHQUFHLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxTQUFTLEVBQUUsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO3dCQUNuRSxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQyxDQUFDO29CQUN2QyxDQUFDO3lCQUFNLENBQUM7d0JBQ04sT0FBTyxDQUFDLENBQUMsVUFBVSxDQUFDO29CQUN0QixDQUFDO2dCQUNILENBQUM7cUJBQU0sSUFBSSxJQUFJLEtBQUssVUFBVSxFQUFFLENBQUM7b0JBQy9CLElBQUksQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO3dCQUNkLE9BQU8sMkJBQTJCLENBQUMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUM7b0JBQzlELENBQUM7eUJBQU0sQ0FBQzt3QkFDTixPQUFPLEVBQUUsQ0FBQztvQkFDWixDQUFDO2dCQUNILENBQUM7cUJBQU0sSUFBSSxJQUFJLEtBQUssV0FBVyxFQUFFLENBQUM7b0JBQ2hDLElBQUksQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO3dCQUNmLE9BQU8sMkJBQTJCLENBQUMsQ0FBQyxDQUFDLFFBQVEsRUFBRSxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUM7b0JBQy9ELENBQUM7eUJBQU0sQ0FBQzt3QkFDTixPQUFPLEVBQUUsQ0FBQztvQkFDWixDQUFDO2dCQUNILENBQUM7cUJBQU0sSUFBSSxJQUFJLEtBQUssaUJBQWlCLEVBQUUsQ0FBQztvQkFDdEMsSUFBSSxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7d0JBQ2YsT0FBTywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLFFBQVEsRUFBRSxFQUFFLENBQUMsQ0FBQztvQkFDL0QsQ0FBQzt5QkFBTSxDQUFDO3dCQUNOLElBQUksS0FBSyxHQUFHLENBQUMsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO3dCQUM1QixJQUFJLEdBQUcsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ2pELElBQUksS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQzs0QkFDckIsSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7Z0NBQzVCLEdBQUcsR0FBRyxHQUFHLEdBQUcsS0FBSyxDQUFDOzRCQUNwQixDQUFDO2lDQUFNLElBQUksS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO2dDQUNsQyxHQUFHLEdBQUcsR0FBRyxHQUFHLEtBQUssQ0FBQzs0QkFDcEIsQ0FBQzs0QkFDRCxJQUFJLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQztnQ0FDNUIsR0FBRyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUM7NEJBQ25CLENBQUM7aUNBQU0sSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7Z0NBQ2xDLEdBQUcsR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDOzRCQUNuQixDQUFDO3dCQUNILENBQUM7d0JBQ0QsT0FBTyxHQUFHLENBQUM7b0JBQ2IsQ0FBQztnQkFDSCxDQUFDO3FCQUFNLElBQUksSUFBSSxLQUFLLFVBQVUsRUFBRSxDQUFDO29CQUMvQixJQUFJLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQzt3QkFDZCxPQUFPLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxPQUFPLEVBQUUsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDO29CQUM5RCxDQUFDO3lCQUFNLENBQUM7d0JBQ04sT0FBTyxFQUFFLENBQUM7b0JBQ1osQ0FBQztnQkFDSCxDQUFDO3FCQUFNLElBQUksSUFBSSxLQUFLLFVBQVUsRUFBRSxDQUFDO29CQUMvQixPQUFPLENBQUMsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUM1QixDQUFDO2dCQUNELE9BQU8sS0FBSyxDQUFDO1lBQ2YsQ0FBQyxDQUFDLENBQUM7WUFDSCxJQUFJLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7Z0JBQ3JCLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUM7WUFDM0IsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLENBQUMsQ0FBQyxPQUFPLEdBQUcsR0FBRyxDQUFDO1lBQ2xCLENBQUM7UUFDSCxDQUFDO1FBQ0QsSUFBSSxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ3JCLENBQUMsQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDO1FBQ3ZCLENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFzQixjQUFjLENBQVksUUFBMkIsRUFBRSxVQUFnQixFQUFFLGFBQW1CLEVBQUUsRUFBVyxFQUFFLEdBQWEsRUFBRSxVQUFvQjs7UUFDbEssSUFBSSxHQUFHLEdBQUcsd0NBQXdDLENBQUM7UUFFbkQsSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUNSLEdBQUcsR0FBRyxHQUFHLEdBQUcsYUFBYSxDQUFDO1FBQzVCLENBQUM7UUFDRCxHQUFHLElBQUksS0FBSyxHQUFHLElBQUksSUFBSSxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUM7UUFFcEMsSUFBSSxHQUFHLEdBQVEsSUFBSSxDQUFDO1FBQ3BCLElBQUksQ0FBQztZQUNILElBQUksTUFBTSxHQUFRO2dCQUNoQixNQUFNLEVBQUUsS0FBSztnQkFDYixRQUFRLEVBQUUsV0FBVztnQkFDckIsSUFBSSxFQUFFLEdBQUc7Z0JBQ1QsSUFBSSxFQUFFLElBQUk7Z0JBQ1YsZUFBZTtnQkFDZixPQUFPLEVBQUU7b0JBQ1AsdUNBQXVDO29CQUN2QyxZQUFZLEVBQUUsSUFBSSxDQUFDLFFBQVE7b0JBQzNCLE1BQU0sRUFBRSxhQUFhO2lCQUN0QjthQUNGLENBQUM7WUFFRixJQUFJLENBQUM7Z0JBQ0gsR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQzNCLENBQUM7WUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO2dCQUNYLElBQUksQ0FBQztvQkFDSCxNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDakIsR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUMzQixDQUFDO2dCQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7b0JBQ1gsT0FBTyxJQUFJLENBQUM7Z0JBQ2QsQ0FBQztZQUNILENBQUM7UUFDSCxDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFBLENBQUM7UUFFZCxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDcEIsYUFBYSxDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLFVBQVUsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNwRCxDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sSUFBSSxDQUFDO1FBQ2QsQ0FBQztRQUVELElBQUksVUFBVSxJQUFJLGFBQWEsRUFBRSxDQUFDO1lBQ2hDLElBQUksQ0FBQyxHQUFHO2dCQUNOLEtBQUssRUFBRSxJQUFJO2dCQUNYLE9BQU8sRUFBRSxJQUFJO2dCQUNiLE9BQU8sRUFBRSxJQUFJO2dCQUNiLGdCQUFnQixFQUFFLElBQUk7Z0JBQ3RCLG1CQUFtQixFQUFFLElBQUk7Z0JBQ3pCLGdCQUFnQixFQUFFLElBQUk7Z0JBQ3RCLGtCQUFrQixFQUFFLElBQUk7Z0JBQ3hCLHFCQUFxQixFQUFFLElBQUk7Z0JBQzNCLGtCQUFrQixFQUFFLElBQUk7YUFDekIsQ0FBQztZQUVGLElBQUksVUFBVSxFQUFFLENBQUM7Z0JBQ2YsQ0FBQyxDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsS0FBSyxDQUFDO2dCQUMzQixDQUFDLENBQUMsT0FBTyxHQUFHLFVBQVUsQ0FBQyxPQUFPLENBQUM7Z0JBQy9CLENBQUMsQ0FBQyxPQUFPLEdBQUcsVUFBVSxDQUFDLE9BQU8sQ0FBQztZQUNqQyxDQUFDO1lBRUQsSUFBSSxhQUFhLEVBQUUsQ0FBQztnQkFDbEIsQ0FBQyxDQUFDLGdCQUFnQixHQUFHLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDcEQsQ0FBQyxDQUFDLG1CQUFtQixHQUFHLGFBQWEsQ0FBQyxtQkFBbUIsQ0FBQztnQkFDMUQsQ0FBQyxDQUFDLGdCQUFnQixHQUFHLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDcEQsQ0FBQyxDQUFDLGtCQUFrQixHQUFHLGFBQWEsQ0FBQyxrQkFBa0IsQ0FBQztnQkFDeEQsQ0FBQyxDQUFDLHFCQUFxQixHQUFHLGFBQWEsQ0FBQyxxQkFBcUIsQ0FBQztnQkFDOUQsQ0FBQyxDQUFDLGtCQUFrQixHQUFHLGFBQWEsQ0FBQyxrQkFBa0IsQ0FBQztZQUMxRCxDQUFDO1lBRUQsSUFBSSxRQUFRLEdBQVUsRUFBRSxDQUFDO1lBQ3pCLEtBQUssSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksRUFBRSxDQUFDO2dCQUN6QixpQkFBaUI7Z0JBQ2pCLElBQUksR0FBRyxDQUFDLEtBQUssSUFBSSxJQUFJLEVBQUUsQ0FBQztvQkFDdEIsSUFBSSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7d0JBQ2QsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDckIsQ0FBQztnQkFDSCxDQUFDO3FCQUFNLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxPQUFPLElBQUksQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztvQkFDbkUsSUFBSSxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUM7d0JBQ2YsVUFBVTt3QkFDVixJQUFJLENBQUMsQ0FBQyxnQkFBZ0IsSUFBSSxHQUFHLENBQUMsU0FBUyxFQUFFLENBQUM7NEJBQ3hDLFFBQVEsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ3JCLENBQUM7NkJBQU0sSUFBSSxDQUFDLENBQUMsbUJBQW1CLElBQUksQ0FBQyxHQUFHLENBQUMsU0FBUyxFQUFFLENBQUM7NEJBQ25ELFFBQVEsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ3JCLENBQUM7NkJBQU0sSUFBSSxDQUFDLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxHQUFHLENBQUMsU0FBUyxFQUFFLENBQUM7NEJBQ2hELFFBQVEsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ3JCLENBQUM7b0JBQ0gsQ0FBQzt5QkFBTSxJQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDO3dCQUN2QixZQUFZO3dCQUNaLElBQUksQ0FBQyxDQUFDLGtCQUFrQixJQUFJLEdBQUcsQ0FBQyxTQUFTLEVBQUUsQ0FBQzs0QkFDMUMsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFDckIsQ0FBQzs2QkFBTSxJQUFJLENBQUMsQ0FBQyxxQkFBcUIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsQ0FBQzs0QkFDckQsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFDckIsQ0FBQzs2QkFBTSxJQUFJLENBQUMsQ0FBQyxrQkFBa0IsSUFBSSxDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsQ0FBQzs0QkFDbEQsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFDckIsQ0FBQztvQkFDSCxDQUFDO2dCQUNILENBQUM7WUFDSCxDQUFDO1lBQ0QsT0FBTyxRQUFRLENBQUM7UUFDbEIsQ0FBQztRQUVELE9BQU8sR0FBRyxDQUFDLElBQUksQ0FBQztJQUNsQixDQUFDO0NBQUE7QUFFRCxtQ0FBbUM7QUFDbkMsU0FBc0IsY0FBYyxDQUVsQyxRQUFnQixFQUNoQixJQUFVLEVBQ1YsRUFBUSxFQUNSLEtBQWMsRUFDZCxJQUFtQyxFQUNuQyxVQUE0QixFQUM1QixjQUF5QixFQUN6QixXQUFvQixFQUNwQixHQUFjLEVBQ2QsUUFBaUI7O1FBRWpCLElBQUksRUFBRSxHQUFhLEVBQUUsQ0FBQztRQUN0QixJQUFJLGNBQWMsRUFBRSxDQUFDO1lBQ25CLEVBQUUsR0FBRyxjQUFjLENBQUM7UUFDdEIsQ0FBQztRQUVELG1DQUFtQztRQUNuQyxnREFBZ0Q7UUFDaEQsSUFBSSxHQUFHLEdBQUcsaUJBQWlCLENBQUM7UUFDNUIsSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLFFBQVEsS0FBSyxhQUFhLEVBQUUsQ0FBQztZQUMzQyxHQUFHLEdBQUcsc0NBQXNDLENBQUM7UUFDL0MsQ0FBQztRQUNELEdBQUcsR0FBRyxHQUFHLEdBQUcsY0FBYyxHQUFHLGtCQUFrQixDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBQ3BFLEdBQUcsR0FBRyxHQUFHLEdBQUcsTUFBTSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBRTFELElBQUksS0FBSyxFQUFFLENBQUM7WUFDVixHQUFHLEdBQUcsR0FBRyxHQUFHLFNBQVMsR0FBRyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNwRCxDQUFDO1FBRUQsSUFBSSxXQUFXLEVBQUUsQ0FBQztZQUNoQixHQUFHLEdBQUcsR0FBRyxHQUFHLGVBQWUsR0FBRyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUNoRSxDQUFDO1FBRUQsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUMxQixJQUFJLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDakIsS0FBSyxNQUFNLEdBQUcsSUFBSSxHQUFHLEVBQUUsQ0FBQztnQkFDdEIsT0FBTyxHQUFHLE9BQU8sR0FBRyxTQUFTLEdBQUcsa0JBQWtCLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDMUQsQ0FBQztZQUNELEdBQUcsR0FBRyxHQUFHLEdBQUcsT0FBTyxDQUFDO1FBQ3RCLENBQUM7UUFFRCxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDdkIsR0FBRyxHQUFHLEdBQUcsR0FBRyxhQUFhLENBQUM7UUFDNUIsQ0FBQztRQUVELElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUN6QixHQUFHLEdBQUcsR0FBRyxHQUFHLGVBQWUsQ0FBQztRQUM5QixDQUFDO1FBRUQsSUFBSSxVQUFVLEVBQUUsQ0FBQztZQUNmLElBQUksSUFBSSxHQUFhLEVBQUUsQ0FBQztZQUN4QixJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNmLENBQUM7WUFDRCxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsQ0FBQztnQkFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNmLENBQUM7WUFDRCxJQUFJLFVBQVUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDdkIsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNmLENBQUM7WUFDRCxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNmLENBQUM7WUFDRCxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsQ0FBQztnQkFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNmLENBQUM7WUFDRCxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDckIsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNmLENBQUM7WUFFRCxHQUFHLEdBQUcsR0FBRyxHQUFHLGNBQWMsR0FBRyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDbEUsQ0FBQztRQUVELElBQUksRUFBRSxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLElBQUksRUFBRSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUM3QyxHQUFHLEdBQUcsR0FBRyxHQUFHLGtCQUFrQixHQUFHLGtCQUFrQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUMxRSxDQUFDO1FBRUQsR0FBRyxJQUFJLEtBQUssR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBRXBDLElBQUksTUFBTSxHQUFRO1lBQ2hCLE1BQU0sRUFBRSxLQUFLO1lBQ2IsUUFBUSxFQUFFLFdBQVc7WUFDckIsSUFBSSxFQUFFLEdBQUc7WUFDVCxJQUFJLEVBQUUsSUFBSTtZQUNWLGVBQWU7WUFDZixPQUFPLEVBQUU7Z0JBQ1AsdUNBQXVDO2dCQUN2QyxZQUFZLEVBQUUsSUFBSSxDQUFDLFFBQVE7Z0JBQzNCLE1BQU0sRUFBRSxhQUFhO2FBQ3RCO1NBQ0YsQ0FBQztRQUVGLElBQUksR0FBRyxHQUFRLElBQUksQ0FBQztRQUVwQixJQUFJLENBQUM7WUFDSCxHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDM0IsQ0FBQztRQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDWCxJQUFJLENBQUM7Z0JBQ0gsTUFBTSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ2pCLEdBQUcsR0FBRyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUMzQixDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDWCxPQUFPLElBQUksQ0FBQztZQUNkLENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDdEIsYUFBYSxDQUFDLEdBQUcsRUFBRSxRQUFRLEVBQUUsU0FBUyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1lBQ2xELGdEQUFnRDtZQUNoRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Y0ErQ0U7UUFDSixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sSUFBSSxDQUFDO1FBQ2QsQ0FBQztRQUVELE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQztDQUFBO0FBRUQsU0FBc0IsZ0JBQWdCLENBQVksR0FBVyxFQUFFLElBQVUsRUFBRSxFQUFRLEVBQUUsVUFBbUIsRUFBRSxLQUFjOztRQUN0SCxJQUFJLEtBQUssR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBRWpDLElBQUksSUFBSSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDMUIsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzdCLElBQUksU0FBUyxLQUFLLEdBQUcsRUFBRSxDQUFDO1FBQ3hCLENBQUM7YUFBTSxJQUFJLFNBQVMsSUFBSSxJQUFJLENBQUMsV0FBVyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksSUFBSSxFQUFFLENBQUM7WUFDOUgsR0FBRyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2hFLENBQUM7UUFFRCxJQUFJLEdBQUcsR0FBRyxpQkFBaUIsQ0FBQztRQUM1QixHQUFHLEdBQUcsR0FBRyxHQUFHLGtCQUFrQixHQUFHLGtCQUFrQixDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBQ3hFLEdBQUcsR0FBRyxHQUFHLEdBQUcsTUFBTSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBRTFELElBQUksS0FBSyxFQUFFLENBQUM7WUFDVixHQUFHLEdBQUcsR0FBRyxHQUFHLFNBQVMsR0FBRyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNwRCxDQUFDO1FBRUQsSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUNSLEdBQUcsR0FBRyxHQUFHLEdBQUcsT0FBTyxHQUFHLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELENBQUM7UUFFRCxJQUFJLFVBQVUsRUFBRSxDQUFDO1lBQ2YsR0FBRyxHQUFHLEdBQUcsR0FBRyxjQUFjLEdBQUcsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDOUQsQ0FBQztRQUVELElBQUksTUFBTSxHQUFRO1lBQ2hCLE1BQU0sRUFBRSxLQUFLO1lBQ2IsUUFBUSxFQUFFLFdBQVc7WUFDckIsSUFBSSxFQUFFLEdBQUc7WUFDVCxJQUFJLEVBQUUsSUFBSTtZQUNWLGVBQWU7WUFDZixPQUFPLEVBQUU7Z0JBQ1AsdUNBQXVDO2dCQUN2QyxZQUFZLEVBQUUsSUFBSSxDQUFDLFFBQVE7Z0JBQzNCLE1BQU0sRUFBRSxhQUFhO2FBQ3RCO1NBQ0YsQ0FBQztRQUVGLElBQUksR0FBRyxHQUFRLElBQUksQ0FBQztRQUVwQixJQUFJLENBQUM7WUFDSCxHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDM0IsQ0FBQztRQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDWCxJQUFJLENBQUM7Z0JBQ0gsTUFBTSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ2pCLEdBQUcsR0FBRyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUMzQixDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDWCxPQUFPLElBQUksQ0FBQztZQUNkLENBQUM7UUFDSCxDQUFDO1FBRUQsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0NBQUE7QUFFRCxTQUFzQixpQkFBaUIsQ0FFckMsR0FBc0IsRUFDdEIsSUFBVSxFQUNWLEVBQVEsRUFDUixRQUFpQixFQUNqQixZQUFxQixFQUNyQixhQUFxQixFQUNyQixLQUFjLEVBQ2QsT0FBaUIsRUFDakIsWUFBc0IsRUFDdEIsY0FBd0IsRUFDeEIsb0JBQTZCLEVBQzdCLFFBQWlCOztRQUVqQixJQUFJLEtBQUssR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBRWpDLElBQUksUUFBUSxLQUFLLEtBQUssRUFBRSxDQUFDO1lBQ3ZCLFFBQVEsR0FBRyxLQUFLLENBQUM7UUFDbkIsQ0FBQztRQUVELElBQUksT0FBTyxHQUFHLFFBQVEsS0FBSyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDO1FBRWpELElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDeEIsR0FBRyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDZCxDQUFDO1FBRUQsSUFBSSxJQUFJLEdBQWEsRUFBRSxDQUFDO1FBQ3hCLEtBQUssSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7WUFDbEIsSUFBSSxJQUFJLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUN4QixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDN0IsSUFBSSxTQUFTLEtBQUssR0FBRyxFQUFFLENBQUM7Z0JBQ3RCLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDZixDQUFDO2lCQUFNLElBQUksU0FBUyxLQUFLLFdBQVcsRUFBRSxDQUFDO2dCQUNyQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUM7WUFDM0MsQ0FBQztpQkFBTSxJQUFJLFNBQVMsSUFBSSxJQUFJLENBQUMsV0FBVyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksSUFBSSxFQUFFLENBQUM7Z0JBQzlILElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNyRSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQ3BCLENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxHQUFHLEdBQUcsaUJBQWlCLENBQUM7UUFDNUIsR0FBRyxHQUFHLEdBQUcsR0FBRyxZQUFZLEdBQUcsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDbEUsR0FBRyxHQUFHLEdBQUcsR0FBRyxNQUFNLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDMUQsS0FBSyxNQUFNLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUNyQixHQUFHLEdBQUcsR0FBRyxHQUFHLFVBQVUsR0FBRyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNqRCxDQUFDO1FBQ0QsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLEdBQUcsR0FBRyxHQUFHLEdBQUcsV0FBVyxHQUFHLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hELENBQUM7UUFFRCxJQUFJLFlBQVksRUFBRSxDQUFDO1lBQ2pCLEdBQUcsR0FBRyxHQUFHLEdBQUcsZ0JBQWdCLEdBQUcsa0JBQWtCLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDbEUsQ0FBQztRQUVELElBQUksYUFBYSxFQUFFLENBQUM7WUFDbEIsS0FBSyxNQUFNLEdBQUcsSUFBSSxhQUFhLEVBQUUsQ0FBQztnQkFDaEMsR0FBRyxHQUFHLEdBQUcsR0FBRyx1QkFBdUIsR0FBRyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7WUFDaEYsQ0FBQztRQUNILENBQUM7UUFFRCxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ1YsR0FBRyxHQUFHLEdBQUcsR0FBRyxTQUFTLEdBQUcsa0JBQWtCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDcEQsQ0FBQztRQUVELElBQUksb0JBQW9CLEVBQUUsQ0FBQztZQUN6QixHQUFHLEdBQUcsR0FBRyxHQUFHLHdCQUF3QixHQUFHLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDbEYsQ0FBQztRQUVELElBQUksUUFBUSxFQUFFLENBQUM7WUFDYixHQUFHLEdBQUcsR0FBRyxHQUFHLFlBQVksR0FBRyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUMxRCxDQUFDO1FBRUQsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLEdBQUcsR0FBRyxHQUFHLEdBQUcsV0FBVyxHQUFHLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hELENBQUM7UUFFRCxJQUFJLFlBQVksSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUN6QixHQUFHLEdBQUcsR0FBRyxHQUFHLGdCQUFnQixHQUFHLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ2xFLENBQUM7UUFFRCxJQUFJLGNBQWMsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUMzQixHQUFHLEdBQUcsR0FBRyxHQUFHLGtCQUFrQixHQUFHLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ3RFLENBQUM7UUFFRCxJQUFJLE1BQU0sR0FBUTtZQUNoQixNQUFNLEVBQUUsS0FBSztZQUNiLFFBQVEsRUFBRSxXQUFXO1lBQ3JCLElBQUksRUFBRSxHQUFHO1lBQ1QsSUFBSSxFQUFFLElBQUk7WUFDVixlQUFlO1lBQ2YsT0FBTyxFQUFFO2dCQUNQLHVDQUF1QztnQkFDdkMsWUFBWSxFQUFFLElBQUksQ0FBQyxRQUFRO2dCQUMzQixNQUFNLEVBQUUsYUFBYTthQUN0QjtTQUNGLENBQUM7UUFFRixJQUFJLEdBQUcsR0FBUSxJQUFJLENBQUM7UUFFcEIsSUFBSSxDQUFDO1lBQ0gsR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzNCLENBQUM7UUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQ1gsSUFBSSxDQUFDO2dCQUNILE1BQU0sS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNqQixHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDM0IsQ0FBQztZQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQ1gsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksR0FBRyxJQUFJLElBQUksSUFBSSxHQUFHLEtBQUssS0FBSyxFQUFFLENBQUM7WUFDakMsSUFBSSxNQUFNLEdBQVEsRUFBRSxDQUFDO1lBQ3JCLEtBQUssSUFBSSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7Z0JBQ3BCLElBQUksQ0FBQztvQkFDSCxJQUFJLElBQUksR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO29CQUMxQixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7b0JBQzdCLElBQUksU0FBUyxLQUFLLEdBQUcsRUFBRSxDQUFDO3dCQUN0QixNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO29CQUN6QixDQUFDO3lCQUFNLElBQUksU0FBUyxJQUFJLElBQUksQ0FBQyxXQUFXLElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQzt3QkFDMUgsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ25FLE1BQU0sQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQzVCLENBQUM7Z0JBQ0gsQ0FBQztnQkFBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUEsQ0FBQztZQUNoQixDQUFDO1lBRUQsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7Z0JBQ25CLEtBQUssSUFBSSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7b0JBQ3BCLElBQUksS0FBSyxHQUFHLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDckIsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFLENBQUM7d0JBQy9DLE9BQU8sS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNsQixDQUFDO3lCQUFNLENBQUM7d0JBQ04sT0FBTyxLQUFLLENBQUM7b0JBQ2YsQ0FBQztnQkFDSCxDQUFDO1lBQ0gsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE9BQU8sTUFBTSxDQUFDO1lBQ2hCLENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxLQUFLLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUNqQyxxRUFBcUU7UUFDckUsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0NBQUE7QUFFRCxTQUFzQix3QkFBd0IsQ0FFNUMsR0FBYSxFQUNiLElBQVUsRUFDVixFQUFRLEVBQ1IsUUFBaUIsRUFDakIsWUFBcUIsRUFDckIsYUFBcUIsRUFDckIsS0FBYyxFQUNkLE9BQWlCLEVBQ2pCLFlBQXNCLEVBQ3RCLGNBQXdCLEVBQ3hCLG9CQUErQixFQUMvQixTQUFvQixFQUNwQixvQkFBNkIsRUFDN0IsUUFBaUI7O1FBRWpCLElBQUksUUFBUSxLQUFLLEtBQUssRUFBRSxDQUFDO1lBQ3ZCLFFBQVEsR0FBRyxLQUFLLENBQUM7UUFDbkIsQ0FBQztRQUNELElBQUksUUFBUSxFQUFFLENBQUM7WUFDYixJQUFJLENBQUMsQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQztnQkFDNUQsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksb0JBQW9CLEVBQUUsQ0FBQztZQUN6QixJQUFJLG9CQUFvQixDQUFDLE1BQU0sS0FBSyxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUM7Z0JBQy9DLE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztRQUNILENBQUM7UUFFRCxJQUFJLFNBQVMsRUFBRSxDQUFDO1lBQ2QsSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDcEMsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksT0FBTyxHQUFRLEVBQUUsQ0FBQztRQUV0QixJQUFJLEtBQUssR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBQ2pDLElBQUksT0FBTyxHQUFHLFFBQVEsS0FBSyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDO1FBRWpELElBQUksSUFBSSxHQUFhLEVBQUUsQ0FBQztRQUN4QixJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDZCxLQUFLLElBQUksRUFBRSxJQUFJLEdBQUcsRUFBRSxDQUFDO1lBQ25CLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQztZQUNYLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDO2dCQUNoQyxDQUFDLEdBQUcsRUFBRSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDckMsQ0FBQztZQUNELElBQUksSUFBSSxHQUFHLENBQUMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDeEIsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQzdCLElBQUksU0FBUyxLQUFLLEdBQUcsRUFBRSxDQUFDO2dCQUN0QixJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNiLElBQUksU0FBUyxFQUFFLENBQUM7b0JBQ2QsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7d0JBQzFCLE9BQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsR0FBRyxPQUFPLENBQUM7b0JBQ3RDLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixJQUFJLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxLQUFLLEtBQUssRUFBRSxDQUFDOzRCQUMxQyxPQUFPLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDO3dCQUN0QyxDQUFDOzZCQUFNLENBQUM7NEJBQ04sT0FBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO3dCQUMxRCxDQUFDO29CQUNILENBQUM7Z0JBQ0gsQ0FBQztxQkFBTSxDQUFDO29CQUNOLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO3dCQUMxQixPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDO29CQUN2QixDQUFDO3lCQUFNLENBQUM7d0JBQ04sSUFBSSxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsS0FBSyxLQUFLLEVBQUUsQ0FBQzs0QkFDMUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxHQUFHLE9BQU8sQ0FBQzt3QkFDdkIsQ0FBQzs2QkFBTSxDQUFDOzRCQUNOLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsQ0FBQzt3QkFDM0MsQ0FBQztvQkFDSCxDQUFDO2dCQUNILENBQUM7WUFDSCxDQUFDO2lCQUFNLElBQUksU0FBUyxJQUFJLElBQUksQ0FBQyxXQUFXLElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQztnQkFDOUgsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ3JFLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7Z0JBRWxCLElBQUksU0FBUyxFQUFFLENBQUM7b0JBQ2QsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7d0JBQzFCLE9BQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsR0FBRyxPQUFPLENBQUM7b0JBQ3RDLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixJQUFJLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxLQUFLLEtBQUssRUFBRSxDQUFDOzRCQUMxQyxPQUFPLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDO3dCQUN0QyxDQUFDOzZCQUFNLENBQUM7NEJBQ04sT0FBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO3dCQUMxRCxDQUFDO29CQUNILENBQUM7Z0JBQ0gsQ0FBQztxQkFBTSxDQUFDO29CQUNOLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO3dCQUMxQixPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDO29CQUN2QixDQUFDO3lCQUFNLENBQUM7d0JBQ04sSUFBSSxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsS0FBSyxLQUFLLEVBQUUsQ0FBQzs0QkFDMUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxHQUFHLE9BQU8sQ0FBQzt3QkFDNUIsQ0FBQzs2QkFBTSxDQUFDOzRCQUNOLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsQ0FBQzt3QkFDaEQsQ0FBQztvQkFDSCxDQUFDO2dCQUNILENBQUM7WUFDSCxDQUFDO1lBRUQsS0FBSyxFQUFFLENBQUM7UUFDVixDQUFDO1FBRUQsSUFBSSxHQUFHLEdBQUcsaUJBQWlCLENBQUM7UUFDNUIsR0FBRyxHQUFHLEdBQUcsR0FBRyxZQUFZLEdBQUcsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDbEUsR0FBRyxHQUFHLEdBQUcsR0FBRyxNQUFNLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDMUQsS0FBSyxNQUFNLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUNyQixHQUFHLEdBQUcsR0FBRyxHQUFHLFVBQVUsR0FBRyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNqRCxDQUFDO1FBQ0QsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLEdBQUcsR0FBRyxHQUFHLEdBQUcsV0FBVyxHQUFHLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hELENBQUM7UUFFRCxJQUFJLFlBQVksRUFBRSxDQUFDO1lBQ2pCLEdBQUcsR0FBRyxHQUFHLEdBQUcsZ0JBQWdCLEdBQUcsa0JBQWtCLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDbEUsQ0FBQztRQUVELElBQUksYUFBYSxFQUFFLENBQUM7WUFDbEIsS0FBSyxNQUFNLEdBQUcsSUFBSSxhQUFhLEVBQUUsQ0FBQztnQkFDaEMsR0FBRyxHQUFHLEdBQUcsR0FBRyx1QkFBdUIsR0FBRyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7WUFDaEYsQ0FBQztRQUNILENBQUM7UUFFRCxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ1YsR0FBRyxHQUFHLEdBQUcsR0FBRyxTQUFTLEdBQUcsa0JBQWtCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDcEQsQ0FBQztRQUVELElBQUksb0JBQW9CLEVBQUUsQ0FBQztZQUN6QixHQUFHLEdBQUcsR0FBRyxHQUFHLHdCQUF3QixHQUFHLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDbEYsQ0FBQztRQUVELElBQUksUUFBUSxFQUFFLENBQUM7WUFDYixHQUFHLEdBQUcsR0FBRyxHQUFHLFlBQVksR0FBRyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUMxRCxDQUFDO1FBRUQsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLEdBQUcsR0FBRyxHQUFHLEdBQUcsV0FBVyxHQUFHLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hELENBQUM7UUFFRCxJQUFJLFlBQVksSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUN6QixHQUFHLEdBQUcsR0FBRyxHQUFHLGdCQUFnQixHQUFHLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ2xFLENBQUM7UUFFRCxJQUFJLGNBQWMsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUMzQixHQUFHLEdBQUcsR0FBRyxHQUFHLGtCQUFrQixHQUFHLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ3RFLENBQUM7UUFFRCxJQUFJLE1BQU0sR0FBUTtZQUNoQixNQUFNLEVBQUUsS0FBSztZQUNiLFFBQVEsRUFBRSxXQUFXO1lBQ3JCLElBQUksRUFBRSxHQUFHO1lBQ1QsSUFBSSxFQUFFLElBQUk7WUFDVixlQUFlO1lBQ2YsT0FBTyxFQUFFO2dCQUNQLHVDQUF1QztnQkFDdkMsWUFBWSxFQUFFLElBQUksQ0FBQyxRQUFRO2dCQUMzQixNQUFNLEVBQUUsYUFBYTthQUN0QjtTQUNGLENBQUM7UUFFRixJQUFJLEdBQUcsR0FBUSxJQUFJLENBQUM7UUFFcEIsSUFBSSxDQUFDO1lBQ0gsR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzNCLENBQUM7UUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQ1gsSUFBSSxDQUFDO2dCQUNILE1BQU0sS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNqQixHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDM0IsQ0FBQztZQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQ1gsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksR0FBRyxJQUFJLElBQUksSUFBSSxHQUFHLEtBQUssS0FBSyxFQUFFLENBQUM7WUFDakMsSUFBSSxZQUFZLEdBQVEsRUFBRSxDQUFDO1lBQzNCLEtBQUssSUFBSSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7Z0JBQ3BCLElBQUksQ0FBQztvQkFDSCxJQUFJLElBQUksR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO29CQUMxQixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7b0JBQzdCLElBQUksU0FBUyxLQUFLLEdBQUcsRUFBRSxDQUFDO3dCQUN0QixJQUFJLFNBQVMsRUFBRSxDQUFDOzRCQUNkLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7Z0NBQ3BDLElBQUksR0FBRyxDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsQ0FBQyxDQUFDLEtBQUssWUFBWSxHQUFHLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztvQ0FDakUsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztvQ0FDdEMsTUFBTTtnQ0FDUixDQUFDOzRCQUNILENBQUM7d0JBQ0gsQ0FBQzs2QkFBTSxDQUFDOzRCQUNOLFlBQVksQ0FBQyxHQUFHLENBQUMsR0FBRyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQy9CLENBQUM7b0JBQ0gsQ0FBQzt5QkFBTSxJQUFJLFNBQVMsSUFBSSxJQUFJLENBQUMsV0FBVyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLElBQUksSUFBSSxFQUFFLENBQUM7d0JBQzFILElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO3dCQUNuRSxJQUFJLFNBQVMsRUFBRSxDQUFDOzRCQUNkLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7Z0NBQ3BDLElBQUksR0FBRyxDQUFDLENBQUMsQ0FBQyxLQUFLLE1BQU0sRUFBRSxDQUFDO29DQUN0QixZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO29DQUN0QyxNQUFNO2dDQUNSLENBQUM7NEJBQ0gsQ0FBQzt3QkFDSCxDQUFDOzZCQUFNLENBQUM7NEJBQ04sWUFBWSxDQUFDLE1BQU0sQ0FBQyxHQUFHLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFDbEMsQ0FBQztvQkFDSCxDQUFDO2dCQUNILENBQUM7Z0JBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFBLENBQUM7WUFDaEIsQ0FBQztZQUVELHdDQUF3QztZQUN4QyxnREFBZ0Q7WUFDaEQsTUFBTSxhQUFhLEdBQUcsSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUNoQyxLQUFLLE1BQU0sR0FBRyxJQUFJLFlBQVksRUFBRSxDQUFDO2dCQUMvQixLQUFLLE1BQU0sS0FBSyxJQUFJLFlBQVksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO29CQUN0QyxhQUFhLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDOUIsQ0FBQztZQUNILENBQUM7WUFFRCw0Q0FBNEM7WUFDNUMsTUFBTSxTQUFTLEdBQVEsRUFBRSxDQUFDO1lBQzFCLEtBQUssTUFBTSxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7Z0JBQy9CLFNBQVMsQ0FBQyxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7Z0JBQ3BCLEtBQUssTUFBTSxLQUFLLElBQUksWUFBWSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7b0JBQ3RDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO2dCQUNqRCxDQUFDO1lBQ0gsQ0FBQztZQUVELG1DQUFtQztZQUNuQyxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztpQkFDckMsSUFBSSxFQUFFLENBQUMseUJBQXlCO2lCQUNoQyxHQUFHLENBQUMsQ0FBQyxFQUFPLEVBQUUsRUFBRTs7Z0JBQ2YsTUFBTSxNQUFNLEdBQVEsRUFBRSxFQUFFLEVBQUUsQ0FBQztnQkFDM0IsS0FBSyxNQUFNLEdBQUcsSUFBSSxTQUFTLEVBQUUsQ0FBQztvQkFDNUIsTUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLE1BQUEsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxtQ0FBSSxJQUFJLENBQUMsQ0FBQywwQkFBMEI7Z0JBQ3RFLENBQUM7Z0JBQ0QsT0FBTyxNQUFNLENBQUM7WUFDaEIsQ0FBQyxDQUFDLENBQUM7WUFFTCxPQUFPLE1BQU0sQ0FBQztRQUNoQixDQUFDO1FBRUQsSUFBSSxLQUFLLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUNqQyxxRUFBcUU7UUFDckUsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0NBQUE7QUFFRCxTQUFzQixnQkFBZ0IsQ0FBWSxHQUFROztRQUN4RCxJQUFJLElBQUksR0FBUSxFQUFFLENBQUM7UUFDbkIsSUFBSSxNQUFNLEdBQUcsS0FBSyxDQUFDO1FBQ25CLEtBQUssSUFBSSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7WUFDcEIsSUFBSSxJQUFJLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUMxQixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDN0IsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxDQUFDO2dCQUMvRixJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDckUsSUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNqQixJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztvQkFDckIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQzt3QkFDbEMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssSUFBSSxFQUFFLENBQUM7NEJBQ2xCLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ1gsQ0FBQzs2QkFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxLQUFLLEVBQUUsQ0FBQzs0QkFDMUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFDWCxDQUFDO29CQUNILENBQUM7b0JBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDbkIsQ0FBQztxQkFBTSxDQUFDO29CQUNOLElBQUksQ0FBQyxLQUFLLElBQUksRUFBRSxDQUFDO3dCQUNmLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQ1IsQ0FBQzt5QkFBTSxJQUFJLENBQUMsS0FBSyxLQUFLLEVBQUUsQ0FBQzt3QkFDdkIsQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDUixDQUFDO29CQUNELElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNyQixDQUFDO2dCQUNELE1BQU0sR0FBRyxJQUFJLENBQUM7WUFDaEIsQ0FBQztRQUNILENBQUM7UUFDRCxJQUFJLE1BQU0sRUFBRSxDQUFDO1lBQ1gsSUFBSSxLQUFLLEdBQUc7Z0JBQ1YsU0FBUyxFQUFFLElBQUk7Z0JBQ2YsT0FBTyxFQUFFLENBQUM7YUFDWCxDQUFDO1lBQ0YsSUFBSSxDQUFDO2dCQUNILE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsa0JBQWtCLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztnQkFDNUUsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDWCxPQUFPLEtBQUssQ0FBQztZQUNmLENBQUM7UUFDSCxDQUFDO1FBRUQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBQUE7QUFFRCxTQUFlLFNBQVMsQ0FBQyxRQUFnQixFQUFFLE9BQWUsRUFBRSxPQUFZOztRQUN0RSxJQUFJLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDO1FBQzlCLElBQUksUUFBUSxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDbEMsT0FBTyxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDOUIsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLE9BQU8sQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1FBQzVCLENBQUM7UUFFRCxJQUFJLEdBQUcsR0FBUSxNQUFNLEtBQUssQ0FBQyxRQUFRLEVBQUUsR0FBRyxHQUFHLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBRXZGLHdDQUF3QztRQUN4QyxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUN0QixNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUNqQixHQUFHLEdBQUcsTUFBTSxLQUFLLENBQUMsUUFBUSxFQUFFLEdBQUcsR0FBRyxRQUFRLENBQUMsQ0FBQyxDQUFDLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUNoRixDQUFDO1FBRUQsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFLENBQUM7WUFDdEIsT0FBTyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNwQixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdEIsQ0FBQztJQUNILENBQUM7Q0FBQTtBQUVELFNBQXNCLFdBQVcsQ0FBWSxVQUFrQixFQUFFLENBQVMsRUFBRSxLQUFhOztRQUN2RixJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksU0FBUyxFQUFFLENBQUM7WUFDNUgsT0FBTyxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLDRCQUE0QixFQUFFLENBQUM7UUFDOUQsQ0FBQztRQUNELElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQy9DLElBQUksTUFBTSxHQUFHLE1BQU0sR0FBRyxHQUFHLENBQUM7UUFFMUIsSUFBSSxDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUMsR0FBRyxNQUFNLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDNUQsT0FBTyxFQUFFLG1CQUFtQjtZQUM1QixNQUFNLEVBQUUsTUFBTTtZQUNkLElBQUksRUFBRSxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsWUFBWSxFQUFFLENBQUMsRUFBRTtTQUN4QyxDQUFDLENBQUM7UUFDSCxJQUFJLEdBQUcsRUFBRSxDQUFDO1lBQ1Isc0NBQXNDO1lBQ3RDLElBQUksWUFBWSxHQUFhLEVBQUUsQ0FBQztZQUNoQyxLQUFLLElBQUksQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDO2dCQUNsQixJQUFJLElBQUksR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQzdCLElBQUksU0FBUyxJQUFJLElBQUksQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztvQkFDM0YsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQ25FLFlBQVksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7Z0JBQzVCLENBQUM7cUJBQU0sSUFBSSxTQUFTLElBQUksR0FBRyxFQUFFLENBQUM7b0JBQzVCLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7Z0JBQ3ZCLENBQUM7WUFDSCxDQUFDO1lBQ0QsT0FBTyxZQUFZLENBQUM7UUFDdEIsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7SUFDSCxDQUFDO0NBQUE7QUFFRCxTQUFzQixVQUFVLENBQVksR0FBYTs7UUFDdkQsSUFBSSxJQUFJLEdBQWEsRUFBRSxDQUFDO1FBQ3hCLEtBQUssSUFBSSxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7WUFDcEIsSUFBSSxJQUFJLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUMxQixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDN0IsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEtBQUssU0FBUyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLFNBQVMsRUFBRSxDQUFDO2dCQUN6SSxJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDckUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUNwQixDQUFDO1FBQ0gsQ0FBQztRQUNELElBQUksSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNwQixNQUFNLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxPQUFPLEVBQUU7Z0JBQzNDLE9BQU8sRUFBRSxlQUFlO2dCQUN4QixJQUFJLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFO2FBQ3JCLENBQUMsQ0FBQztRQUNMLENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxLQUFLLENBQUM7UUFDZixDQUFDO0lBQ0gsQ0FBQztDQUFBO0FBRUQsU0FBc0Isc0JBQXNCLENBQVksVUFBa0IsRUFBRSxDQUFTOztRQUNuRixJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLElBQUksU0FBUyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLElBQUksU0FBUyxFQUFFLENBQUM7WUFDNUgsT0FBTyxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLDRCQUE0QixFQUFFLENBQUM7UUFDOUQsQ0FBQztRQUNELElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQy9DLElBQUksTUFBTSxHQUFHLE1BQU0sR0FBRyxHQUFHLEdBQUcsQ0FBQyxDQUFDO1FBQzlCLElBQUksQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEdBQUcsTUFBTSxTQUFTLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQzVELE9BQU8sRUFBRSwwQkFBMEI7WUFDbkMsR0FBRyxFQUFFLE1BQU07U0FDWixDQUFDLENBQUM7UUFDSCxPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUM7Q0FBQTtBQUVELFNBQXNCLE1BQU0sQ0FBWSxPQUFlLEVBQUUsSUFBUzs7UUFDaEUsSUFBSSxJQUFJLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM5QixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDN0IsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEtBQUssU0FBUyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ3pJLElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ3JFLElBQUksQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEdBQUcsTUFBTSxTQUFTLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsT0FBTyxFQUFFO2dCQUM1RCxPQUFPLEVBQUUsV0FBVztnQkFDcEIsSUFBSSxFQUFFLElBQUk7Z0JBQ1YsR0FBRyxFQUFFLE1BQU07YUFDWixDQUFDLENBQUM7WUFDSCxPQUFPLEdBQUcsQ0FBQztRQUNiLENBQUM7UUFDRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7Q0FBQTtBQUVELFNBQVMsT0FBTyxDQUFZLE9BQWUsRUFBRSxpQkFBeUIsRUFBRSxXQUFnQixFQUFFLE1BQVcsRUFBRSxLQUFVLEVBQUUsSUFBUyxFQUFFLElBQVU7SUFDdEksSUFBSSxRQUFRLEdBQUcsV0FBVyxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3JELElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUNkLEtBQUssSUFBSSxDQUFDLElBQUksV0FBVyxDQUFDLE1BQU0sRUFBRSxDQUFDO1lBQ2pDLElBQUksQ0FBQyxDQUFDLEVBQUUsS0FBSyxpQkFBaUIsRUFBRSxDQUFDO2dCQUMvQixRQUFRLEdBQUcsQ0FBQyxDQUFDO1lBQ2YsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0lBRUQsSUFBSSxRQUFRLEVBQUUsQ0FBQztRQUNiLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDdEIsUUFBUSxDQUFDLE9BQU8sR0FBRztnQkFDakIsT0FBTyxFQUFFLElBQUk7Z0JBQ2IsSUFBSSxFQUFFLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLEVBQUU7YUFDWixDQUFDO1FBQ0osQ0FBQztRQUNELElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFDO1lBQzlCLFFBQVEsQ0FBQyxPQUFPLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQztRQUNsQyxDQUFDO1FBQ0QsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDM0IsUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDO1FBQzdCLENBQUM7UUFDRCxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUM5QixRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUM7UUFDaEMsQ0FBQztRQUVELElBQUksVUFBVSxHQUFHLENBQUMsSUFBWSxFQUFFLEVBQUU7WUFDaEMsSUFBSSxPQUFPLEdBQUcsUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDMUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUNiLE9BQU8sR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQzVELENBQUM7WUFFRCxJQUFJLE9BQU8sSUFBSSxLQUFLLFFBQVEsRUFBRSxDQUFDO2dCQUM3QixPQUFPLEdBQUcsSUFBSSxDQUFDO1lBQ2pCLENBQUM7aUJBQU0sSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7Z0JBQzlCLE9BQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDdkIsQ0FBQztZQUVELElBQUksTUFBTSxJQUFJLElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUMvQixPQUFPLEdBQUcsVUFBVSxDQUFDO1lBQ3ZCLENBQUM7WUFFRCxJQUFJLE1BQU0sSUFBSSxJQUFJLElBQUksT0FBTyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDO2dCQUNuRCxJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztnQkFDbkQsYUFBYSxDQUFDLENBQUMsU0FBUyxDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7Z0JBQ2pDLElBQUksUUFBUSxHQUFHLFNBQVMsQ0FBQyxPQUFPLENBQUM7Z0JBQ2pDLE9BQU8sR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQztZQUNyRCxDQUFDO1lBRUQsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUNiLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDZixDQUFDO1lBQ0QsT0FBTyxPQUFPLENBQUM7UUFDakIsQ0FBQyxDQUFDO1FBRUYsSUFBSSxVQUFVLEdBQUcsQ0FBQyxJQUFZLEVBQUUsRUFBRTtZQUNoQyxJQUFJLE9BQU8sR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUM3QyxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7Z0JBQ2IsT0FBTyxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDL0QsQ0FBQztZQUVELElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxFQUFFLENBQUM7Z0JBQzlCLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDbEIsQ0FBQztpQkFBTSxJQUFJLEtBQUssSUFBSSxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQztnQkFDaEMsT0FBTyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUN4QixDQUFDO1lBRUQsSUFBSSxNQUFNLElBQUksSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7Z0JBQy9CLE9BQU8sR0FBRyxtQkFBbUIsQ0FBQztZQUNoQyxDQUFDO1lBQ0QsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUNiLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDZixDQUFDO1lBRUQsT0FBTyxPQUFPLENBQUM7UUFDakIsQ0FBQyxDQUFDO1FBRUYsSUFBSSxPQUFPLEdBQUcsQ0FBQyxJQUFZLEVBQUUsRUFBRTtZQUM3QixJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBQ1YsT0FBTyxTQUFTLENBQUM7WUFDbkIsQ0FBQztZQUVELElBQUksT0FBTyxJQUFJLEtBQUssUUFBUSxFQUFFLENBQUM7Z0JBQzdCLE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztZQUVELElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNuQixJQUFJLENBQUMsRUFBRSxDQUFDO2dCQUNOLE9BQU8sQ0FBQyxDQUFDO1lBQ1gsQ0FBQztZQUVELElBQUksRUFBRSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ3hDLElBQUksRUFBRSxFQUFFLENBQUM7Z0JBQ1AsT0FBTyxFQUFFLENBQUM7WUFDWixDQUFDO1lBRUQsSUFBSSxJQUFJLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUM3QixJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7Z0JBQ3BCLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3ZCLENBQUM7WUFFRCxPQUFPLFNBQVMsQ0FBQztRQUNuQixDQUFDLENBQUM7UUFFRixJQUFJLEtBQUssR0FBRyxXQUFXLENBQUMsS0FBSyxDQUFDO1FBRTlCLEtBQUssSUFBSSxJQUFJLElBQUksUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQy9CLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7WUFDbkIsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUN6QixJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBRXhCLElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQztZQUVqQixJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxDQUFDLElBQUksTUFBTSxJQUFJLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7Z0JBQ3hGLGtCQUFrQjtnQkFDbEIsS0FBSyxJQUFJLENBQUMsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDcEIsSUFBSSxPQUFPLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFTLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztvQkFDakUsSUFBSSxPQUFPLEVBQUUsQ0FBQzt3QkFDWixJQUFJLElBQUksR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQzt3QkFDcEMsSUFBSSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7NEJBQ1gsSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUM7d0JBQ2hCLENBQUM7d0JBQ0QsSUFBSSxJQUFJLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDO3dCQUM1QixJQUFJLE9BQU8sR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUM7d0JBQy9CLElBQUksS0FBSyxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFFMUIsSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQzs0QkFDdkMsSUFBSSxHQUFHLElBQUksQ0FBQzs0QkFDWixJQUFJLE1BQU0sR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUM7NEJBQ2hELElBQUksQ0FBQyxHQUFRLEVBQUUsR0FBRyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsQ0FBQzs0QkFDekQsSUFBSSxLQUFLLEVBQUUsQ0FBQztnQ0FDVixDQUFDLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQzs0QkFDbkIsQ0FBQzs0QkFDRCxTQUFTLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFDO3dCQUN4QixDQUFDOzZCQUFNLElBQUksR0FBRyxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUM7NEJBQzVDLElBQUksR0FBRyxJQUFJLENBQUM7NEJBQ1osSUFBSSxNQUFNLEdBQUcsR0FBRyxDQUFDLFVBQVUsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDOzRCQUM5QyxJQUFJLENBQUMsR0FBUSxFQUFFLEdBQUcsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLENBQUM7NEJBQ3pELElBQUksS0FBSyxFQUFFLENBQUM7Z0NBQ1YsQ0FBQyxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7NEJBQ25CLENBQUM7NEJBQ0QsU0FBUyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQzt3QkFDeEIsQ0FBQztvQkFDSCxDQUFDO2dCQUNILENBQUM7WUFDSCxDQUFDO1lBRUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLElBQUksR0FBRyxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLE1BQU0sSUFBSSxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO2dCQUN4RixrQkFBa0I7Z0JBQ2xCLEtBQUssSUFBSSxDQUFDLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ3BCLElBQUksT0FBTyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDO29CQUNwQyxJQUFJLE9BQU8sRUFBRSxDQUFDO3dCQUNaLElBQUksSUFBSSxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDO3dCQUNwQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQzs0QkFDWCxJQUFJLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQzt3QkFDaEIsQ0FBQzt3QkFDRCxJQUFJLElBQUksR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUM7d0JBQzVCLElBQUksT0FBTyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDL0IsSUFBSSxLQUFLLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO3dCQUMxQixJQUFJLEdBQUcsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDOzRCQUN2QyxJQUFJLEdBQUcsSUFBSSxDQUFDOzRCQUNaLElBQUksTUFBTSxHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQzs0QkFDaEQsSUFBSSxDQUFDLEdBQVEsRUFBRSxHQUFHLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxDQUFDOzRCQUN6RCxJQUFJLEtBQUssRUFBRSxDQUFDO2dDQUNWLENBQUMsQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDOzRCQUNuQixDQUFDOzRCQUNELFNBQVMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUM7d0JBQ3hCLENBQUM7NkJBQU0sSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQzs0QkFDNUMsSUFBSSxHQUFHLElBQUksQ0FBQzs0QkFDWixJQUFJLE1BQU0sR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7NEJBQzlDLElBQUksQ0FBQyxHQUFRLEVBQUUsR0FBRyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsQ0FBQzs0QkFDekQsSUFBSSxLQUFLLEVBQUUsQ0FBQztnQ0FDVixDQUFDLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQzs0QkFDbkIsQ0FBQzs0QkFDRCxTQUFTLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFDO3dCQUN4QixDQUFDO29CQUNILENBQUM7Z0JBQ0gsQ0FBQztZQUNILENBQUM7WUFFRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBQ1YsSUFBSSxLQUFLLEdBQUcsVUFBVSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQ2pELElBQUksT0FBTyxHQUFHLFVBQVUsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUNuRCxJQUFJLENBQUMsR0FBUSxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLENBQUM7Z0JBQ3ZELElBQUksS0FBSyxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUM5QyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUNWLENBQUMsQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO2dCQUNuQixDQUFDO2dCQUNELFNBQVMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDeEIsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQztBQUVELFNBQWdCLGFBQWEsQ0FBQyxRQUFnQjtJQUM1QyxPQUFPLENBQ0wsUUFBUTtRQUNOLG1DQUFtQztTQUNsQyxPQUFPLENBQUMsY0FBYyxFQUFFLEVBQUUsQ0FBQztRQUM1QixxQ0FBcUM7U0FDcEMsT0FBTyxDQUFDLG1CQUFtQixFQUFFLElBQUksQ0FBQztRQUNuQyxtQ0FBbUM7U0FDbEMsT0FBTyxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FBQztRQUNoQyw4QkFBOEI7U0FDN0IsT0FBTyxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUM7UUFDNUIseUNBQXlDO1NBQ3hDLE9BQU8sQ0FBQyx3QkFBd0IsRUFBRSxJQUFJLENBQUM7UUFDeEMsNEJBQTRCO1NBQzNCLE9BQU8sQ0FBQyxrQkFBa0IsRUFBRSxFQUFFLENBQUM7UUFDaEMscUJBQXFCO1NBQ3BCLE9BQU8sQ0FBQyxhQUFhLEVBQUUsRUFBRSxDQUFDO1FBQzNCLDBCQUEwQjtTQUN6QixPQUFPLENBQUMsZUFBZSxFQUFFLEVBQUUsQ0FBQztRQUM3Qix5QkFBeUI7U0FDeEIsT0FBTyxDQUFDLHdCQUF3QixFQUFFLEVBQUUsQ0FBQztRQUN0Qyx5Q0FBeUM7U0FDeEMsT0FBTyxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUM7UUFDN0Isc0JBQXNCO1NBQ3JCLE9BQU8sQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDO1NBQ3ZCLElBQUksRUFBRSxDQUNWLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBZ0IsaUJBQWlCLENBQUMsWUFBb0I7O0lBQ3BELE1BQU0sRUFBRSxHQUFHLElBQUkscUJBQVUsRUFBRSxDQUFDO0lBTTVCLE1BQU0sTUFBTSxHQUFHLE1BQUEsRUFBRSxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxtQ0FBSSxFQUFFLENBQUM7SUFDbEUsTUFBTSxNQUFNLEdBQWEsRUFBRSxDQUFDO0lBQzVCLE1BQU0sWUFBWSxHQUFVLEVBQUUsQ0FBQztJQUUvQixLQUFLLE1BQU0sS0FBSyxJQUFJLE1BQU0sRUFBRSxDQUFDO1FBQzNCLFFBQVEsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ25CLEtBQUssTUFBTTtnQkFDVCxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFDLENBQUM7Z0JBQ2xELE1BQU07WUFDUixLQUFLLGFBQWE7Z0JBQ2hCLFlBQVksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO2dCQUN6QixNQUFNO1lBQ1IsS0FBSyxjQUFjO2dCQUNqQixZQUFZLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQztnQkFDMUIsTUFBTTtZQUNSLEtBQUssU0FBUztnQkFDWixZQUFZLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQztnQkFDM0IsTUFBTTtZQUNSLEtBQUssVUFBVTtnQkFDYixZQUFZLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztnQkFDNUIsTUFBTTtZQUNSLEtBQUssV0FBVyxDQUFDO1lBQ2pCLEtBQUssV0FBVztnQkFDZCxNQUFNLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO2dCQUMzQixNQUFNO1FBQ1YsQ0FBQztJQUNILENBQUM7SUFFRCxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDekIsQ0FBQztBQUVELFNBQVMsT0FBTyxDQUFDLElBQVksRUFBRSxLQUEyQztJQUN4RSxNQUFNLEtBQUssR0FBYSxFQUFFLENBQUM7SUFDM0IsSUFBSSxLQUFLLENBQUMsSUFBSTtRQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDckMsSUFBSSxLQUFLLENBQUMsTUFBTTtRQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFFdkMsT0FBTyxnRkFBZ0YsR0FBRyxVQUFVLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLFVBQVUsR0FBRyxRQUFRLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxHQUFHLFVBQVUsQ0FBQztBQUM5SyxDQUFDO0FBRUQsU0FBUyxTQUFTLENBQUMsR0FBVztJQUM1QixPQUFPLEdBQUcsQ0FBQyxPQUFPLENBQ2hCLFVBQVUsRUFDVixDQUFDLENBQUMsRUFBRSxFQUFFOztRQUNKLE9BQUEsQ0FBQyxNQUFBO1lBQ0MsR0FBRyxFQUFFLE1BQU07WUFDWCxHQUFHLEVBQUUsTUFBTTtZQUNYLEdBQUcsRUFBRSxPQUFPO1lBQ1osR0FBRyxFQUFFLFFBQVE7WUFDYixHQUFHLEVBQUUsUUFBUTtTQUNkLENBQUMsQ0FBQyxDQUFDLG1DQUFJLENBQUMsQ0FBQyxDQUFBO0tBQUEsQ0FDYixDQUFDO0FBQ0osQ0FBQztBQUVELFNBQXNCLGFBQWEsQ0FBWSxPQUFlLEVBQUUsUUFBZ0IsRUFBRSxLQUFjLEVBQUUsT0FBaUIsRUFBRSxNQUFlOztRQUNsSSxJQUFJLENBQUM7WUFDSCxJQUFJLElBQUksR0FBRyxLQUFLLENBQUM7WUFDakIsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7Z0JBQ2xCLElBQUksR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQ3ZCLENBQUM7WUFFRCxJQUFJLE1BQU0sR0FBRztnQkFDWCxJQUFJLEVBQUUsSUFBSTtnQkFDVixPQUFPLEVBQUUsUUFBUTtnQkFDakIsTUFBTSxFQUFFLE1BQU07Z0JBQ2QsT0FBTyxFQUFFLE9BQU87YUFDakIsQ0FBQztZQUNGLElBQUksTUFBTSxHQUFHLE9BQU8sQ0FBQztZQUNyQixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQkFDbEIsTUFBTSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDekIsQ0FBQztZQUNELDJCQUEyQjtZQUMzQiw2QkFBNkI7WUFFN0IsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDO1lBQ2hCLGtCQUFrQjtZQUNsQixJQUFJLEdBQUcsR0FBRyxTQUFTLENBQUM7WUFFcEIsSUFBSSxLQUFLLEdBQVEsTUFBTSxLQUFLLENBQUMsTUFBTSxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1lBRXhFLE9BQU8sS0FBSyxDQUFDO1FBQ2YsQ0FBQztRQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDWCxPQUFPLEdBQUcsQ0FBQztRQUNiLENBQUM7SUFDSCxDQUFDO0NBQUE7QUFFRCxTQUFzQixVQUFVLENBQVksT0FBZSxFQUFFLFFBQWdCLEVBQUUsS0FBYyxFQUFFLE9BQWlCLEVBQUUsTUFBZSxFQUFFLE1BQWU7O1FBQ2hKLElBQUksQ0FBQztZQUNILElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQztZQUNqQixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQkFDbEIsSUFBSSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDdkIsQ0FBQztZQUVELElBQUksTUFBTSxHQUFHO2dCQUNYLElBQUksRUFBRSxJQUFJO2dCQUNWLE9BQU8sRUFBRSxRQUFRO2dCQUNqQixNQUFNLEVBQUUsTUFBTTthQUNmLENBQUM7WUFDRixJQUFJLE1BQU0sR0FBRyxPQUFPLENBQUM7WUFDckIsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7Z0JBQ2xCLE1BQU0sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQ3pCLENBQUM7WUFFRCw2QkFBNkI7WUFDN0Isa0JBQWtCO1lBRWxCLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQztZQUNoQixJQUFJLEdBQUcsR0FBRyxPQUFPLENBQUM7WUFFbEIsSUFBSSxLQUFLLEdBQVEsTUFBTSxLQUFLLENBQUMsTUFBTSxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1lBQ3hFLElBQUksS0FBSyxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDM0IsSUFBSSxNQUFNLEtBQUssTUFBTSxFQUFFLENBQUM7b0JBQ3RCLEtBQUssQ0FBQyxPQUFPLEdBQUcsYUFBYSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztnQkFDL0MsQ0FBQztnQkFDRCxJQUFJLE1BQU0sS0FBSyxNQUFNLEVBQUUsQ0FBQztvQkFDdEIsS0FBSyxDQUFDLE9BQU8sR0FBRyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQ25ELENBQUM7Z0JBQ0QsT0FBTyxLQUFLLENBQUMsT0FBTyxDQUFDO1lBQ3ZCLENBQUM7aUJBQU0sQ0FBQztnQkFDTixPQUFPLEVBQUUsQ0FBQztZQUNaLENBQUM7UUFDSCxDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNYLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDZixPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2pCLE9BQU8sR0FBRyxDQUFDO1FBQ2IsQ0FBQztJQUNILENBQUM7Q0FBQTtBQUVELFNBQXNCLFFBQVEsQ0FBWSxNQUFjLEVBQUUsUUFBZ0I7O1FBQ3hFLElBQUksQ0FBQztZQUNILElBQUksTUFBTSxHQUFHO2dCQUNYLE9BQU8sRUFBRSxRQUFRO2FBQ2xCLENBQUM7WUFDRixJQUFJLEtBQUssR0FBRyxNQUFNLEtBQUssQ0FBQyxNQUFNLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7WUFDekUsT0FBTyxLQUFLLENBQUM7UUFDZixDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNYLE9BQU8sRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUFDLEVBQUUsQ0FBQztRQUNuQyxDQUFDO0lBQ0gsQ0FBQztDQUFBO0FBRUQsU0FBZ0IsU0FBUyxDQUFZLE1BQWMsRUFBRSxNQUFXO0lBQzlELFVBQVUsQ0FBQyxHQUFTLEVBQUU7UUFDcEIsSUFBSSxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsRUFBRSxDQUFDO1lBQ3pDLElBQUksQ0FBQztnQkFDSCxJQUFJLEtBQUssR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDbkMsSUFBSSxDQUFDLEdBQUc7b0JBQ04sS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUM7b0JBQ2YsR0FBRyxFQUFFLE1BQU0sQ0FBQyxJQUFJO2lCQUNqQixDQUFDO2dCQUNGLE1BQU0sS0FBSyxDQUFDLE1BQU0sRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsc0JBQXNCLENBQUMsQ0FBQztnQkFDaEYsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDWCxPQUFPLEtBQUssQ0FBQztZQUNmLENBQUM7UUFDSCxDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksQ0FBQztnQkFDSCxNQUFNLEtBQUssQ0FBQyxNQUFNLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7Z0JBQzdELE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztZQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQ1gsT0FBTyxLQUFLLENBQUM7WUFDZixDQUFDO1FBQ0gsQ0FBQztJQUNILENBQUMsQ0FBQSxFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQ1IsQ0FBQztBQUVELFNBQWdCLFlBQVksQ0FBWSxPQUFlLEVBQUUsaUJBQXlCLEVBQUUsV0FBZ0IsRUFBRSxLQUFVLEVBQUUsSUFBUyxFQUFFLElBQWE7SUFDeEksT0FBTyxDQUFDLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxXQUFXLEVBQUUsSUFBSSxFQUFFLEtBQUssRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDNUUsQ0FBQztBQUVELFNBQWdCLFlBQVksQ0FBWSxPQUFlLEVBQUUsaUJBQXlCLEVBQUUsV0FBZ0IsRUFBRSxNQUFXLEVBQUUsS0FBVSxFQUFFLElBQVMsRUFBRSxJQUFhO0lBQ3JKLE9BQU8sQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsV0FBVyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDeEUsQ0FBQztBQUVELFNBQXNCLE1BQU0sQ0FBWSxPQUFlLEVBQUUsS0FBYSxFQUFFLEtBQWEsRUFBRSxJQUFZLEVBQUUsSUFBYTs7UUFDaEgsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyw0QkFBNEIsRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMxRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztZQXNCSTtRQUNKLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUFBO0FBRUQsU0FBc0IsV0FBVyxDQUFZLEdBQXNCOztRQUNqRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ3hCLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2QsQ0FBQztRQUNELElBQUksS0FBSyxHQUFhLEVBQUUsQ0FBQztRQUV6QixJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUNyQixLQUFLLElBQUksQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDO2dCQUNsQixJQUFJLElBQUksR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQzdCLElBQUksU0FBUyxLQUFLLEdBQUcsRUFBRSxDQUFDO29CQUN0QixLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNoQixDQUFDO3FCQUFNLElBQUksU0FBUyxLQUFLLFdBQVcsRUFBRSxDQUFDO29CQUNyQyxJQUFJLE1BQU0sR0FBRyxJQUFJLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDbkMsS0FBSyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDckIsQ0FBQztxQkFBTSxJQUFJLFNBQVMsSUFBSSxJQUFJLENBQUMsV0FBVyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksSUFBSSxFQUFFLENBQUM7b0JBQzlILElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO29CQUNyRSxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUNyQixDQUFDO1lBQ0gsQ0FBQztRQUNILENBQUM7YUFBTSxDQUFDO1lBQ04sS0FBSyxHQUFHLEdBQUcsQ0FBQztRQUNkLENBQUM7UUFFRCxJQUFJLElBQUksR0FBRyxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFakMsSUFBSSxHQUFHLEdBQUcsU0FBUyxDQUFDO1FBQ3BCLEdBQUcsR0FBRyxHQUFHLEdBQUcsYUFBYSxDQUFDO1FBRTFCLElBQUksUUFBUSxHQUFHLEVBQUUsQ0FBQztRQUNsQixLQUFLLE1BQU0sR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDO1lBQ3ZCLElBQUksUUFBUSxFQUFFLENBQUM7Z0JBQ2IsUUFBUSxHQUFHLFFBQVEsR0FBRyxHQUFHLENBQUM7WUFDNUIsQ0FBQztZQUNELFFBQVEsR0FBRyxRQUFRLEdBQUcsU0FBUyxHQUFHLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzVELENBQUM7UUFDRCxHQUFHLEdBQUcsR0FBRyxHQUFHLFFBQVEsR0FBRyxLQUFLLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUVwRCxJQUFJLEdBQUcsR0FBUSxJQUFJLENBQUM7UUFDcEIsSUFBSSxDQUFDO1lBQ0gsSUFBSSxNQUFNLEdBQVE7Z0JBQ2hCLE1BQU0sRUFBRSxLQUFLO2dCQUNiLFFBQVEsRUFBRSxXQUFXO2dCQUNyQixJQUFJLEVBQUUsR0FBRztnQkFDVCxJQUFJLEVBQUUsSUFBSTtnQkFDVixlQUFlO2dCQUNmLE9BQU8sRUFBRTtvQkFDUCx1Q0FBdUM7b0JBQ3ZDLFlBQVksRUFBRSxJQUFJLENBQUMsUUFBUTtvQkFDM0IsTUFBTSxFQUFFLGFBQWE7aUJBQ3RCO2FBQ0YsQ0FBQztZQUVGLElBQUksQ0FBQztnQkFDSCxHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDM0IsQ0FBQztZQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQ1gsSUFBSSxDQUFDO29CQUNILE1BQU0sS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO29CQUNqQixHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7Z0JBQzNCLENBQUM7Z0JBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztvQkFDWCxPQUFPLElBQUksQ0FBQztnQkFDZCxDQUFDO1lBQ0gsQ0FBQztZQUVELElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxJQUFJLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDbkUsTUFBTSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ2pCLEdBQUcsR0FBRyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUMzQixDQUFDO1lBRUQsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNLEtBQUssR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDO2dCQUNuRSxNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDakIsR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQzNCLENBQUM7UUFDSCxDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFBLENBQUM7UUFDZCxxRUFBcUU7UUFDckUsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ3BCLElBQUksRUFBRSxHQUFHLGVBQWUsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzFDLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO2dCQUNyQixzQ0FBc0M7Z0JBQ3RDLElBQUksWUFBWSxHQUFRLEVBQUUsQ0FBQztnQkFDM0IsS0FBSyxJQUFJLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQztvQkFDakIsSUFBSSxJQUFJLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDeEIsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO29CQUM3QixJQUFJLFNBQVMsSUFBSSxJQUFJLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUM7d0JBQzNGLElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO3dCQUNuRSxZQUFZLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUMvQixDQUFDO3lCQUFNLElBQUksU0FBUyxJQUFJLEdBQUcsRUFBRSxDQUFDO3dCQUM1QixJQUFJLE1BQU0sR0FBRyxXQUFXLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ2hELFlBQVksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQy9CLENBQUM7Z0JBQ0gsQ0FBQztnQkFFRCxJQUFJLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztvQkFDbkIsS0FBSyxJQUFJLEdBQUcsSUFBSSxZQUFZLEVBQUUsQ0FBQzt3QkFDN0IsSUFBSSxLQUFLLEdBQUcsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO3dCQUM5QixJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQzs0QkFDL0MsT0FBTyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7d0JBQ2xCLENBQUM7NkJBQU0sQ0FBQzs0QkFDTixPQUFPLEtBQUssQ0FBQzt3QkFDZixDQUFDO29CQUNILENBQUM7Z0JBQ0gsQ0FBQztxQkFBTSxDQUFDO29CQUNOLE9BQU8sWUFBWSxDQUFDO2dCQUN0QixDQUFDO1lBQ0gsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO29CQUNuQixLQUFLLElBQUksR0FBRyxJQUFJLEVBQUUsRUFBRSxDQUFDO3dCQUNuQixJQUFJLEtBQUssR0FBRyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7d0JBQ3BCLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRSxDQUFDOzRCQUMvQyxPQUFPLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQzt3QkFDbEIsQ0FBQzs2QkFBTSxDQUFDOzRCQUNOLE9BQU8sS0FBSyxDQUFDO3dCQUNmLENBQUM7b0JBQ0gsQ0FBQztnQkFDSCxDQUFDO3FCQUFNLENBQUM7b0JBQ04sT0FBTyxFQUFFLENBQUM7Z0JBQ1osQ0FBQztZQUNILENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsU0FBUyxJQUFJLEdBQUcsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUMvQixLQUFLLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxJQUFJLEVBQUUsQ0FBQztnQkFDekIsSUFBSSxDQUFDO29CQUNILElBQUksS0FBSyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDO29CQUNoQyxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQzt3QkFDL0MsT0FBTyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ2xCLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixPQUFPLEtBQUssQ0FBQztvQkFDZixDQUFDO2dCQUNILENBQUM7Z0JBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztvQkFDWCxPQUFPLElBQUksQ0FBQztnQkFDZCxDQUFDO1lBQ0gsQ0FBQztRQUNILENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxHQUFHLENBQUM7UUFDYixDQUFDO1FBRUQsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0NBQUE7QUFFRCxTQUNTLEtBQUssQ0FBQyxFQUFVO0lBQ3ZCLE9BQU8sSUFBSSxPQUFPLENBQUMsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQztBQUMzRCxDQUFDO0FBRUQsU0FBc0IsWUFBWSxDQUVoQyxJQUFZLEVBQ1osSUFBWSxFQUNaLE1BQWMsRUFDZCxJQUFhLEVBQ2IsVUFBbUIsRUFDbkIsSUFBYSxFQUNiLEtBQWMsRUFDZCxPQUFnQixFQUNoQixPQUFrQjs7UUFFbEIsSUFBSSxLQUFLLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUNqQyxJQUFJLEdBQUcsR0FBRyxTQUFTLENBQUM7UUFDcEIsR0FBRyxHQUFHLEdBQUcsR0FBRyxpQkFBaUIsR0FBRyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUV6RCxJQUFJLElBQUksRUFBRSxDQUFDO1lBQ1QsSUFBSSxJQUFJLEtBQUssa0JBQWtCLEVBQUUsQ0FBQztnQkFDaEMsR0FBRyxHQUFHLEdBQUcsR0FBRyxRQUFRLEdBQUcsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7WUFDeEQsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLEdBQUcsR0FBRyxHQUFHLEdBQUcsUUFBUSxHQUFHLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO1lBQ2xELENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUNULEdBQUcsR0FBRyxHQUFHLEdBQUcsUUFBUSxHQUFHLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ2xELENBQUM7UUFFRCxJQUFJLE1BQU0sRUFBRSxDQUFDO1lBQ1gsSUFBSSxJQUFJLEdBQUcsRUFBRSxDQUFDO1lBQ2QsSUFBSSxLQUFLLEdBQUcsQ0FBQyxDQUFDO1lBQ2QsS0FBSyxNQUFNLENBQUMsSUFBSSxNQUFNLEVBQUUsQ0FBQztnQkFDdkIsS0FBSyxFQUFFLENBQUM7Z0JBQ1IsSUFBSSxJQUFJLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRSxDQUFDO29CQUN0QixJQUFJLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDM0IsQ0FBQztxQkFBTSxDQUFDO29CQUNOLElBQUksS0FBSyxLQUFLLENBQUMsRUFBRSxDQUFDO3dCQUNoQixJQUFJLEdBQUcsV0FBVyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ3pDLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixJQUFJLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDM0IsQ0FBQztnQkFDSCxDQUFDO2dCQUNELEdBQUcsR0FBRyxHQUFHLEdBQUcsZ0JBQWdCLEdBQUcsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDMUQsQ0FBQztRQUNILENBQUM7UUFFRCxJQUFJLE9BQU8sRUFBRSxDQUFDO1lBQ1osS0FBSyxNQUFNLEdBQUcsSUFBSSxPQUFPLEVBQUUsQ0FBQztnQkFDMUIsR0FBRyxHQUFHLEdBQUcsR0FBRyxpQkFBaUIsR0FBRyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUMxRCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksS0FBSyxFQUFFLENBQUM7WUFDVixHQUFHLEdBQUcsR0FBRyxHQUFHLFNBQVMsR0FBRyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNwRCxDQUFDO1FBRUQsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLEdBQUcsR0FBRyxHQUFHLEdBQUcsV0FBVyxHQUFHLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hELENBQUM7UUFFRCxJQUFJLFVBQVUsRUFBRSxDQUFDO1lBQ2YsR0FBRyxHQUFHLEdBQUcsR0FBRyxjQUFjLEdBQUcsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDOUQsQ0FBQztRQUVELElBQUksSUFBSSxFQUFFLENBQUM7WUFDVCxHQUFHLEdBQUcsR0FBRyxHQUFHLFFBQVEsR0FBRyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNsRCxDQUFDO1FBRUQsSUFBSSxNQUFNLEdBQVE7WUFDaEIsTUFBTSxFQUFFLEtBQUs7WUFDYixRQUFRLEVBQUUsV0FBVztZQUNyQixJQUFJLEVBQUUsR0FBRztZQUNULElBQUksRUFBRSxJQUFJO1lBQ1YsZUFBZTtZQUNmLE9BQU8sRUFBRTtnQkFDUCx1Q0FBdUM7Z0JBQ3ZDLFlBQVksRUFBRSxJQUFJLENBQUMsUUFBUTtnQkFDM0IsTUFBTSxFQUFFLGFBQWE7YUFDdEI7U0FDRixDQUFDO1FBRUYsSUFBSSxHQUFHLEdBQVEsSUFBSSxDQUFDO1FBRXBCLElBQUksQ0FBQztZQUNILEdBQUcsR0FBRyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUMzQixDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNYLElBQUksQ0FBQztnQkFDSCxNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDakIsR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQzNCLENBQUM7WUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO2dCQUNYLE9BQU8sRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxTQUFTLEVBQUUsQ0FBQztZQUMzQyxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUNwQixPQUFPLEdBQUcsQ0FBQyxJQUFJLENBQUM7UUFDbEIsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsU0FBUyxFQUFFLENBQUM7UUFDM0MsQ0FBQztJQUNILENBQUM7Q0FBQTtBQUVELFNBQWdCLGdCQUFnQixDQUFDLElBQVksRUFBRSxJQUFTLEVBQUUsTUFBZTtJQUN2RSxJQUFJLElBQUksSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUNqQixJQUFJLE1BQU0sRUFBRSxDQUFDO1lBQ1gsT0FBTyxNQUFNLENBQUM7UUFDaEIsQ0FBQztRQUNELE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUVELElBQUksT0FBTyxJQUFJLEtBQUssUUFBUSxFQUFFLENBQUM7UUFDN0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3ZCLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNYLEtBQUssR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDckIsQ0FBQztJQUNELElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNYLElBQUksS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDOUIsSUFBSSxLQUFLLElBQUksS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUM5QixLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3pCLENBQUM7SUFDSCxDQUFDO0lBRUQsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ1gsSUFBSSxNQUFNLEVBQUUsQ0FBQztZQUNYLE9BQU8sTUFBTSxDQUFDO1FBQ2hCLENBQUM7UUFDRCxLQUFLLEdBQUcsRUFBRSxDQUFDO0lBQ2IsQ0FBQztJQUNELE9BQU8sS0FBSyxDQUFDO0FBQ2YsQ0FBQyJ9