"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
module.exports = function (historeadService) {
    let operations = {
        GET,
        POST,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let result = yield historeadService.getSchedules(req.prefix, req.query);
            res.status(200).json(result);
        });
    }
    function POST(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let result = { err: true };
            result = yield historeadService.scheduleChange(req.prefix, req.body);
            res.status(200).json(result);
        });
    }
    POST.apiDoc = {
        tags: ["Schedule Data"],
        summary: "Set schedule data",
        operationId: "scheduleChange",
        requestBody: {
            required: true,
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                    },
                },
            },
        },
        responses: {
            200: {
                description: "Schedule data",
                content: {
                    "application/json": {
                        schema: {
                            type: "object",
                            properties: {},
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    GET.apiDoc = {
        tags: ["Schedule Data"],
        summary: "Get schedule data.",
        operationId: "getScheduleData",
        parameters: [
            {
                name: "name",
                in: "query",
                description: "Name of scheduler",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "from",
                in: "query",
                description: "Start datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: false,
                schema: {
                    type: "string",
                    format: "date-time", //2017-07-21T17:32:28Z
                },
            },
            {
                name: "to",
                in: "query",
                description: "End datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: false,
                schema: {
                    type: "string",
                    format: "date-time",
                },
            },
            {
                name: "limit",
                in: "query",
                description: "Limit number of records",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
        ],
        responses: {
            200: {
                description: "Array of historical data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "array",
                            items: {
                                $ref: "#/components/schemas/HistoricalData",
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map