"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
module.exports = function (historeadService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let result = yield historeadService.getHistoricalLogs(req.prefix, req.query);
            res.status(200).json(result);
        });
    }
    GET.apiDoc = {
        tags: ["Historical Data"],
        summary: "Get historical data.",
        operationId: "getHistoricalLogs",
        parameters: [
            {
                name: "from",
                in: "query",
                description: "Start datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: true,
                schema: {
                    type: "string",
                    format: "date-time", //2017-07-21T17:32:28Z
                },
            },
            {
                name: "to",
                in: "query",
                description: "End datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: true,
                schema: {
                    type: "string",
                    format: "date-time",
                },
            },
            {
                name: "limit",
                in: "query",
                description: "Limit number of records",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
            {
                name: "modules",
                in: "query",
                description: "Module names eg. histoLog, interfaceModule ]",
                required: false,
                schema: {
                    type: "array",
                    items: {
                        type: "string",
                    },
                    minItems: 1,
                },
            },
            {
                name: "severity",
                in: "query",
                description: "Severity eg. error,warning,info]",
                required: false,
                schema: {
                    type: "array",
                    items: {
                        type: "string",
                    },
                    minItems: 1,
                },
            },
            {
                name: "txtFilter",
                in: "query",
                description: "Text Filter",
                required: false,
                schema: {
                    type: "string",
                },
            },
        ],
        responses: {
            200: {
                description: "Array of historical data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "array",
                            items: {
                                $ref: "#/components/schemas/HistoricalData",
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map