"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
module.exports = function (historeadService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let result = yield historeadService.getHistoricalData(req.prefix, req.query);
            res.status(200).json(result);
        });
    }
    GET.apiDoc = {
        tags: ["Historical Data"],
        summary: "Get historical data.",
        operationId: "getHistoricalData",
        parameters: [
            {
                name: "tags",
                in: "query",
                description: "Tag names eg. 1.tag1,1.tag2]",
                required: true,
                schema: {
                    type: "array",
                    items: {
                        type: "string",
                    },
                    minItems: 1,
                },
            },
            {
                name: "from",
                in: "query",
                description: "Start datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: true,
                schema: {
                    type: "string",
                    format: "date-time", //2017-07-21T17:32:28Z
                },
            },
            {
                name: "to",
                in: "query",
                description: "End datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: true,
                schema: {
                    type: "string",
                    format: "date-time",
                },
            },
            {
                name: "limit",
                in: "query",
                description: "Limit number of records",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
            {
                name: "groupBy",
                in: "query",
                description: "If specified data will be grouped by time",
                required: false,
                schema: {
                    type: "string",
                    enum: ["minutes", "hours", "days"],
                },
            },
            {
                name: "groupByValue",
                in: "query",
                description: "Multiple for group by parameter.",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
            {
                name: "customGroupBy[]",
                in: "query",
                description: "Custom time grouping. Specify in tuples in the form from, to. Example: [{from:'6:00',to:'12:30'},{from:'13:00',to:'17:00'}]",
                required: false,
                schema: {
                    type: "array",
                    items: {
                        type: "object",
                        properties: {
                            from: {
                                type: "string",
                                pattern: "^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$",
                            },
                            to: {
                                type: "string",
                                pattern: "^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$",
                            },
                        },
                    },
                },
            },
            {
                name: "timeOffset",
                in: "query",
                description: "Time offset for customGroupBy parameter in minutes. Example for UTC+2 set 120.",
                required: false,
                schema: {
                    type: "integer",
                },
            },
            {
                name: "densify",
                in: "query",
                description: "Densify data for uniform spacing. Eg. if you aggregate by each minute, you will get data each minunte without spaces.",
                required: false,
                schema: {
                    type: "boolean",
                },
            },
            {
                name: "fillStartValue",
                in: "query",
                description: "Add value to the end of interval.",
                required: false,
                schema: {
                    type: "boolean",
                },
            },
            {
                name: "fillEndValue",
                in: "query",
                description: "Add value to the end of interval.",
                required: false,
                schema: {
                    type: "boolean",
                },
            },
            {
                name: "formatValuesLanguage",
                in: "query",
                description: "Provide language to format values based  tag definition - format.",
                required: false,
                schema: {
                    type: "string",
                },
            },
            {
                name: "tfFormat",
                in: "query",
                description: "Format Date based on provided format.",
                required: false,
                schema: {
                    type: "string",
                },
            },
        ],
        responses: {
            200: {
                description: "Array of historical data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "array",
                            items: {
                                $ref: "#/components/schemas/HistoricalData",
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map