"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
module.exports = function (codetablesMongoService, codetablesMSSqlService, getUserIdAndName) {
    let operations = {
        GET,
        POST,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            if (globalThis.configCodetables && globalThis.configCodetables.mssql) {
                let data = yield codetablesMSSqlService.getCodetableData(req.prefix, req.query.name, req.query.view, req.query.filter, req.query.type, req.query.returnType, req.query.lang, req.query.limit, req.query.orderBy, req.query.columns);
                res.status(200).json(data);
            }
            else {
                let data = yield codetablesMongoService.getCodetableData(req.prefix, req.query.name, req.query.view, req.query.filter, req.query.type, req.query.returnType, req.query.lang, req.query.limit, req.query.orderBy, req.query.columns);
                res.status(200).json(data);
            }
        });
    }
    function POST(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            if (globalThis.configCodetables && globalThis.configCodetables.mssql) {
                if (req.body && req.body.checkDelete !== undefined) {
                    let result = yield codetablesMSSqlService.canDeleteRows(req.prefix, req.body.name, req.body.checkDelete);
                    res.status(200).json(result);
                }
                else {
                    let user = getUserIdAndName(req);
                    let result = yield codetablesMSSqlService.changeCodeTableData(req.prefix, req.body, user);
                    res.status(200).json(result);
                }
            }
            else {
                if (req.body && req.body.checkDelete !== undefined) {
                    let result = yield codetablesMongoService.canDeleteRows(req.prefix, req.body.name, req.body.checkDelete);
                    res.status(200).json(result);
                }
                else {
                    let result = yield codetablesMongoService.changeCodeTableData(req.prefix, req.body);
                    res.status(200).json(result);
                }
            }
        });
    }
    GET.apiDoc = {
        tags: ["Frontend Codetables"],
        summary: "Get codetable data.",
        operationId: "getCodetableData",
        parameters: [
            {
                name: "name",
                in: "query",
                description: "Name of the codetable",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "view",
                in: "query",
                description: "Name of the codetable view",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "columns[]",
                in: "query",
                description: "Columns to return.",
                required: false,
                schema: {
                    type: "array",
                    items: {
                        type: "string",
                    },
                },
            },
            {
                name: "limit",
                in: "query",
                description: "Limit number of records",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
            {
                name: "type",
                in: "query",
                description: "Show deleted records",
                required: false,
                schema: {
                    type: "string",
                    enum: ["deleted", "all", "notdeleted"],
                },
            },
            {
                name: "filter[]",
                in: "query",
                description: "Filter for items. Specify in triple in the form key, type, value",
                required: false,
                schema: {
                    type: "array",
                    items: {
                        type: "object",
                        properties: {
                            key: {
                                type: "string",
                            },
                            type: {
                                type: "string",
                            },
                            value: {
                                type: "string",
                            },
                        },
                    },
                },
            },
            {
                name: "returnType",
                in: "query",
                description: "Return data as object, simple object, flat or csv table",
                required: false,
                schema: {
                    type: "string",
                },
            },
            {
                name: "lang",
                in: "query",
                description: "Language for csv data export",
                required: false,
                schema: {
                    type: "string",
                },
            },
        ],
        responses: {
            200: {
                description: "Array of historical data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "array",
                            items: {
                                $ref: "#/components/schemas/CodeTableArray",
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    POST.apiDoc = {
        tags: ["Frontend Codetables"],
        summary: "Set code table data",
        operationId: "changeCodeTableData",
        requestBody: {
            required: true,
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            name: {
                                type: "string",
                            },
                            insert: {
                                type: "array",
                                items: {
                                    type: "object",
                                },
                            },
                            update: {
                                type: "array",
                                items: {
                                    type: "object",
                                },
                            },
                            delete: {
                                type: "array",
                                items: {
                                    oneOf: [{ type: "string" }, { type: "number" }],
                                },
                            },
                            undelete: {
                                type: "array",
                                items: {
                                    oneOf: [{ type: "string" }, { type: "number" }],
                                },
                            },
                            checkDelete: {
                                type: "array",
                                items: {
                                    oneOf: [{ type: "string" }, { type: "number" }],
                                },
                            },
                            trash: {
                                type: "boolean",
                            },
                        },
                        required: ["name"],
                    },
                },
            },
        },
        responses: {
            200: {
                description: "Array of live data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "array",
                            items: {
                                $ref: "#/components/schemas/CodeTableArray",
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map