"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
module.exports = function (liveDataService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let prefix = req.prefix.replace("_", "");
            let result = yield liveDataService.aiChat(prefix, req.query);
            if (result.err) {
                if (result.msg == "Timeout")
                    res.status(408).json(result);
                else
                    res.status(400).json(result);
            }
            else
                res.status(200).json(result);
        });
    }
    GET.apiDoc = {
        tags: ["AI"],
        summary: "AI Chat",
        operationId: "aiChat",
        parameters: [
            {
                name: "message",
                in: "query",
                description: "Message to AI",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "lang",
                in: "query",
                description: "Language",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "chatid",
                in: "query",
                description: "AI chat ID",
                required: false,
                schema: {
                    type: "string",
                },
            },
        ],
        responses: {
            200: {
                description: "AI Chat response",
                content: {
                    "application/json": {
                        schema: {
                            type: "object",
                            items: {
                                $ref: "#/components/schemas/AiResult",
                            },
                        },
                        example: {
                            err: false,
                            message: "Currently, there are no active or confirmed alarms. All previous alarms have been resolved (Clr, U). The system is in normal operational status with no current issues.",
                            sources: [
                                {
                                    source: "CURRENT DATE",
                                    loaderId: undefined,
                                },
                                {
                                    source: "LIVE ALARMS SUMMARY",
                                    loaderId: undefined,
                                },
                                {
                                    source: "LIVE ALARMS",
                                    loaderId: undefined,
                                },
                            ],
                        },
                    },
                },
            },
            408: {
                description: "Timeout occured",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "Timeout",
                        },
                    },
                },
            },
            400: {
                description: "Error occured",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "Error Message",
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map