/* eslint-disable no-console, camelcase, no-unused-vars */
import { strict as assert } from "assert";
import * as querystring from "querystring";
import { inspect } from "util";
import isEmpty from "lodash/isEmpty.js";
//import { urlencoded } from "express"; // eslint-disable-line import/no-unresolved
import { urlencoded } from "express";
import Account from "./accountExpress.js";
import * as errors from "./errors.js";
import * as bcrypt from "bcrypt";
//import { errors } from '../../lib/index.js'; // from 'oidc-provider';
const body = urlencoded({ extended: false });
const keys = new Set();
const debug = (obj) => querystring.stringify(Object.entries(obj).reduce((acc, [key, value]) => {
    keys.add(key);
    if (isEmpty(value))
        return acc;
    acc[key] = inspect(value, { depth: null });
    return acc;
}, {}), "<br/>", ": ", {
    encodeURIComponent(value) {
        return keys.has(value) ? `<strong>${value}</strong>` : value;
    },
});
const { SessionNotFound } = errors;
export default (app, provider) => {
    app.use((req, res, next) => {
        const orig = res.render;
        // you'll probably want to use a full blown render engine capable of layouts
        res.render = (view, locals) => {
            app.render(view, locals, (err, html) => {
                if (typeof locals === "object" && locals !== null && "params" in locals) {
                    const params = locals.params;
                    //nacteni prefixu z redirect uri
                    const match = params.redirect_uri.match(/.+:\/\/[^\/]+\/([^\/]+)\//);
                    if (match) {
                        let prefix = match[1];
                        html = html.replace(/\/interaction\//g, "/" + prefix + "/interaction/");
                    }
                }
                if (err)
                    throw err;
                orig.call(res, "_layout", {
                    ...locals,
                    body: html,
                });
            });
        };
        next();
    });
    function setNoCache(req, res, next) {
        res.set("cache-control", "no-store");
        next();
    }
    app.get("/callback", setNoCache, async (req, res, next) => {
        try {
            let code = req.originalUrl.split("?");
            let code2 = code[1].split("=");
            let code3 = code2[1].split("&")[0];
            let html = " <html>" +
                "<head></head>" +
                "<body>" +
                "<script>" +
                'window.addEventListener("message", function (event) {' +
                'if (event.data.message === "requestResult") {' +
                'event.source.postMessage({"message": "deliverResult", result: {code:"' + //tady se vklada authorization code
                code3 +
                '"} }, "*");' +
                "}" +
                "});" +
                "</script>" +
                "</body>" +
                "</html>";
            res.type("html");
            res.send(html);
        }
        catch (err) {
            return next(err);
        }
    });
    app.get("/logout", setNoCache, async (req, res, next) => {
        const oidcContext = provider.app.createContext(req, res);
        const session = await provider.Session.get(oidcContext);
        await session.destroy();
        res.redirect("/");
    });
    app.get("/interaction/:uid", setNoCache, async (req, res, next) => {
        try {
            const { uid, prompt, params, session } = await provider.interactionDetails(req, res);
            const client = await provider.Client.find(params.client_id);
            switch (prompt.name) {
                case "login": {
                    return res.render("login", {
                        client,
                        uid,
                        details: prompt.details,
                        params,
                        title: "Sign-in",
                        session: session ? debug(session) : undefined,
                        dbg: {
                            params: debug(params),
                            prompt: debug(prompt),
                        },
                    });
                }
                case "consent": {
                    return res.render("interaction", {
                        client,
                        uid,
                        details: prompt.details,
                        params,
                        title: "Authorize",
                        session: session ? debug(session) : undefined,
                        dbg: {
                            params: debug(params),
                            prompt: debug(prompt),
                        },
                    });
                }
                default:
                    return undefined;
            }
        }
        catch (err) {
            return next(err);
        }
    });
    app.post("/interaction/:uid/login", setNoCache, body, async (req, res, next) => {
        try {
            const { prompt: { name }, } = await provider.interactionDetails(req, res);
            assert.equal(name, "login");
            const account = await Account.findByLogin(req.body.login);
            let result = {
                login: {
                    accountId: account.accountId,
                },
            };
            let username = req.body.login;
            let pwdPlain = req.body.password;
            let ok = false;
            let obj = app;
            if (obj.__users && username && pwdPlain) {
                for (const user of obj.__users) {
                    if (user.name === username) {
                        let valid = await bcrypt.compare(pwdPlain, user.password);
                        if (valid) {
                            ok = true;
                            //TODO doplnit grupy/ pristup k designeru
                        }
                        break;
                    }
                }
            }
            if (!ok) {
                result = {
                    error: "access_denied",
                    error_description: "Insufficient permissions: scope out of reach for this Account",
                };
            }
            await provider.interactionFinished(req, res, result, { mergeWithLastSubmission: false });
        }
        catch (err) {
            next(err);
        }
    });
    app.post("/interaction/:uid/confirm", setNoCache, body, async (req, res, next) => {
        try {
            const interactionDetails = await provider.interactionDetails(req, res);
            const { prompt: { name, details }, params, session: { accountId }, } = interactionDetails;
            assert.equal(name, "consent");
            let { grantId } = interactionDetails;
            let grant;
            if (grantId) {
                // we'll be modifying existing grant in existing session
                grant = await provider.Grant.find(grantId);
            }
            else {
                // we're establishing a new grant
                grant = new provider.Grant({
                    accountId,
                    clientId: params.client_id,
                });
            }
            if (details.missingOIDCScope) {
                grant.addOIDCScope(details.missingOIDCScope.join(" "));
            }
            if (details.missingOIDCClaims) {
                grant.addOIDCClaims(details.missingOIDCClaims);
            }
            if (details.missingResourceScopes) {
                for (const [indicator, scopes] of Object.entries(details.missingResourceScopes)) {
                    if (Array.isArray(scopes))
                        grant.addResourceScope(indicator, scopes.join(" "));
                }
            }
            grantId = await grant.save();
            const consent = {};
            if (!interactionDetails.grantId) {
                // we don't have to pass grantId to consent, we're just modifying existing one
                consent.grantId = grantId;
            }
            const result = { consent };
            await provider.interactionFinished(req, res, result, { mergeWithLastSubmission: true });
        }
        catch (err) {
            next(err);
        }
    });
    app.get("/interaction/:uid/abort", setNoCache, async (req, res, next) => {
        try {
            const result = {
                error: "access_denied",
                error_description: "End-User aborted interaction",
            };
            await provider.interactionFinished(req, res, result, { mergeWithLastSubmission: false });
        }
        catch (err) {
            next(err);
        }
    });
    app.use((err, req, res, next) => {
        if (err instanceof SessionNotFound) {
            // handle interaction expired / session not found error
        }
        next(err);
    });
};
