"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_INSERT_BATCH_SIZE = void 0;
exports.cleanString = cleanString;
exports.truncateCenterString = truncateCenterString;
exports.isValidURL = isValidURL;
exports.getSafe = getSafe;
exports.streamToBuffer = streamToBuffer;
exports.getUnique = getUnique;
exports.estimateTokens = estimateTokens;
const llama_tokenizer_js_1 = __importDefault(require("llama-tokenizer-js"));
exports.DEFAULT_INSERT_BATCH_SIZE = 500;
function cleanString(text) {
    text = text.replace(/\\/g, "");
    text = text.replace(/#/g, " ");
    text = text.replace(/\. \./g, ".");
    text = text.replace(/\s\s+/g, " ");
    text = text.replace(/(\r\n|\n|\r)/gm, " ");
    return text.trim();
}
function truncateCenterString(fullStr, strLen, separator) {
    if (fullStr.length <= strLen)
        return fullStr;
    separator = separator || "...";
    const sepLen = separator.length, charsToShow = strLen - sepLen, frontChars = Math.ceil(charsToShow / 2), backChars = Math.floor(charsToShow / 2);
    return fullStr.substr(0, frontChars) + separator + fullStr.substr(fullStr.length - backChars);
}
function isValidURL(candidateUrl) {
    try {
        const url = new URL(candidateUrl);
        return url.protocol === "http:" || url.protocol === "https:";
    }
    catch {
        return false;
    }
}
const DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36";
async function getSafe(url, options) {
    const headers = options?.headers ?? {};
    headers["User-Agent"] = headers["User-Agent"] ?? DEFAULT_USER_AGENT;
    const format = options?.format ?? "stream";
    const response = await fetch(url, { headers });
    //createDebugMessages("embedjs:util:getSafe")(`URL '${url}' returned status code ${response.status}`);
    if (response.status !== 200)
        throw new Error(`Failed to fetch URL '${url}'. Got status code ${response.status}.`);
    return {
        body: format === "text" ? await response.text() : format === "buffer" ? Buffer.from(await response.arrayBuffer()) : response.body,
        statusCode: response.status,
        headers: response.headers,
    };
}
async function streamToBuffer(stream) {
    return new Promise((resolve, reject) => {
        const _buf = Array();
        stream.on("data", (chunk) => _buf.push(chunk));
        stream.on("end", () => resolve(Buffer.concat(_buf)));
        stream.on("error", (err) => reject(`error converting stream - ${err}`));
    });
}
function getUnique(array, K) {
    const seen = {};
    return array.filter(function (item) {
        return Object.prototype.hasOwnProperty.call(seen, item[K]()) ? false : (seen[item[K]()] = true);
    });
}
function estimateTokens(text, type) {
    if (type === "ollama") {
        return llama_tokenizer_js_1.default.encode(text).length;
    }
    else {
        return Math.round(text.length / 3);
    }
}
