"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ollama = void 0;
const debug_1 = __importDefault(require("debug"));
const ollama_1 = require("@langchain/ollama");
const base_model_1 = require("../../interfaces/base-model");
class Ollama extends base_model_1.BaseModel {
    //  private model: ChatOllama;
    constructor({ baseUrl, temperature, modelName, numCtx }) {
        super(temperature);
        this.debug = (0, debug_1.default)("embedjs:model:Ollama");
        this.llm = new ollama_1.ChatOllama({
            model: modelName ?? "llama2",
            baseUrl: baseUrl ?? "http://localhost:11434",
            keepAlive: "6h",
            numCtx: numCtx ? numCtx : 2048,
        });
    }
    async runQuery(messages, callback) {
        // messages = [messages[messages.length - 1]];
        this.debug(`Executing ollama model ${this.llm} with prompt -`, messages[messages.length - 1].content);
        if (callback) {
            const stream = await this.llm.stream(messages);
            const chunks = [];
            for await (const chunk of stream) {
                chunks.push(chunk.content);
                callback(chunk.content);
            }
            let res = chunks.join("");
            return {
                result: res,
            };
        }
        else {
            const result = await this.llm.invoke(messages);
            this.debug("Ollama response -", result);
            return {
                result: result.toString(),
            };
        }
    }
}
exports.Ollama = Ollama;
