"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OllamaEmbeddings = void 0;
const ollama_1 = require("@langchain/ollama");
const base_embeddings_1 = require("../../interfaces/base-embeddings");
class OllamaEmbeddings extends base_embeddings_1.BaseEmbeddings {
    constructor(options) {
        super();
        this.model = new ollama_1.OllamaEmbeddings({
            model: options.model,
            baseUrl: options.baseUrl,
            keepAlive: options?.keepAlive,
            requestOptions: options?.requestOptions,
        });
    }
    async getDimensions() {
        const sample = await this.model.embedDocuments(["sample"]);
        return sample[0].length;
    }
    async embedDocuments(texts) {
        return this.model.embedDocuments(texts);
    }
    async embedQuery(text) {
        return this.model.embedQuery(text);
    }
}
exports.OllamaEmbeddings = OllamaEmbeddings;
