"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLazySummaryContext = createLazySummaryContext;
const messages_1 = require("@langchain/core/messages");
const rag_tools_1 = require("./rag-tools");
function normalizeContent(content) {
    if (typeof content === "string")
        return content;
    if (Array.isArray(content)) {
        return content
            .map((part) => {
            if (typeof part === "string")
                return part;
            if (typeof part === "object" && "text" in part && typeof part.text === "string") {
                return part.text;
            }
            return "";
        })
            .join("");
    }
    return "";
}
function estimateMessagesTokens(messages, llmType) {
    return messages.reduce((sum, m) => {
        const content = normalizeContent(m.content);
        return sum + (0, rag_tools_1.estimateTokens)(content, llmType);
    }, 0);
}
async function summarizeMessages(messages, model) {
    const prompt = `Summarize the following conversation:\n\n${messages.map((m) => `${m.getType().toUpperCase()}: ${normalizeContent(m.content)}`).join("\n")}`;
    const res = await model.query([new messages_1.HumanMessage(prompt)]);
    if (typeof res.result === "string")
        return res.result;
    // if (Array.isArray(res.result)) {
    //   return res.result
    //     .map((part) => {
    //       if (typeof part === "string") return part;
    //       if (typeof part === "object" && "text" in part && typeof part.text === "string") {
    //         return part.text;
    //       }
    //       return "";
    //     })
    //     .join("");
    // }
    return "";
}
function buildFromSummary(summary, recent, userMsg, tokenLimit, reservedForResponse, llmType) {
    const system = new messages_1.SystemMessage(summary);
    const context = [system, ...recent, userMsg];
    const total = estimateMessagesTokens(context, llmType);
    return total <= tokenLimit - reservedForResponse ? context : null;
}
function fallbackTrim(summary, recent, userMsg, tokenLimit, reservedForResponse, llmType) {
    const system = new messages_1.SystemMessage(summary);
    const trimmed = [...recent];
    while (estimateMessagesTokens([system, ...trimmed, userMsg], llmType) > tokenLimit - reservedForResponse && trimmed.length > 0) {
        trimmed.shift();
    }
    return [system, ...trimmed, userMsg];
}
async function createLazySummaryContext({ model, messages, userInput, summary, tokenLimit = 4096, reservedForResponse = 300, llmType = "openai", }) {
    const userMsg = new messages_1.HumanMessage(userInput);
    //vzdy pridame alespon posledni zpravu a odpoved LLM
    let msgs = [userMsg];
    if (messages.length >= 2) {
        msgs.unshift(messages[messages.length - 1]);
        msgs.unshift(messages[messages.length - 2]);
    }
    for (let i = messages.length - 3; i >= 0; i--) {
        let tokens = estimateMessagesTokens([...msgs, messages[i]], llmType);
        if (tokens > tokenLimit - reservedForResponse) {
            break;
        }
        msgs.unshift(messages[i]);
    }
    return { messages: msgs, updatedSummary: "" };
    /*
    const fullTokens = estimateMessagesTokens(messages, llmType) + estimateTokens(userInput, llmType);
  
    if (fullTokens <= tokenLimit - reservedForResponse) {
      return { context: [...messages, userMsg], updatedSummary: summary ?? null };
    }
  
    const mid = Math.floor(messages.length / 2);
    const old = messages.slice(0, mid);
    const recent = messages.slice(mid);
  
    // Try with existing summary
    if (summary) {
      const withCachedSummary = buildFromSummary(summary, recent, userMsg, tokenLimit, reservedForResponse, llmType);
      if (withCachedSummary) return { context: withCachedSummary, updatedSummary: summary };
    }
  
    // Summarize old messages
    const newSummary = await summarizeMessages(old, model);
  
    const withNewSummary = buildFromSummary(newSummary, recent, userMsg, tokenLimit, reservedForResponse, llmType);
    if (withNewSummary) return { context: withNewSummary, updatedSummary: newSummary };
  
    // Fallback: trim
    const fallbackContext = fallbackTrim(newSummary, recent, userMsg, tokenLimit, reservedForResponse, llmType);
    return { context: fallbackContext, updatedSummary: newSummary };
    */
}
