`mongot` runs as a separate process alongside `mongod`.  
When configured, `mongot` handles requests related to search and index management for `mongod`.

The mongot binary for search community edition is in Private Preview.  
It is available for testing in order to gather feedback.  
Do not use the mongot binary for production deployments.

## Setup

1. Create a keyfile for the connection between mongod and mongot.
    * `mkdir data && echo keyfile > data/keyfile && chmod 600 data/keyfile`
    * If you already have replication enabled you don't need to create another keyfile, and you
      can keep your existing `replSetName` and `keyFile` configurations in the following step.

2. Configure mongod
    * If you're using a configuration file, add these lines, modifying the values of `mongotHost` and `searchIndexManagementHostAndPort` as appropriate:
      ```yaml
      replication:
        replSetName: rs0
      security:
        keyFile: data/keyfile
      setParameter:
        mongotHost: localhost:27027
        searchIndexManagementHostAndPort: localhost:27027
      ```

    * If you're using command line flags, add these:
        ```shell
        --replSet rs0
        --keyFile data/keyfile
        --setParameter "mongotHost=localhost:27027"
        --setParameter "searchIndexManagementHostAndPort=localhost:27027"
        ```

3. Restart mongod. If a new replica set was created, connect and run `rs.initiate()`

4. Configure mongot.
   * Create a configuration file; the `metrics` and `logging` sections are optional.
   ```yaml
    communityPrivatePreview:
      # Socket (IPv4/6) address of the sync source mongod.
      mongodHostAndPort: "localhost:27017"

      # Socket (IPv4/6) address on which to listen for wire protocol connections.
      queryServerAddress: "localhost:27027"

      # Keyfile used for mongod -> mongot authentication.
      keyFilePath: "data/keyfile"

      # Filesystem path that all mongot data will be stored at.
      dataPath: "data/mongot"

      # Options for metrics
      metrics:
        # Whether to enable the Prometheus metrics endpoint.
        enabled: true
        # Socket address (IPv4/6) on which the Prometheus /metrics endpoint will be exposed.
        address: "localhost:9946"

      # Options for logging
      logging:
        # Log level
        verbosity: INFO
      ```

5. Start mongot: `./mongot --config communityConfig.yml`

6. Test the local Atlas Search server.
    ```js
    db.coll.createSearchIndex({"mappings": {"dynamic": true}})
    db.coll.aggregate([{"$listSearchIndexes": {}}])
    db.coll.dropSearchIndex("default")
    ```

## Search Index Management

All current versions of MongoDB allow search index management directly through mongosh or a supported
driver. See https://mdb.link/atlas-search-index for more information.

## License

mongot is subject to the License Agreement contained herein.
