if [[ ! -f "/data/certs/mosquitto/ca/ca.crt" ]]
then

mkdir -p /data/certs/mosquitto
mkdir -p /data/certs/mongod


#mosquito
    cd /usr/share/easy-rsa
    ./easyrsa clean-all
    ./easyrsa init-pki
    ./easyrsa build-ca nopass

    #server key
    ./easyrsa gen-req broker nopass
    ./easyrsa sign-req server broker
    openssl rsa -in ./pki/private/broker.key -out /etc/mosquitto/certs/broker/broker.key

    #server key
    ./easyrsa gen-req client nopass
    ./easyrsa sign-req client client
    openssl rsa -in ./pki/private/client.key -out /etc/mosquitto/certs/client/client.key

    cp ./pki/issued/broker.crt /etc/mosquitto/certs/broker/
    cp ./pki/issued/client.crt /etc/mosquitto/certs/client/
    cp ./pki/ca.crt /etc/mosquitto/certs/ca/

    chmod 755 /etc/mosquitto/certs/* -R
    cp /etc/mosquitto/certs/* /data/certs/mosquitto/ -R

#mongo
    # Generate self signed root CA cert
    openssl req -nodes -x509 -newkey rsa:2048 -days 3650 -keyout /etc/mongod/certs/ca/ca.key -out /etc/mongod/certs/ca/ca.crt -subj "/C=CZ/ST=CZECH/L=Prague/O=MongoDB/OU=root/CN=`hostname -f`/emailAddress=info@mmyscada.org"
    # Generate server cert to be signed
    openssl req -nodes -newkey rsa:2048 -days 3650 -keyout /etc/mongod/certs/server/server.key -out /etc/mongod/certs/server/server.csr -subj "/C=CZ/ST=CZECH/L=Prague/O=MongoDB/OU=root/CN=`hostname -f`/emailAddress=info@mmyscada.org"
    # Sign the server cert
    openssl x509 -req -days 3650 -in /etc/mongod/certs/server/server.csr -CA /etc/mongod/certs/ca/ca.crt -CAkey /etc/mongod/certs/ca/ca.key -CAcreateserial -out /etc/mongod/certs/server/server.crt
    # Create server PEM file
    cat /etc/mongod/certs/server/server.key /etc/mongod/certs/server/server.crt > /etc/mongod/certs/server/server.pem

    # Generate client cert to be signed
    openssl req -nodes -newkey rsa:2048 -days 3650 -keyout /etc/mongod/certs/client/client.key -out /etc/mongod/certs/client/client.csr -subj "/C=AU/ST=NSW/L=Sydney/O=MongoDB/OU=client/CN=`hostname -f`/emailAddress=kevinadi@mongodb.com"
    # Sign the client cert
    openssl x509 -req -days 3650 -in /etc/mongod/certs/client/client.csr -CA /etc/mongod/certs/ca/ca.crt -CAkey /etc/mongod/certs/ca/ca.key -CAserial /etc/mongod/certs/ca/ca.srl -out /etc/mongod/certs/client/client.crt
    # Create client PEM file
    cat /etc/mongod/certs/client/client.key /etc/mongod/certs/client/client.crt > /etc/mongod/certs/client/client.pem

    cp /etc/mongod/certs/* /data/certs/mongod/ -R

fi


#nginx
    openssl req -x509 -nodes -days 3650 -newkey rsa:2048 -keyout /etc/nginx/certs/nginx.key -out /etc/nginx/certs/nginx.crt -config /usr/share/easy-rsa/vars.nginx -subj "/C=CZ/ST=CZECH/L=Prague/O=MongoDB/OU=root/CN=`hostname -f`/emailAddress=info@mmyscada.org"