/// <reference types="node" />
import { EventEmitter } from 'events';
import Service from './service';
import { MulticastDNS } from 'multicast-dns';
export interface BrowserConfig {
    type: string;
    protocol?: 'tcp' | 'udp';
    subtypes?: Array<string>;
    txt?: Record<string, string>;
}
/**
 * Start a browser
 *
 * The browser listens for services by querying for PTR records of a given
 * type, protocol and domain, e.g. _http._tcp.local.
 *
 * If no type is given, a wild card search is performed.
 *
 * An internal list of online services is kept which starts out empty. When
 * ever a new service is discovered, it's added to the list and an "up" event
 * is emitted with that service. When it's discovered that the service is no
 * longer available, it is removed from the list and a "down" event is emitted
 * with that service.
 */
export declare class Browser extends EventEmitter {
    private mdns?;
    private onresponse?;
    private serviceMap;
    private txt?;
    private name?;
    private wildcard;
    private _services;
    constructor(mdns: MulticastDNS, opts: any, onup?: (service: Service) => void);
    start(): void;
    stop(): void;
    update(): void;
    get services(): any[];
    private addService;
    private removeService;
    private goodbyes;
    private buildServicesFor;
}
export default Browser;
