import Browser, { BrowserConfig } from './lib/browser';
import Service, { ServiceConfig, ServiceReferer } from './lib/service';
export declare class Bonjour {
    private server;
    private registry;
    private timerId;
    /**
     * Setup bonjour service with optional config
     * @param opts ServiceConfig | undefined
     * @param errorCallback Function | undefined
     */
    constructor(opts?: ServiceConfig, errorCallback?: Function | undefined);
    /**
     * Publish a service for the device with options
     * @param opts
     * @returns
     */
    publish(opts: ServiceConfig): Service;
    /**
     * Unpublish all services for the device
     * @param callback
     * @returns
     */
    unpublishAll(callback?: CallableFunction | undefined): void;
    /**
     * Find services on the network with options
     * @param opts BrowserConfig
     * @param onup Callback when up event received
     * @returns
     */
    find(opts?: BrowserConfig | undefined, onup?: (service: Service) => void): Browser;
    /**
     * Find a single device and close browser
     * @param opts BrowserConfig
     * @param timeout Timeout (ms) if not device is found, default 10s
     * @param callback Callback when device found
     * @returns
     */
    findOne(opts?: BrowserConfig | undefined, timeout?: number, callback?: CallableFunction): Browser;
    /**
     * Destroy the class
     */
    destroy(callback?: () => void): void;
}
export { Service, ServiceReferer, ServiceConfig, Browser, BrowserConfig };
export default Bonjour;
