import { IOpenAPIDefaultSetter, OpenAPIDefaultSetterArgs } from 'openapi-default-setter';
import { IOpenAPIRequestCoercer, OpenAPIRequestCoercerArgs } from 'openapi-request-coercer';
import { IOpenAPIRequestValidator, OpenAPIRequestValidatorArgs } from 'openapi-request-validator';
import { IOpenAPIResponseValidator, OpenAPIResponseValidatorArgs } from 'openapi-response-validator';
import { IOpenAPISecurityHandler, OpenAPISecurityHandlerArgs, SecurityHandlers } from 'openapi-security-handler';
import { IJsonSchema, OpenAPIV2, OpenAPIV3 } from 'openapi-types';
import { Logger } from 'ts-log';
import BasePath from './BasePath';
import * as Ajv from 'ajv';
export { OpenAPIFrameworkArgs, OpenAPIFrameworkConstructorArgs, OpenAPIErrorTransformer, };
export declare class ConsoleDebugAdapterLogger implements Logger {
    /**
     * `console.debug` is just an alias for `.log()`, and we want debug logging to be optional.
     * This class delegates to `console` and overrides `.debug()` to be a no-op.
     */
    debug(message?: any, ...optionalParams: any[]): void;
    error(message?: any, ...optionalParams: any[]): void;
    info(message?: any, ...optionalParams: any[]): void;
    trace(message?: any, ...optionalParams: any[]): void;
    warn(message?: any, ...optionalParams: any[]): void;
}
declare type OpenAPIErrorTransformer = ({}: {}, {}: {}) => object;
declare type PathSecurityTuple = [RegExp, SecurityRequirement[]];
interface SecurityRequirement {
    [name: string]: SecurityScope[];
}
declare type SecurityScope = string;
export interface OpenAPIFrameworkPathObject {
    path?: string;
    module?: any;
}
export interface IOpenAPIFramework {
    featureType: string;
    loggingPrefix: string;
    name: string;
}
interface OpenAPIFrameworkConstructorArgs extends OpenAPIFrameworkArgs {
    featureType: string;
    name: string;
}
interface OpenAPIFrameworkArgs {
    apiDoc: OpenAPIV2.Document | OpenAPIV3.Document | string;
    customFormats?: {
        [format: string]: (arg: any) => boolean;
    };
    customKeywords?: {
        [keywordName: string]: Ajv.KeywordDefinition;
    };
    dependencies?: {
        [service: string]: any;
    };
    enableObjectCoercion?: boolean;
    errorTransformer?: OpenAPIErrorTransformer;
    features?: {
        coercer?: new (args: OpenAPIRequestCoercerArgs) => IOpenAPIRequestCoercer;
        defaultSetter?: new (args: OpenAPIDefaultSetterArgs) => IOpenAPIDefaultSetter;
        requestValidator?: new (args: OpenAPIRequestValidatorArgs) => IOpenAPIRequestValidator;
        responseValidator?: new (args: OpenAPIResponseValidatorArgs) => IOpenAPIResponseValidator;
        securityHandler?: new (args: OpenAPISecurityHandlerArgs) => IOpenAPISecurityHandler;
    };
    externalSchemas?: {
        [index: string]: IJsonSchema;
    };
    pathSecurity?: PathSecurityTuple[];
    operations?: {
        [operationId: string]: ((...arg: any[]) => any) | ((...arg: any[]) => any)[];
    };
    paths?: string | OpenAPIFrameworkPathObject[];
    pathsIgnore?: RegExp;
    routesGlob?: string;
    routesIndexFileRegExp?: RegExp;
    securityHandlers?: SecurityHandlers;
    validateApiDoc?: boolean;
    logger?: Logger;
}
export interface OpenAPIFrameworkAPIContext {
    basePaths: BasePath[];
    getApiDoc(): any;
}
export interface OpenAPIFrameworkPathContext {
    basePaths: BasePath[];
    getApiDoc(): any;
    getPathDoc(): any;
}
export interface OpenAPIFrameworkOperationContext {
    additionalFeatures: any[];
    allowsFeatures: boolean;
    apiDoc: any;
    basePaths: BasePath[];
    consumes: string[];
    features: {
        coercer?: IOpenAPIRequestCoercer;
        defaultSetter?: IOpenAPIDefaultSetter;
        requestValidator?: IOpenAPIRequestValidator;
        responseValidator?: IOpenAPIResponseValidator;
        securityHandler?: IOpenAPISecurityHandler;
    };
    methodName: string;
    methodParameters: any[];
    operationDoc: any;
    operationHandler: any;
    path: string;
}
export interface OpenAPIFrameworkVisitor {
    visitApi?(context: OpenAPIFrameworkAPIContext): void;
    visitPath?(context: OpenAPIFrameworkPathContext): void;
    visitOperation?(context: OpenAPIFrameworkOperationContext): void;
}
