import BasePath from './src/BasePath';
import { IOpenAPIFramework, OpenAPIFrameworkAPIContext, OpenAPIFrameworkArgs, OpenAPIFrameworkConstructorArgs, OpenAPIFrameworkOperationContext, OpenAPIFrameworkPathContext, OpenAPIFrameworkPathObject, OpenAPIFrameworkVisitor } from './src/types';
export { OpenAPIRequestValidatorError } from 'openapi-request-validator';
export { OpenAPIResponseValidatorError } from 'openapi-response-validator';
export { SecurityHandlers } from 'openapi-security-handler';
export { BasePath, OpenAPIFrameworkArgs, OpenAPIFrameworkConstructorArgs, OpenAPIFrameworkPathContext, OpenAPIFrameworkPathObject, OpenAPIFrameworkAPIContext, OpenAPIFrameworkOperationContext, };
export default class OpenAPIFramework implements IOpenAPIFramework {
    protected args: OpenAPIFrameworkConstructorArgs;
    readonly apiDoc: any;
    readonly basePaths: BasePath[];
    readonly featureType: any;
    readonly loggingPrefix: any;
    readonly name: any;
    private customFormats;
    private customKeywords;
    private dependencies;
    private enableObjectCoercion;
    private errorTransformer;
    private externalSchemas;
    private features;
    private originalApiDoc;
    private operations;
    private paths;
    private pathsIgnore;
    private pathSecurity;
    private routesGlob;
    private routesIndexFileRegExp;
    private securityHandlers;
    private validateApiDoc;
    private validator;
    private logger;
    constructor(args?: OpenAPIFrameworkConstructorArgs);
    initialize(visitor: OpenAPIFrameworkVisitor): Promise<void>;
}
