"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
exports.__esModule = true;
var OpenAPIDefaultSetter = /** @class */ (function () {
    function OpenAPIDefaultSetter(args) {
        var loggingKey = args && args.loggingKey ? args.loggingKey + ': ' : '';
        if (!args) {
            throw new Error(loggingKey + 'missing args argument');
        }
        if (!Array.isArray(args.parameters)) {
            throw new Error(loggingKey + 'args.parameters must be an Array');
        }
        this.headersDefaults = getDefaults('header', args.parameters);
        this.queryDefaults = getDefaults('query', args.parameters);
    }
    OpenAPIDefaultSetter.prototype.handle = function (request) {
        if (request.headers && this.headersDefaults) {
            setDefaults(request.headers, this.headersDefaults);
        }
        if (request.query && this.queryDefaults) {
            setDefaults(request.query, this.queryDefaults);
        }
    };
    return OpenAPIDefaultSetter;
}());
exports["default"] = OpenAPIDefaultSetter;
function byLocation(location) {
    return function (param) {
        return param["in"] === location;
    };
}
function hasSchema(obj) {
    return 'schema' in obj;
}
function resolveDefaultValue(parameter) {
    if ('default' in parameter) {
        return parameter["default"];
    }
    if (hasSchema(parameter)) {
        return parameter.schema && parameter.schema["default"];
    }
    return undefined;
}
function resolveName(parameter) {
    if (parameter["in"] === 'header') {
        return parameter.name.toLowerCase();
    }
    return parameter.name;
}
function getDefaults(location, parameters) {
    var defaults = parameters
        .filter(byLocation(location))
        .reduce(function (result, param) {
        var _a;
        var name = resolveName(param);
        var defaultValue = resolveDefaultValue(param);
        if (defaultValue === undefined) {
            return result;
        }
        return __assign(__assign({}, result), (_a = {}, _a[name] = defaultValue, _a));
    }, {});
    return Object.keys(defaults).length ? defaults : undefined;
}
function setDefaults(obj, defaults) {
    for (var name_1 in defaults) {
        if (!(name_1 in obj)) {
            obj[name_1] = defaults[name_1];
        }
    }
}
//# sourceMappingURL=index.js.map