"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Xml2JsonFs = void 0;
const fs_1 = __importDefault(require("fs"));
const xml2json_1 = require("../xml2json");
class Xml2JsonFs extends xml2json_1.Xml2Json {
    /**
     * @param xmlFile - the name of the xml file to parse.
     */
    async parse(xmlFile) {
        // slightly faster but require more memory ..
        let data = await fs_1.default.promises.readFile(xmlFile);
        if (data[0] === 0xef && data[1] === 0xbb && data[2] === 0xbf) {
            data = data.subarray(3);
        }
        const dataAsString = data.toString();
        return this.__parseInternal(dataAsString);
    }
}
exports.Xml2JsonFs = Xml2JsonFs;
//# sourceMappingURL=xml2json_fs.js.map