"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransportPairSocket = void 0;
const net_1 = __importDefault(require("net"));
const fake_server_1 = require("./fake_server");
class TransportPairSocket {
    client;
    server;
    _server;
    constructor({ port }) {
        this.server = null;
        this._server = new fake_server_1.FakeServer({ port });
        this.client = new net_1.default.Socket();
        this.client.connect(port, (err) => {
            /** */
        });
    }
    initialize(done) {
        this._server.initialize(() => {
            this._server.tcpServer.on("connection", (socket) => {
                if (this.server)
                    return done(new Error("already connected"));
                this.server = socket;
                done();
            });
        });
    }
    shutdown(done) {
        this.client.end(() => {
            this._server.shutdown((err) => {
                done(err);
            });
        });
    }
}
exports.TransportPairSocket = TransportPairSocket;
//# sourceMappingURL=transport_pair_socket.js.map