"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringToQualifiedName = void 0;
exports.constructBrowsePathFromQualifiedName = constructBrowsePathFromQualifiedName;
/**
 * @module node-opcua-service-translate-browse-path
 */
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const imports_1 = require("./imports");
// const hierarchicalReferencesId = makeNodeId(ReferenceTypeIds.HierarchicalReferences);
const aggregatesReferencesId = (0, node_opcua_nodeid_1.makeNodeId)(node_opcua_constants_1.ReferenceTypeIds.Aggregates);
var node_opcua_data_model_1 = require("node-opcua-data-model");
Object.defineProperty(exports, "stringToQualifiedName", { enumerable: true, get: function () { return node_opcua_data_model_1.stringToQualifiedName; } });
/**
 * construct a browse path from an array of QualifiedName and a starting Node
 */
function constructBrowsePathFromQualifiedName(startingNode, targetNames) {
    targetNames = targetNames || [];
    const elements = targetNames.map((targetName) => {
        return {
            isInverse: false,
            includeSubtypes: true,
            referenceTypeId: aggregatesReferencesId,
            targetName
        };
    });
    const browsePath = new imports_1.BrowsePath({
        relativePath: { elements },
        startingNode: startingNode.nodeId // ROOT
    });
    return browsePath;
}
//# sourceMappingURL=tools_browse_path.js.map