"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveOperand = resolveOperand;
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_service_translate_browse_path_1 = require("node-opcua-service-translate-browse-path");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_types_1 = require("node-opcua-types");
const node_opcua_variant_1 = require("node-opcua-variant");
const warningLog = (0, node_opcua_debug_1.make_warningLog)("FILTER");
const debugLog = (0, node_opcua_debug_1.make_debugLog)("FILTER");
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)("FILTER");
// export function readOperand(context: FilterContext, operand: SimpleAttributeOperand): Variant {
//     // navigate to the innerNode specified by the browsePath [ QualifiedName]
//     const browsePath = constructBrowsePathFromQualifiedName({ nodeId: context.eventSource }, operand.browsePath);
//     const targetNode = context.browsePath(browsePath);
//     if (!targetNode) {
//         return new Variant({ dataType: DataType.Null });
//     }
//     return context.readNodeValue(targetNode);
// }
function resolveOperand(context, operand) {
    if (operand instanceof node_opcua_types_1.SimpleAttributeOperand) {
        const browsePath = (0, node_opcua_service_translate_browse_path_1.constructBrowsePathFromQualifiedName)({ nodeId: context.eventSource }, operand.browsePath);
        const target = context.browsePath(browsePath);
        if (!target) {
            return new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.Null });
            // return new Variant({ dataType: DataType.StatusCode, value: StatusCodes.BadNodeIdUnknown });
        }
        const nodeClass = context.getNodeClass(target);
        if (nodeClass !== node_opcua_data_model_1.NodeClass.Variable) {
            doDebug && debugLog("resolveOperand: cannot find variable here but got nodeClass", node_opcua_data_model_1.NodeClass[nodeClass], browsePath.toString());
            return new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.StatusCode, value: node_opcua_status_code_1.StatusCodes.BadNodeClassInvalid });
        }
        const value = context.readNodeValue(target);
        return value;
    }
    else {
        if (!(operand instanceof node_opcua_types_1.AttributeOperand)) {
            throw new Error("expecting an AttributeOperand");
        }
        warningLog("AttributeOperand is not yet implemented");
        return new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.Null });
    }
}
//# sourceMappingURL=resolve_operand.js.map