"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractEventFields = extractEventFields;
//
const extract_event_field_1 = require("../extract_event_field");
const filter_context_on_address_space_1 = require("./filter_context_on_address_space");
/**

 * extract a array of eventFields from a event node, matching the selectClauses
 * @param selectClauses
 * @param eventData : a pseudo Node that provides a browse Method and a readValue(nodeId)
 */
function extractEventFields(sessionContext, selectClauses, eventData) {
    const context = new filter_context_on_address_space_1.FilterContextOnAddressSpace(sessionContext, eventData);
    return (0, extract_event_field_1.extractEventFieldsBase)(context, selectClauses);
}
//# sourceMappingURL=extract_event_fields.js.map