"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.announcementToServiceConfig = announcementToServiceConfig;
/**
 * Convert an OPCUA mDNS Announcement into a ServiceConfig
 * @param announcement
 * @returns
 */
function announcementToServiceConfig(announcement) {
    const serviceConfig = {
        name: announcement.name,
        port: announcement.port,
        protocol: "tcp",
        host: announcement.host,
        txt: {
            caps: announcement.capabilities.sort().join(","),
            path: announcement.path
        },
        type: "opcua-tcp"
    };
    return serviceConfig;
}
//# sourceMappingURL=announcement_to_service_config.js.map