"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindRoleSet = bindRoleSet;
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_address_space_1 = require("node-opcua-address-space");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_data_model_1 = require("node-opcua-data-model");
function bindRoleSet(userManager, addressSpace) {
    const roleSet = addressSpace.findNode(node_opcua_constants_1.ObjectIds.Server_ServerCapabilities_RoleSet);
    if (!roleSet)
        return;
    const components = roleSet.getComponents();
    for (const component of components) {
        (0, node_opcua_address_space_1.ensureObjectIsSecure)(component);
        if (component.nodeClass !== node_opcua_data_model_1.NodeClass.Object) {
            continue;
        }
        const o = component;
        if (o.typeDefinitionObj.browseName.name !== "RoleType") {
            continue;
        }
        const roleType = o;
        const roleTypeProperties = roleType.findReferencesAsObject("HasChild", false);
        for (const roleTypeProp of roleTypeProperties) {
            (0, node_opcua_address_space_1.ensureObjectIsSecure)(roleTypeProp);
        }
        roleType.identities.setValueFromSource({ dataType: node_opcua_variant_1.DataType.ExtensionObject, value: [] });
        roleType.endpoints?.setValueFromSource({ dataType: node_opcua_variant_1.DataType.ExtensionObject, value: [] });
        roleType.identities.bindVariable({
            get: () => {
                const identities = userManager.getIdentitiesForRole(roleType.nodeId);
                return new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.ExtensionObject, value: identities });
            }
        }, true);
    }
    userManager.bind(roleSet);
}
//# sourceMappingURL=user_manager_ua.js.map