"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerSidePublishEngineForOrphanSubscription = void 0;
/**
 * @module node-opcua-server
 */
// tslint:disable:no-console
const chalk_1 = __importDefault(require("chalk"));
const node_opcua_debug_1 = require("node-opcua-debug");
const server_publish_engine_1 = require("./server_publish_engine");
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)(__filename);
/**
 * the ServerSidePublishEngineForOrphanSubscription is keeping track of
 * live subscription that have been detached from timed out session.
 * It takes care of providing back those subscription to any session that
 * will claim them again with transferSubscription  service
 * It also make sure that subscription are properly disposed when  they expire.
 *
 * @internal
 */
class ServerSidePublishEngineForOrphanSubscription extends server_publish_engine_1.ServerSidePublishEngine {
    constructor(options) {
        super(options);
    }
    add_subscription(subscription) {
        debugLog(chalk_1.default.bgCyan.yellow.bold(" adding live subscription with id="), subscription.id, " to orphan");
        // detach subscription from old session
        subscription.$session = undefined;
        super.add_subscription(subscription);
        // also add an event handler to detected when the subscription has ended
        // so we can automatically remove it from the orphan table
        subscription._expired_func = function () {
            debugLog(chalk_1.default.bgCyan.yellow(" Removing expired subscription with id="), this.id, " from orphan");
            // make sure all monitored item have been deleted
            // Xx subscription.terminate();
            // xx publish_engine.detach_subscription(subscription);
            // Xx subscription.dispose();
        };
        subscription.once("expired", subscription._expired_func);
        return subscription;
    }
    detach_subscription(subscription) {
        // un set the event handler
        super.detach_subscription(subscription);
        subscription.removeListener("expired", subscription._expired_func);
        subscription._expired_func = null;
        return subscription;
    }
}
exports.ServerSidePublishEngineForOrphanSubscription = ServerSidePublishEngineForOrphanSubscription;
//# sourceMappingURL=server_publish_engine_for_orphan_subscriptions.js.map